package com.zbkj.service.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zbkj.common.model.huifu.JsPayTrade;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <b>  </b>
 * @author ZXF
 * @create 2023/07/31 0031 11:08
 * @version
 * @注意事项 </b>
 */
public interface JsPayTradeDao extends BaseMapper<JsPayTrade> {

    /**
     * 插入企业钱包账户交易记录
     *
     * @param jsPayTrade
     * @return
     * @author llc
     * @date 2019-06-28
     */
    int insertJsPayTrade(JsPayTrade jsPayTrade);

    /**
     * <b> 根据流水号查是否存在已完成支付的记录 </b>
     * @author ZXF
     * @create 2023/04/04 0004 16:08
     * @version
     * @注意事项 </b>
     */
    int getJsPayTradeByReq(@Param("businessPartnerSeq") String businessPartnerSeq,@Param("tradeType") String tradeType);

    int getJsPayTradeByOldReq(@Param("businessPartnerSeq") String businessPartnerSeq,@Param("tradeType") String tradeType);
    /**
     * <b> 根据业务流水号查询交易记录 </b>
     * @author ZXF
     * @create 2023/09/07 0007 10:39
     * @version
     * @注意事项 </b>
     */
    JsPayTrade getHfReqIdByReq(@Param("businessPartnerSeq") String businessPartnerSeq);


    /**
     * 更新企业钱包账户交易记录
     *
     * @param jsPayTrade
     * @return
     * @author llc
     * @date 2019-06-28
     */
    int updateJsPayTrade(JsPayTrade jsPayTrade);


    /**
     * 查询企业钱包交易信息
     *
     * @param id
     * @return
     * @author llc
     * @date 2019-06-28
     */
    JsPayTrade getJsPayTradeById(@Param("id") Integer id);
    /**
     * <b> 根据全局流水号查询交易记录 </b>
     * @author ZXF
     * @create 2023/08/03 0003 17:52
     * @version
     * @注意事项 </b>
     */
    JsPayTrade getJsPayTradeByHfSeqId(@Param("hfSeqId") String hfSeqId);

    /**
     * <b> 根据业务编码或业务流水查询交易信息 </b>
     * @author ZXF
     * @create 2023/03/23 0023 10:17
     * @version
     * @注意事项 </b>
     */
    List<JsPayTrade> getJsPayTradeBySeqAndCode(JsPayTrade jsPayTrade);

    /**
     * <b> 查询企业钱包交易信息 </b>
     * @param id
     * @param uid (必填)
     * @param comment
     * @param tradeStatus
     * @author ZXF
     * @create 2022/06/27 0027 14:19
     * @version
     * @注意事项 </b>
     */
    List<JsPayTrade> findJsPayTrade(JsPayTrade jsPayTrade);

}
