package com.zbkj.service.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zbkj.common.model.bcx.BcxPerformanceReport;
import com.zbkj.common.response.BcxPerformanceReportResponse;
import com.zbkj.common.response.BcxPerformanceReportStatisticsResponse;

import java.util.List;
import java.util.Map;

/**
 * description: 业绩报表 Mapper
 * author : linchunpeng
 * date : 2023/8/3
 */
public interface BcxPerformanceReportDao extends BaseMapper<BcxPerformanceReport> {

    /**
     * 查询渠道商业绩报表
     */
    List<BcxPerformanceReportResponse> selectChannelList(Map<String, Object> paramMap);

    /**
     * 查询部门业绩报表
     */
    List<BcxPerformanceReportResponse> selectDepartmentList(Map<String, Object> paramMap);

    /**
     * 查询部门成员业绩报表
     */
    List<BcxPerformanceReportResponse> selectDepartmentMemberList(Map<String, Object> paramMap);

    /**
     * 查询分销商业绩报表
     */
    List<BcxPerformanceReportResponse> selectFxsList(Map<String, Object> paramMap);

    /**
     * 查询分销员业绩报表
     */
    List<BcxPerformanceReportResponse> selectFxyList(Map<String, Object> paramMap);

    /**
     * 查询user业绩报表
     */
    List<BcxPerformanceReportResponse> selectUserList(Map<String, Object> paramMap);



    /**
     * 渠道商业绩报表统计
     */
    BcxPerformanceReportStatisticsResponse selectChannelCount(Map<String, Object> paramMap);

    /**
     * 部门业绩报表统计
     */
    BcxPerformanceReportStatisticsResponse selectDepartmentCount(Map<String, Object> paramMap);

    /**
     * 部门成员业绩报表统计
     */
    BcxPerformanceReportStatisticsResponse selectDepartmentMemberCount(Map<String, Object> paramMap);

    /**
     * 分销商业绩报表统计
     */
    BcxPerformanceReportStatisticsResponse selectFxsCount(Map<String, Object> paramMap);

    /**
     * 分销员业绩报表统计
     */
    BcxPerformanceReportStatisticsResponse selectFxyCount(Map<String, Object> paramMap);

    /**
     * user业绩报表统计
     */
    BcxPerformanceReportStatisticsResponse selectUserCount(Map<String, Object> paramMap);
   
}