/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.wechat.video.PayComponentBrand;
import com.zbkj.common.vo.wxvedioshop.cat_brand.ShopBrandVo;
import com.zbkj.service.dao.PayComponentBrandDao;
import com.zbkj.service.service.PayComponentBrandService;
import com.zbkj.service.service.WechatVideoSpuService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class PayComponentBrandServiceImpl
extends ServiceImpl<PayComponentBrandDao, PayComponentBrand>
implements PayComponentBrandService {
    private final Logger logger = LoggerFactory.getLogger(PayComponentBrandServiceImpl.class);
    @Resource
    private PayComponentBrandDao dao;
    @Autowired
    private WechatVideoSpuService wechatVideoSpuService;
    @Autowired
    private TransactionTemplate transactionTemplate;

    @Override
    public void updateData() {
        List<ShopBrandVo> shopBrandList = this.wechatVideoSpuService.getShopBrandList();
        if (CollUtil.isEmpty(shopBrandList)) {
            this.logger.info("\u5fae\u4fe1\u672a\u8fd4\u56de\u54c1\u724c\u4fe1\u606f");
            return;
        }
        List brandList = shopBrandList.stream().map(e -> {
            PayComponentBrand brand = new PayComponentBrand();
            BeanUtils.copyProperties((Object)e, (Object)brand);
            return brand;
        }).collect(Collectors.toList());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.saveBatch(brandList);
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u66f4\u65b0\u81ea\u5b9a\u4e49\u4ea4\u6613\u54c1\u724c\u5217\u8868,\u64cd\u4f5c\u6570\u636e\u5e93\u65f6\u51fa\u9519");
        }
        this.logger.info(StrUtil.format((CharSequence)"\u81ea\u52a8\u66f4\u65b0\u81ea\u5b9a\u4e49\u4ea4\u6613\u54c1\u724c\u5217\u8868\u6210\u529f\uff0c\u65f6\u95f4{}", (Object[])new Object[]{DateUtil.now()}));
    }
}

