/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.merchant.MerchantCategory;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.MerchantCategoryRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.service.dao.MerchantCategoryDao;
import com.zbkj.service.service.MerchantCategoryService;
import com.zbkj.service.service.MerchantService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MerchantCategoryServiceImpl
extends ServiceImpl<MerchantCategoryDao, MerchantCategory>
implements MerchantCategoryService {
    @Resource
    private MerchantCategoryDao dao;
    @Autowired
    private MerchantService merchantService;

    @Override
    public PageInfo<MerchantCategory> getAdminPage(PageParamRequest pageParamRequest) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantCategory::getIsDel, (Object)false);
        lqw.orderByDesc(MerchantCategory::getId);
        List categoryList = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)categoryList);
    }

    @Override
    public Boolean add(MerchantCategoryRequest request) {
        if (this.checkName(request.getName()).booleanValue()) {
            throw new CrmebException("\u5206\u7c7b\u540d\u79f0\u91cd\u590d");
        }
        MerchantCategory merchantCategory = new MerchantCategory();
        BeanUtils.copyProperties((Object)request, (Object)merchantCategory);
        merchantCategory.setId(null);
        return this.dao.insert(merchantCategory) > 0;
    }

    @Override
    public Boolean edit(MerchantCategoryRequest request) {
        if (ObjectUtil.isNull((Object)request.getId())) {
            throw new CrmebException("\u5206\u7c7bID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MerchantCategory category = this.getByIdException(request.getId());
        if (!category.getName().equals(request.getName()) && this.checkName(request.getName()).booleanValue()) {
            throw new CrmebException("\u5206\u7c7b\u540d\u79f0\u91cd\u590d");
        }
        category.setName(request.getName());
        category.setHandlingFee(request.getHandlingFee());
        return this.dao.updateById(category) > 0;
    }

    @Override
    public Boolean delete(Integer id) {
        MerchantCategory category = this.getByIdException(id);
        if (this.merchantService.isExistCategory(category.getId()).booleanValue()) {
            throw new CrmebException("\u6709\u5546\u6237\u4f7f\u7528\u8be5\u5206\u7c7b\uff0c\u8bf7\u5148\u4fee\u6539\u5546\u6237");
        }
        category.setIsDel(Boolean.valueOf(true));
        return this.dao.updateById(category) > 0;
    }

    @Override
    public List<MerchantCategory> allList() {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{MerchantCategory::getId, MerchantCategory::getName, MerchantCategory::getHandlingFee});
        lqw.eq(MerchantCategory::getIsDel, (Object)false);
        lqw.orderByDesc(MerchantCategory::getId);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Map<Integer, MerchantCategory> allMap() {
        List<MerchantCategory> categoryList = this.allList();
        HashMap map = CollUtil.newHashMap();
        categoryList.forEach(c -> map.put(c.getId(), c));
        return map;
    }

    private Boolean checkName(String name) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{MerchantCategory::getId});
        lqw.eq(MerchantCategory::getName, (Object)name);
        lqw.eq(MerchantCategory::getIsDel, (Object)false);
        lqw.last(" limit 1");
        MerchantCategory merchantCategory = (MerchantCategory)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)merchantCategory);
    }

    private MerchantCategory getByIdException(Integer id) {
        MerchantCategory category = (MerchantCategory)this.getById(id);
        if (ObjectUtil.isNull((Object)category) || category.getIsDel().booleanValue()) {
            throw new CrmebException("\u5206\u7c7b\u4e0d\u5b58\u5728");
        }
        return category;
    }
}

