/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.util.http;

import com.bcxin.ins.util.http.HttpConfig;
import com.bcxin.ins.util.http.IRequest;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class HttpRequest
extends HttpConfig
implements IRequest {
    @Override
    public String doPost(String url, String content, String ctype, String charset) throws Exception {
        String useCharset = null == charset || "".equals(charset) ? "utf-8" : charset;
        byte[] reqContent = new byte[]{};
        if (content != null) {
            reqContent = content.getBytes(useCharset);
        }
        return this.doPost(url, ctype + ";charset=" + useCharset, reqContent);
    }

    public String doPostByAccept(String url, String content, String ctype, String charset) throws Exception {
        String useCharset = null == charset || "".equals(charset) ? "utf-8" : charset;
        byte[] reqContent = new byte[]{};
        if (content != null) {
            reqContent = content.getBytes(useCharset);
        }
        return this.doPostByAccept(url, ctype + ";charset=" + useCharset, reqContent);
    }

    public String doPost2(String url, String content, String ctype, String charset, Map<String, String> headInfo) throws Exception {
        String useCharset = null == charset || "".equals(charset) ? "utf-8" : charset;
        byte[] reqContent = new byte[]{};
        if (content != null) {
            reqContent = content.getBytes(useCharset);
        }
        return this.doPost2(url, ctype + ";charset=" + useCharset, reqContent, headInfo);
    }

    @Override
    public String doPostFile(String url, String fileName, byte[] content, String charset) throws Exception {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        String useCharset = null == charset || "".equals(charset) ? "utf-8" : charset;
        String boundary = "--------httppostfile";
        try {
            conn = this.getConnection(new URL(url), "POST", "multipart/form-data; boundary=" + boundary);
            out = conn.getOutputStream();
            StringBuffer strBuf = new StringBuffer();
            strBuf.append("\r\n");
            strBuf.append("--").append(boundary).append("\r\n");
            strBuf.append("Content-Disposition: form-data; name=\"file\"; filename=\"" + fileName + "\"\r\n");
            strBuf.append("Content-Type: application/octet-stream \r\n");
            strBuf.append("\r\n");
            out.write(strBuf.toString().getBytes(useCharset));
            out.write(content);
            strBuf.setLength(0);
            strBuf.append("\r\n");
            strBuf.append("--" + boundary + "--\r\n");
            strBuf.append("\r\n");
            out.write(strBuf.toString().getBytes());
            out.flush();
            rsp = this.getResponseAsString(conn);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (null != out) {
                out.close();
            }
            if (null != conn) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private String doPost(String url, String ctype, byte[] content) throws Exception {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = this.getConnection(new URL(url), "POST", ctype);
            out = conn.getOutputStream();
            out.write(content);
            out.flush();
            rsp = this.getResponseAsString(conn);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (null != out) {
                out.close();
            }
            if (null != conn) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private String doPostByAccept(String url, String ctype, byte[] content) throws Exception {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = this.getConnectionByAccept(new URL(url), "POST", ctype);
            out = conn.getOutputStream();
            out.write(content);
            out.flush();
            rsp = this.getResponseAsString(conn);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (null != out) {
                out.close();
            }
            if (null != conn) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private String doPost2(String url, String ctype, byte[] content, Map<String, String> headInfo) throws Exception {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = this.getConnection(new URL(url), "POST", ctype);
            if (headInfo != null) {
                for (Map.Entry<String, String> entry : headInfo.entrySet()) {
                    conn.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            out = conn.getOutputStream();
            out.write(content);
            out.flush();
            rsp = this.getResponseAsString(conn);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (null != out) {
                out.close();
            }
            if (null != conn) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    @Override
    public String doGet(String url) throws Exception {
        HttpURLConnection conn = null;
        String rsp = null;
        try {
            conn = this.getConnection(new URL(url), "GET", null);
            rsp = this.getResponseAsString(conn);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (null != conn) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    @Override
    public Map<String, Object> doGetFile(String url) throws Exception {
        HttpURLConnection conn = null;
        Map<String, Object> rsp = null;
        try {
            conn = this.getConnection(new URL(url), "GET", null);
            rsp = this.getResponseAsByteArray(conn);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (null != conn) {
                conn.disconnect();
            }
        }
        return rsp;
    }
}

