/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.util.excel;

import com.bcxin.ins.util.excel.ExcelVOAttribute;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtil<T> {
    Class<T> clazz;
    private StringBuffer errorMsg = new StringBuffer("");
    private int importCount;
    private int importError;
    private int firstRow;
    private List successRowList = new ArrayList();

    public int getFirstRow() {
        return this.firstRow;
    }

    public void setFirstRow(int firstRow) {
        this.firstRow = firstRow;
    }

    public List getSuccessRowList() {
        return this.successRowList;
    }

    public void setSuccessRowList(List successRowList) {
        this.successRowList = successRowList;
    }

    public int getImportCount() {
        return this.importCount;
    }

    public StringBuffer getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(StringBuffer errorMsg) {
        this.errorMsg = errorMsg;
    }

    public void setImportCount(int importCount) {
        this.importCount = importCount;
    }

    public int getImportError() {
        return this.importError;
    }

    public void setImportError(int importError) {
        this.importError = importError;
    }

    public ExcelUtil(Class<T> clazz) {
        this.clazz = clazz;
    }

    public Workbook getWorkbook(InputStream input, String ext) throws IOException {
        HSSFWorkbook wb = null;
        if (ext.toLowerCase().equals("xls")) {
            wb = new HSSFWorkbook(input);
        } else if (ext.toLowerCase().equals("xlsx")) {
            wb = new XSSFWorkbook(input);
        }
        return wb;
    }

    public List<T> importExcel(InputStream input, String ext) throws IOException {
        Workbook wb = this.getWorkbook(input, ext);
        return this.importExcel(wb);
    }

    public List<T> importExcelWithHeader(InputStream input, String ext) throws IOException {
        Workbook wb = this.getWorkbook(input, ext);
        return this.importExcelWithHeader(wb);
    }

    public List<T> importExcel(Workbook wb) {
        ArrayList<Object> list;
        block26: {
            int maxCol = 0;
            list = new ArrayList<Object>();
            try {
                Sheet sheet = wb.getSheetAt(0);
                int totalRows = sheet.getPhysicalNumberOfRows();
                if (totalRows <= 1) break block26;
                this.importCount = totalRows - 1;
                ArrayList<ExcelVOAttribute> columnList = new ArrayList<ExcelVOAttribute>();
                List<Field> allFields = this.getMappedFiled(this.clazz, null);
                HashMap<Integer, Field> fieldsMap = new HashMap<Integer, Field>();
                for (Field field : allFields) {
                    if (!field.isAnnotationPresent(ExcelVOAttribute.class)) continue;
                    ExcelVOAttribute attr = field.getAnnotation(ExcelVOAttribute.class);
                    int col = ExcelUtil.getExcelCol(attr.column());
                    columnList.add(attr);
                    maxCol = Math.max(col, maxCol);
                    field.setAccessible(true);
                    fieldsMap.put(col, field);
                }
                int totalCells = columnList.size();
                for (int r = 1; r < totalRows; ++r) {
                    Row row = sheet.getRow(r);
                    if (row == null) continue;
                    Object entity = null;
                    for (int c = 0; c < totalCells; c = (int)((short)(c + 1))) {
                        Cell cell = row.getCell(c);
                        if (cell == null || cell.toString() == null || "".equals(cell.toString().trim())) {
                            ExcelVOAttribute attribute = (ExcelVOAttribute)columnList.get(c);
                            if (!attribute.isRequest()) continue;
                            entity = null;
                            ++this.importError;
                            this.errorMsg.append("\u3010\u4e0d\u80fd\u4e3a\u7a7a\u3011:\u7b2c" + String.valueOf(r + 1) + "\u884c\uff1a\u3010" + ((ExcelVOAttribute)columnList.get(c)).name() + "\u3011<br>");
                            break;
                        }
                        entity = entity == null ? this.clazz.newInstance() : entity;
                        Field field = (Field)fieldsMap.get(c);
                        if (field == null) continue;
                        Class<?> fieldType = field.getType();
                        try {
                            Double d;
                            if (String.class == fieldType) {
                                try {
                                    DecimalFormat df = new DecimalFormat("0");
                                    field.set(entity, null != cell.toString() ? df.format(cell.getNumericCellValue()) : null);
                                }
                                catch (Exception e) {
                                    field.set(entity, null != cell.toString() ? String.valueOf(cell.toString().trim()) : null);
                                }
                                continue;
                            }
                            if (Integer.TYPE == fieldType || Integer.class == fieldType) {
                                try {
                                    d = cell.getNumericCellValue();
                                    field.set(entity, d.intValue());
                                    continue;
                                }
                                catch (Exception e) {
                                    throw new Exception("Integer");
                                }
                            }
                            if (Double.TYPE == fieldType || Double.class == fieldType) {
                                try {
                                    d = cell.getNumericCellValue();
                                    field.set(entity, d);
                                    continue;
                                }
                                catch (Exception e) {
                                    throw new Exception("Double");
                                }
                            }
                            if (Date.class != fieldType) continue;
                            try {
                                Date date = cell.getDateCellValue();
                                field.set(entity, date);
                                continue;
                            }
                            catch (Exception e) {
                                throw new Exception("Date");
                            }
                        }
                        catch (Exception e) {
                            String errmsg = e.getMessage();
                            if (errmsg.equals("Integer")) {
                                errmsg = ",\u7c7b\u578b\u5e94\u4e3a\u6574\u6570\u3002\u4f8b\u5982\uff1a20";
                            } else if (errmsg.equals("Double")) {
                                errmsg = ",\u7c7b\u578b\u5e94\u4e3a\u5c0f\u6570\u3002\u4f8b\u5982\uff1a20.12";
                            } else if (errmsg.equals("Date")) {
                                errmsg = ",\u7c7b\u578b\u5e94\u4e3a\u65e5\u671f\u3002\u4f8b\u5982\uff1a2017/01/01";
                            }
                            entity = null;
                            ++this.importError;
                            this.errorMsg.append("\u3010\u683c\u5f0f\u9519\u8bef\u3011:\u7b2c" + String.valueOf(r + 1) + "\u884c\uff1a\u3010" + ((ExcelVOAttribute)columnList.get(c)).name() + "\u3011" + errmsg + "<br>");
                            break;
                        }
                    }
                    if (entity == null) continue;
                    list.add(entity);
                    this.successRowList.add(String.valueOf(r + 1));
                }
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public List<T> importExcelWithHeader(Workbook wb) {
        ArrayList<Object> list;
        block26: {
            int maxCol = 0;
            list = new ArrayList<Object>();
            try {
                Sheet sheet = wb.getSheetAt(0);
                int totalRows = sheet.getPhysicalNumberOfRows();
                if (totalRows <= 2) break block26;
                this.importCount = totalRows - 2;
                ArrayList<ExcelVOAttribute> columnList = new ArrayList<ExcelVOAttribute>();
                List<Field> allFields = this.getMappedFiled(this.clazz, null);
                HashMap<Integer, Field> fieldsMap = new HashMap<Integer, Field>();
                for (Field field : allFields) {
                    if (!field.isAnnotationPresent(ExcelVOAttribute.class)) continue;
                    ExcelVOAttribute attr = field.getAnnotation(ExcelVOAttribute.class);
                    int col = ExcelUtil.getExcelCol(attr.column());
                    columnList.add(attr);
                    maxCol = Math.max(col, maxCol);
                    field.setAccessible(true);
                    fieldsMap.put(col, field);
                }
                int totalCells = columnList.size();
                for (int r = 2; r < totalRows; ++r) {
                    Row row = sheet.getRow(r);
                    if (row == null) continue;
                    Object entity = null;
                    for (int c = 0; c < totalCells; c = (int)((short)(c + 1))) {
                        Cell cell = row.getCell(c);
                        if (cell == null || cell.toString() == null || "".equals(cell.toString().trim())) {
                            ExcelVOAttribute attribute = (ExcelVOAttribute)columnList.get(c);
                            if (!attribute.isRequest()) continue;
                            entity = null;
                            ++this.importError;
                            this.errorMsg.append("\u3010\u4e0d\u80fd\u4e3a\u7a7a\u3011:\u7b2c" + String.valueOf(r + 1) + "\u884c\uff1a\u3010" + ((ExcelVOAttribute)columnList.get(c)).name() + "\u3011<br>");
                            break;
                        }
                        entity = entity == null ? this.clazz.newInstance() : entity;
                        Field field = (Field)fieldsMap.get(c);
                        if (field == null) continue;
                        Class<?> fieldType = field.getType();
                        try {
                            Double d;
                            if (String.class == fieldType) {
                                try {
                                    DecimalFormat df = new DecimalFormat("0");
                                    field.set(entity, null != cell.toString() ? df.format(cell.getNumericCellValue()) : null);
                                }
                                catch (Exception e) {
                                    field.set(entity, null != cell.toString() ? String.valueOf(cell.toString().trim()) : null);
                                }
                                continue;
                            }
                            if (Integer.TYPE == fieldType || Integer.class == fieldType) {
                                try {
                                    d = cell.getNumericCellValue();
                                    field.set(entity, d.intValue());
                                    continue;
                                }
                                catch (Exception e) {
                                    throw new Exception("Integer");
                                }
                            }
                            if (Double.TYPE == fieldType || Double.class == fieldType) {
                                try {
                                    d = cell.getNumericCellValue();
                                    field.set(entity, d);
                                    continue;
                                }
                                catch (Exception e) {
                                    throw new Exception("Double");
                                }
                            }
                            if (Date.class != fieldType) continue;
                            try {
                                Date date = cell.getDateCellValue();
                                field.set(entity, date);
                                continue;
                            }
                            catch (Exception e) {
                                throw new Exception("Date");
                            }
                        }
                        catch (Exception e) {
                            String errmsg = e.getMessage();
                            if (errmsg.equals("Integer")) {
                                errmsg = ",\u7c7b\u578b\u5e94\u4e3a\u6574\u6570\u3002\u4f8b\u5982\uff1a20";
                            } else if (errmsg.equals("Double")) {
                                errmsg = ",\u7c7b\u578b\u5e94\u4e3a\u5c0f\u6570\u3002\u4f8b\u5982\uff1a20.12";
                            } else if (errmsg.equals("Date")) {
                                errmsg = ",\u7c7b\u578b\u5e94\u4e3a\u65e5\u671f\u3002\u4f8b\u5982\uff1a2017/01/01";
                            }
                            entity = null;
                            ++this.importError;
                            this.errorMsg.append("\u3010\u683c\u5f0f\u9519\u8bef\u3011:\u7b2c" + String.valueOf(r + 1) + "\u884c\uff1a\u3010" + ((ExcelVOAttribute)columnList.get(c)).name() + "\u3011" + errmsg + "<br>");
                            break;
                        }
                    }
                    if (entity == null) continue;
                    list.add(entity);
                    this.successRowList.add(String.valueOf(r + 1));
                }
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static int getExcelCol(String col) {
        col = col.toUpperCase();
        int count = -1;
        char[] cs = col.toCharArray();
        for (int i = 0; i < cs.length; ++i) {
            count = (int)((double)count + (double)(cs[i] - 64) * Math.pow(26.0, cs.length - 1 - i));
        }
        return count;
    }

    private List<Field> getMappedFiled(Class clazz, List<Field> fields) {
        Field[] allFields;
        if (fields == null) {
            fields = new ArrayList<Field>();
        }
        for (Field field : allFields = clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ExcelVOAttribute.class)) continue;
            fields.add(field);
        }
        if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Object.class)) {
            this.getMappedFiled(clazz.getSuperclass(), fields);
        }
        return fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exportExcel(List<T> list, String sheetName, int sheetSize, OutputStream output) {
        Field[] allFields = this.clazz.getDeclaredFields();
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : allFields) {
            if (!field.isAnnotationPresent(ExcelVOAttribute.class)) continue;
            fields.add(field);
        }
        HSSFWorkbook workbook = new HSSFWorkbook();
        if (sheetSize > 65536 || sheetSize < 1) {
            sheetSize = 65536;
        }
        double sheetNo = list == null ? 0.0 : Math.ceil(list.size() / sheetSize);
        int index = 0;
        while ((double)index <= sheetNo) {
            HSSFCell cell;
            HSSFSheet sheet = workbook.createSheet();
            sheet.setDefaultColumnWidth(20);
            if (sheetNo == 0.0) {
                workbook.setSheetName(index, sheetName);
            } else {
                workbook.setSheetName(index, sheetName + index);
            }
            HSSFRow row = sheet.createRow(0);
            for (int i = 0; i < fields.size(); ++i) {
                Field field = (Field)fields.get(i);
                ExcelVOAttribute attr = field.getAnnotation(ExcelVOAttribute.class);
                int col = ExcelUtil.getExcelCol(attr.column());
                cell = row.createCell(col);
                cell.setCellType(1);
                cell.setCellValue(attr.name());
                if (!attr.prompt().trim().equals("")) {
                    ExcelUtil.setHSSFPrompt(sheet, "", attr.prompt(), 1, 100, col, col);
                }
                if (attr.combo().length <= 0) continue;
                ExcelUtil.setHSSFValidation(sheet, attr.combo(), 1, 100, col, col);
            }
            if (list != null && list.size() > 0) {
                int startNo = index * sheetSize;
                int endNo = Math.min(startNo + sheetSize, list.size());
                for (int i = startNo; i < endNo; ++i) {
                    row = sheet.createRow(i + 1 - startNo);
                    T vo = list.get(i);
                    for (int j = 0; j < fields.size(); ++j) {
                        Field field = (Field)fields.get(j);
                        Class<?> fieldType = field.getType();
                        field.setAccessible(true);
                        ExcelVOAttribute attr = field.getAnnotation(ExcelVOAttribute.class);
                        try {
                            if (!attr.isExport()) continue;
                            cell = row.createCell(ExcelUtil.getExcelCol(attr.column()));
                            if (String.class == fieldType) {
                                cell.setCellType(1);
                                cell.setCellValue(field.get(vo) == null ? "" : String.valueOf(field.get(vo)));
                                continue;
                            }
                            if (Integer.TYPE == fieldType || Integer.class == fieldType) {
                                if (field.get(vo) == null) continue;
                                cell.setCellType(0);
                                cell.setCellValue((double)Integer.valueOf(field.get(vo).toString()).intValue());
                                continue;
                            }
                            if (Double.TYPE == fieldType || Double.class == fieldType) {
                                if (field.get(vo) == null) continue;
                                cell.setCellType(0);
                                cell.setCellValue(Double.valueOf(field.get(vo).toString()).doubleValue());
                                continue;
                            }
                            if (Date.class != fieldType || field.get(vo) == null) continue;
                            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                            cell.setCellType(1);
                            cell.setCellValue(field.get(vo) == null ? "" : formatter.format(field.get(vo)));
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            ++index;
        }
        try {
            output.flush();
            workbook.write(output);
            output.close();
            index = 1;
            return index != 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Output is closed ");
            boolean bl = false;
            return bl;
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean exportExcelWithHeader(List<T> list, String sheetName, int sheetSize, OutputStream output, int headerHeight, String headerTitle) {
        Field[] allFields = this.clazz.getDeclaredFields();
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : allFields) {
            if (!field.isAnnotationPresent(ExcelVOAttribute.class)) continue;
            fields.add(field);
        }
        HSSFWorkbook workbook = new HSSFWorkbook();
        if (sheetSize > 65536 || sheetSize < 1) {
            sheetSize = 65536;
        }
        double sheetNo = list == null ? 0.0 : Math.ceil(list.size() / sheetSize);
        int index = 0;
        while ((double)index <= sheetNo) {
            HSSFCell cell;
            HSSFSheet sheet = workbook.createSheet();
            sheet.setDefaultColumnWidth(20);
            if (sheetNo == 0.0) {
                workbook.setSheetName(index, sheetName);
            } else {
                workbook.setSheetName(index, sheetName + index);
            }
            HSSFCellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setAlignment(HorizontalAlignment.LEFT);
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyle.setWrapText(true);
            HSSFFont font = workbook.createFont();
            font.setFontHeightInPoints((short)11);
            font.setColor(HSSFColor.BLACK.index);
            font.setFontName("\u9ed1\u4f53");
            cellStyle.setFont(font);
            HSSFRow row = sheet.createRow(0);
            row.setHeight((short)headerHeight);
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, (int)((short)(fields.size() - 1))));
            HSSFCell titleCell = row.createCell(0);
            titleCell.setCellValue(headerTitle);
            titleCell.setCellStyle(cellStyle);
            row = sheet.createRow(1);
            for (int i = 0; i < fields.size(); ++i) {
                Field field = (Field)fields.get(i);
                ExcelVOAttribute attr = field.getAnnotation(ExcelVOAttribute.class);
                int col = ExcelUtil.getExcelCol(attr.column());
                cell = row.createCell(col);
                cell.setCellType(1);
                cell.setCellValue(attr.name());
                if (!attr.prompt().trim().equals("")) {
                    ExcelUtil.setHSSFPrompt(sheet, "", attr.prompt(), 1, 100, col, col);
                }
                if (attr.combo().length <= 0) continue;
                ExcelUtil.setHSSFValidation(sheet, attr.combo(), 1, 100, col, col);
            }
            if (list != null && list.size() > 0) {
                int startNo = index * sheetSize;
                int endNo = Math.min(startNo + sheetSize, list.size());
                for (int i = startNo; i < endNo; ++i) {
                    row = sheet.createRow(i + 2 - startNo);
                    T vo = list.get(i);
                    for (int j = 0; j < fields.size(); ++j) {
                        Field field = (Field)fields.get(j);
                        Class<?> fieldType = field.getType();
                        field.setAccessible(true);
                        ExcelVOAttribute attr = field.getAnnotation(ExcelVOAttribute.class);
                        try {
                            if (!attr.isExport()) continue;
                            cell = row.createCell(ExcelUtil.getExcelCol(attr.column()));
                            if (String.class == fieldType) {
                                cell.setCellType(1);
                                cell.setCellValue(field.get(vo) == null ? "" : String.valueOf(field.get(vo)));
                                continue;
                            }
                            if (Integer.TYPE == fieldType || Integer.class == fieldType) {
                                if (field.get(vo) == null) continue;
                                cell.setCellType(0);
                                cell.setCellValue((double)Integer.valueOf(field.get(vo).toString()).intValue());
                                continue;
                            }
                            if (Double.TYPE == fieldType || Double.class == fieldType) {
                                if (field.get(vo) == null) continue;
                                cell.setCellType(0);
                                cell.setCellValue(Double.valueOf(field.get(vo).toString()).doubleValue());
                                continue;
                            }
                            if (Date.class != fieldType || field.get(vo) == null) continue;
                            SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.ENGLISH);
                            cellStyle = workbook.createCellStyle();
                            HSSFDataFormat format = workbook.createDataFormat();
                            cellStyle.setDataFormat(format.getFormat("yyyy/mm/dd"));
                            cell.setCellStyle(cellStyle);
                            cell.setCellValue(formatter.parse(field.get(vo).toString()));
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            ++index;
        }
        try {
            output.flush();
            workbook.write(output);
            output.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Output is closed ");
            return false;
        }
    }

    public static HSSFSheet setHSSFPrompt(HSSFSheet sheet, String promptTitle, String promptContent, int firstRow, int endRow, int firstCol, int endCol) {
        DVConstraint constraint = DVConstraint.createCustomFormulaConstraint((String)"DD1");
        CellRangeAddressList regions = new CellRangeAddressList(firstRow, endRow, firstCol, endCol);
        HSSFDataValidation data_validation_view = new HSSFDataValidation(regions, (DataValidationConstraint)constraint);
        data_validation_view.createPromptBox(promptTitle, promptContent);
        sheet.addValidationData((DataValidation)data_validation_view);
        return sheet;
    }

    public static HSSFSheet setHSSFValidation(HSSFSheet sheet, String[] textlist, int firstRow, int endRow, int firstCol, int endCol) {
        DVConstraint constraint = DVConstraint.createExplicitListConstraint((String[])textlist);
        CellRangeAddressList regions = new CellRangeAddressList(firstRow, endRow, firstCol, endCol);
        HSSFDataValidation data_validation_list = new HSSFDataValidation(regions, (DataValidationConstraint)constraint);
        sheet.addValidationData((DataValidation)data_validation_list);
        return sheet;
    }

    public static CellStyle getNecessaryTitleStyle(HSSFWorkbook wb) {
        HSSFCellStyle style = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setFontName("\u9ed1\u4f53");
        font.setFontHeightInPoints((short)12);
        font.setBold(true);
        font.setColor(HSSFColor.RED.index);
        style.setFont((Font)font);
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        HSSFDataFormat format = wb.createDataFormat();
        style.setDataFormat(format.getFormat("@"));
        return style;
    }

    public static CellStyle getCommonTitleStyle(HSSFWorkbook wb) {
        HSSFCellStyle style = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setFontName("\u9ed1\u4f53");
        font.setFontHeightInPoints((short)11);
        font.setBold(true);
        font.setColor(HSSFColor.BLACK.index);
        style.setFont((Font)font);
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        HSSFDataFormat format = wb.createDataFormat();
        style.setDataFormat(format.getFormat("@"));
        return style;
    }

    public static CellStyle getStringStyle(HSSFWorkbook wb) {
        HSSFCellStyle style = wb.createCellStyle();
        HSSFDataFormat format = wb.createDataFormat();
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        style.setDataFormat(format.getFormat("@"));
        return style;
    }

    public static CellStyle getOrangeStyle(HSSFWorkbook wb) {
        HSSFCellStyle style = wb.createCellStyle();
        HSSFDataFormat format = wb.createDataFormat();
        HSSFFont font = wb.createFont();
        font.setColor(IndexedColors.ORANGE.index);
        font.setFontHeightInPoints((short)11);
        font.setFontName("\u9ed1\u4f53");
        style.setFont((Font)font);
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        style.setDataFormat(format.getFormat("@"));
        return style;
    }

    public static CellStyle getColorStyle(HSSFWorkbook wb, short color) {
        HSSFCellStyle style = wb.createCellStyle();
        HSSFDataFormat format = wb.createDataFormat();
        HSSFFont font = wb.createFont();
        font.setColor(color);
        font.setFontHeightInPoints((short)11);
        font.setFontName("\u9ed1\u4f53");
        style.setFont((Font)font);
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        style.setDataFormat(format.getFormat("@"));
        return style;
    }

    public static HSSFDataValidation setDataValidation(String strFormula, int firstRow, int endRow, int firstCol, int endCol) {
        CellRangeAddressList regions = new CellRangeAddressList(firstRow, endRow, firstCol, endCol);
        DVConstraint constraint = DVConstraint.createFormulaListConstraint((String)strFormula);
        HSSFDataValidation dataValidation = new HSSFDataValidation(regions, (DataValidationConstraint)constraint);
        dataValidation.createErrorBox("Error", "Error");
        dataValidation.createPromptBox("", null);
        return dataValidation;
    }

    public static String getCellValue(Cell cell) {
        String cellValue = "";
        DataFormatter formatter = new DataFormatter();
        if (cell != null) {
            switch (cell.getCellType()) {
                case 0: {
                    int intValue;
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        cellValue = formatter.formatCellValue(cell);
                        break;
                    }
                    double value = cell.getNumericCellValue();
                    cellValue = value - (double)(intValue = (int)value) == 0.0 ? String.valueOf(intValue) : String.valueOf(value);
                    break;
                }
                case 1: {
                    cellValue = cell.getStringCellValue();
                    break;
                }
                case 4: {
                    cellValue = String.valueOf(cell.getBooleanCellValue());
                    break;
                }
                case 2: {
                    cellValue = String.valueOf(cell.getCellFormula());
                    break;
                }
                case 3: {
                    cellValue = "";
                    break;
                }
                case 5: {
                    cellValue = "";
                    break;
                }
                default: {
                    cellValue = cell.toString().trim();
                }
            }
        }
        return cellValue.trim();
    }
}

