/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.util.email;

import com.bcxin.ins.util.email.EmailModel;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.Security;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SEAMUtil {
    private static volatile SEAMUtil sendEmailAndMsgUtil;
    private static final String CHARSET = "utf-8";
    private static String host;
    private static String from;
    private static String bcc;
    private static String emailPassword;
    private static String bcxHead;
    private static String bcxFooter;
    private static Session session;
    private static String gasPolicy_path;
    private static String sender_username;
    private static Transport transport;
    private static MimeMessage message;
    public String typeName;
    static final Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SEAMUtil getSendEmailAndMsgUtil() {
        if (sendEmailAndMsgUtil != null) return sendEmailAndMsgUtil;
        Class<SEAMUtil> clazz = SEAMUtil.class;
        synchronized (SEAMUtil.class) {
            if (sendEmailAndMsgUtil != null) return sendEmailAndMsgUtil;
            sendEmailAndMsgUtil = new SEAMUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sendEmailAndMsgUtil;
        }
    }

    private SEAMUtil() {
    }

    public static void sendEmail(EmailModel emailModel) {
        if (emailModel.getTo() == null || emailModel.getTo().size() < 1) {
            return;
        }
        System.out.println("\u8fdb\u5165\u53d1\u9001\u90ae\u4ef6\u65b9\u6cd5=============");
        try {
            String typeName = "";
            String content = "";
            if (StrUtil.isNotBlank((CharSequence)emailModel.getEmailType())) {
                typeName = new SEAMUtil().getTypeName();
                content = bcxHead + "" + emailModel.getContent() + "" + bcxFooter;
            } else {
                content = emailModel.getContent();
            }
            Security.addProvider((java.security.Provider)new Provider());
            String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
            Properties props = System.getProperties();
            props.setProperty("mail.smtp.host", host);
            props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.setProperty("mail.smtp.socketFactory.fallback", "false");
            props.setProperty("mail.smtp.port", "465");
            props.setProperty("mail.smtp.socketFactory.port", "465");
            props.put("mail.smtp.auth", "true");
            final String username = from;
            final String password = emailPassword;
            Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password);
                }
            });
            System.out.println("\u8fdb\u5165\u53d1\u9001\u90ae\u4ef6\u65b9\u6cd5,\u83b7\u53d6session");
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(username));
            ArrayList<InternetAddress> list = new ArrayList<InternetAddress>();
            for (String recipient : emailModel.getTo()) {
                list.add(new InternetAddress(recipient));
            }
            InternetAddress[] address = list.toArray(new InternetAddress[list.size()]);
            msg.setRecipients(Message.RecipientType.TO, (Address[])address);
            msg.setSubject(emailModel.getSubject());
            System.out.println("\u8fdb\u5165\u53d1\u9001\u90ae\u4ef6\u65b9\u6cd5,\u52a0\u88c5\u914d\u7f6e");
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart contentPart = new MimeBodyPart();
            contentPart.setContent((Object)content, "text/html;charset=UTF-8");
            multipart.addBodyPart((BodyPart)contentPart);
            msg.setContent((Multipart)multipart);
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
            System.out.println("\u8fdb\u5165\u53d1\u9001\u90ae\u4ef6\u65b9\u6cd5,\u52a0\u88c5\u5185\u5bb9");
            logger.info(host + from + emailPassword);
            logger.info("email-send" + content.toString());
        }
        catch (Exception e) {
            logger.error("\u90ae\u4ef6\u5f02\u5e38", (Throwable)e);
        }
    }

    public static void sendPDFEmail(EmailModel emailModel, String proContNo) {
        if (emailModel.getTo() == null || emailModel.getTo().size() < 1) {
            return;
        }
        try {
            String typeName = "";
            String content = "";
            if (StrUtil.isNotBlank((CharSequence)emailModel.getEmailType())) {
                typeName = "\u767e\u5ddd\u4fe1";
                content = bcxHead + "" + emailModel.getContent() + "" + bcxFooter;
            }
            Properties props = new Properties();
            props.put("mail.smtp.host", host);
            props.put("mail.smtp.auth", "true");
            Session session = Session.getInstance((Properties)props, null);
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(from, typeName));
            message.setSubject(emailModel.getSubject());
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart bodyPart = new MimeBodyPart();
            bodyPart.setContent((Object)content, "text/html;charset=UTF-8");
            multipart.addBodyPart((BodyPart)bodyPart);
            if (proContNo != null) {
                SEAMUtil.pushPart(proContNo, (Multipart)multipart);
            }
            for (String filePath : emailModel.getFilePath()) {
                FileDataSource fds = new FileDataSource(filePath);
                MimeBodyPart attachBodyPart = new MimeBodyPart();
                attachBodyPart.setDataHandler(new DataHandler((DataSource)fds));
                attachBodyPart.setFileName(MimeUtility.encodeWord((String)fds.getName()));
                multipart.addBodyPart((BodyPart)attachBodyPart);
            }
            for (String recipient : emailModel.getTo()) {
                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(recipient));
            }
            message.setRecipient(MimeMessage.RecipientType.BCC, (Address)new InternetAddress(bcc, typeName));
            message.setContent((Multipart)multipart);
            message.saveChanges();
            Transport transport = session.getTransport("smtp");
            transport.connect(host, from, emailPassword);
            transport.sendMessage((Message)message, message.getAllRecipients());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void pushPart(String proContNo, Multipart multipart) throws MessagingException, UnsupportedEncodingException {
        File file = new File(gasPolicy_path, proContNo + ".pdf");
        if (file.exists()) {
            MimeBodyPart bodyPart = new MimeBodyPart();
            FileDataSource datasource = new FileDataSource(file);
            bodyPart.setDataHandler(new DataHandler((DataSource)datasource));
            bodyPart.setFileName(MimeUtility.encodeWord((String)(proContNo + ".pdf"), (String)CHARSET, null));
            multipart.addBodyPart((BodyPart)bodyPart);
        } else {
            String err = "\u6295\u4fdd\u5355\u53f7\uff1a" + proContNo + "\u8def\u5f84\uff1a" + file.getAbsolutePath();
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c" + err);
        }
    }

    public String getTypeName() {
        if (StrUtil.isBlank((String)this.typeName)) {
            this.typeName = "\u767e\u8054\u5b9d";
        }
        return this.typeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEmail(String subject, String sendHtml, String receiveUser) {
        try {
            InternetAddress from = new InternetAddress(sender_username);
            message.setFrom((Address)from);
            if (StrUtil.isBlank((String)receiveUser)) {
                return;
            }
            InternetAddress to = new InternetAddress(receiveUser);
            message.setRecipient(Message.RecipientType.TO, (Address)to);
            message.setSubject(subject);
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart contentPart = new MimeBodyPart();
            contentPart.setContent((Object)sendHtml, "text/html;charset=UTF-8");
            multipart.addBodyPart((BodyPart)contentPart);
            message.setContent((Multipart)multipart);
            message.saveChanges();
            transport = session.getTransport("smtp");
            transport.connect(host, sender_username, emailPassword);
            transport.sendMessage((Message)message, message.getAllRecipients());
            System.out.println("send success!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (transport != null) {
                try {
                    transport.close();
                }
                catch (MessagingException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    static {
        gasPolicy_path = "";
        sender_username = "";
        logger = LoggerFactory.getLogger(SEAMUtil.class);
        ResourceBundle rb = ResourceBundle.getBundle("properties/config");
        host = rb.getString("mail_host");
        from = rb.getString("mail_from");
        bcc = rb.getString("mail_bcc");
        emailPassword = rb.getString("mail_password");
        bcxHead = rb.getString("mail_bcxHead");
        bcxFooter = rb.getString("mail_bcxFooter");
        Properties props = new Properties();
        props.put("mail.smtp.host", host);
        props.put("mail.smtp.auth", "true");
        session = Session.getInstance((Properties)props, null);
        message = new MimeMessage(session);
        sender_username = from;
    }
}

