/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.util;

import com.bcxin.ins.spring.security.Digests;
import com.bcxin.ins.util.Encodes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Sha1Util {
    private static Logger log = LogManager.getLogger(Sha1Util.class);
    public static final String HASH_ALGORITHM = "SHA-1";
    public static final int HASH_INTERATIONS = 1024;
    public static final int SALT_SIZE = 8;

    public static String entryptPassword(String plainPassword) {
        String plain = Encodes.unescapeHtml((String)plainPassword);
        byte[] salt = Digests.generateSalt((int)8);
        byte[] hashPassword = Digests.sha1((byte[])plain.getBytes(), (byte[])salt, (int)1024);
        return Encodes.encodeHex((byte[])salt) + Encodes.encodeHex((byte[])hashPassword);
    }

    public static boolean validatePassword(String plainPassword, String password) {
        String plain = Encodes.unescapeHtml((String)plainPassword);
        byte[] salt = Encodes.decodeHex((String)password.substring(0, 16));
        byte[] hashPassword = Digests.sha1((byte[])plain.getBytes(), (byte[])salt, (int)1024);
        return password.equals(Encodes.encodeHex((byte[])salt) + Encodes.encodeHex((byte[])hashPassword));
    }

    public static void main(String[] args) {
        String password = "123456";
        System.out.printf(Sha1Util.entryptPassword(password), new Object[0]);
        String code = "6257b4cd2da410a43b758e2054f18a04823fd01a33e2ea5089653778";
        System.out.printf("\u503c\u662f\u5426\u76f8\u540c" + Sha1Util.validatePassword(password, code), new Object[0]);
    }
}

