/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.util;

import com.bcxin.ins.entity.common.ComRegion;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class RegionUtils {
    public static List<ComRegion> regionList = new ArrayList<ComRegion>();
    public static List<ComRegion> p_regionList = new ArrayList<ComRegion>();
    public static List<ComRegion> c_regionList = new ArrayList<ComRegion>();
    public static List<ComRegion> a_regionList = new ArrayList<ComRegion>();

    public static String getRegionNameByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return "";
        }
        if (code.endsWith("0000")) {
            return RegionUtils.getNameforEachRegionList(p_regionList, code);
        }
        if (code.endsWith("00")) {
            return RegionUtils.getNameforEachRegionList(c_regionList, code);
        }
        return RegionUtils.getNameforEachRegionList(a_regionList, code);
    }

    private static String getNameforEachRegionList(List<ComRegion> list, String code) {
        for (ComRegion region : list) {
            if (!region.getCodes().equals(code)) continue;
            return region.getNamed();
        }
        return "";
    }

    private static ComRegion getRegionforEachRegionList(List<ComRegion> list, String code) {
        for (ComRegion region : list) {
            if (!region.getCodes().equals(code)) continue;
            return region;
        }
        return null;
    }

    public static String getRegionNameByCodeTS(String code) {
        for (ComRegion region : regionList) {
            if (!region.getCodes().equals(code)) continue;
            if ("\u5e02\u8f96\u533a".equals(region.getNamed())) {
                for (ComRegion pRegion : regionList) {
                    if (!pRegion.getCodes().equals(region.getParent_id())) continue;
                    return pRegion.getNamed();
                }
            }
            return region.getNamed();
        }
        return "";
    }

    public static ComRegion getComRegionByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        if (code.endsWith("0000")) {
            return RegionUtils.getRegionforEachRegionList(p_regionList, code);
        }
        if (code.endsWith("00")) {
            return RegionUtils.getRegionforEachRegionList(c_regionList, code);
        }
        return RegionUtils.getRegionforEachRegionList(a_regionList, code);
    }

    public static List<ComRegion> findDistrictByParentCode(String codeLevel, String parentCode) {
        if (StringUtils.isEmpty((CharSequence)codeLevel) && StringUtils.isEmpty((CharSequence)parentCode)) {
            return regionList;
        }
        ArrayList<ComRegion> toDoList = new ArrayList<ComRegion>();
        if (StringUtils.isNotEmpty((CharSequence)codeLevel) && StringUtils.isEmpty((CharSequence)parentCode)) {
            return "1".equals(codeLevel) ? p_regionList : ("2".equals(codeLevel) ? c_regionList : ("3".equals(codeLevel) ? a_regionList : toDoList));
        }
        if (StringUtils.isNotEmpty((CharSequence)parentCode) && StringUtils.isEmpty((CharSequence)codeLevel)) {
            return regionList.stream().filter(e -> parentCode.contains(e.getParent_id())).collect(Collectors.toList());
        }
        if ("1".equals(codeLevel)) {
            return p_regionList.stream().filter(e -> parentCode.contains(e.getParent_id())).collect(Collectors.toList());
        }
        if ("2".equals(codeLevel)) {
            return c_regionList.stream().filter(e -> parentCode.contains(e.getParent_id())).collect(Collectors.toList());
        }
        if ("3".equals(codeLevel)) {
            return a_regionList.stream().filter(e -> parentCode.contains(e.getParent_id())).collect(Collectors.toList());
        }
        return toDoList;
    }

    public static String getRegionNameByALLCode(String pro, String cit, String are) {
        String result = "";
        if (StringUtils.isNotEmpty((CharSequence)are)) {
            return RegionUtils.getRegionName(are);
        }
        if (StringUtils.isNotEmpty((CharSequence)cit)) {
            return RegionUtils.getRegionName(cit);
        }
        if (StringUtils.isNotEmpty((CharSequence)pro)) {
            return RegionUtils.getRegionName(pro);
        }
        return result;
    }

    private static String getRegionName(String are) {
        ComRegion rg = RegionUtils.getComRegionByCode(are);
        if (rg != null && StringUtils.isNotEmpty((CharSequence)rg.getNamed_path())) {
            return rg.getNamed_path().replace("->", "");
        }
        return "";
    }
}

