/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.util;

import com.bcxin.ins.util.MD5Util;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PAC_MD5Util {
    private static final String HEX_CHARS = "0123456789abcdef";
    private static Log logger = LogFactory.getLog(MD5Util.class);

    private PAC_MD5Util() {
    }

    private static MessageDigest getDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static MessageDigest getDigestBySha() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] md5(byte[] data) {
        return PAC_MD5Util.getDigest().digest(data);
    }

    public static byte[] sha256(byte[] data) {
        return PAC_MD5Util.getDigestBySha().digest(data);
    }

    public static byte[] md5(String data) {
        byte[] bytes = null;
        try {
            bytes = PAC_MD5Util.md5(data.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"MD5\u52a0\u5bc6\u51fa\u9519\u3002", (Throwable)e);
        }
        return bytes;
    }

    public static String md5Hex(byte[] data) {
        return PAC_MD5Util.toHexString(PAC_MD5Util.md5(data));
    }

    public static String md5Hex(String data) {
        return PAC_MD5Util.toHexString(PAC_MD5Util.md5(data));
    }

    public static String sha256Hex(String data) {
        try {
            return PAC_MD5Util.toHexString(PAC_MD5Util.sha256(data.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"MD5\u52a0\u5bc6\u51fa\u9519\u3002", (Throwable)e);
            return null;
        }
    }

    private static String toHexString(byte[] b) {
        StringBuffer stringbuffer = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            stringbuffer.append(HEX_CHARS.charAt(b[i] >>> 4 & 0xF));
            stringbuffer.append(HEX_CHARS.charAt(b[i] & 0xF));
        }
        return stringbuffer.toString();
    }
}

