/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.util.HttpUtil;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsRoleInpolicy;
import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.http.RequestUtil;
import com.bcxin.ins.vo.InsPreservationRecordVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class OrderSupportUtil {
    private static Logger log = LoggerFactory.getLogger(OrderSupportUtil.class);
    private static final String ORDER_SYNCHRONIZATION = "/api/webOrderForm/receiveOrderFormData";
    private static final String TRAN_SYNCHRONIZATION = "/api/webOrderForm/receiveOrderPaymentData";
    private static final String ORDER_CANCELLATIONS = "/api/webOrderForm/cancellationOrder";

    public static String receiveOrderFormData(String sup_id, OrderFormVo orderVo, InsInsuranceSlip policy, InsTransaction itn, String insName) {
        String url = GlobalResources.map.get("YWZC_URL") + ORDER_SYNCHRONIZATION;
        log.info("\u8bf7\u6c42\u5730\u5740\uff1a" + url);
        HashMap<String, Object> orderMap = new HashMap<String, Object>();
        orderMap.put("sign", "BLB");
        orderMap.put("orderNumber", policy.getTrade_serial_number());
        orderMap.put("sign", "BLB");
        orderMap.put("orderDate", policy.getSigned_date() == null ? "" : DateUtil.convertDateToString(policy.getSigned_date(), "yyyy-MM-dd HH:mm:ss"));
        String paymentMethod = "";
        String stagesNumber = "";
        if (policy.getUnderwrite() != null && StringUtils.isNotEmpty((CharSequence)policy.getUnderwrite().getPayment_way())) {
            paymentMethod = policy.getUnderwrite().getPayment_way();
            stagesNumber = "1".equals(paymentMethod) ? "1" : ("2".equals(paymentMethod) ? "4" : null);
        } else if (itn != null) {
            paymentMethod = itn.getPayment_method();
            stagesNumber = "1".equals(itn.getPayment_method()) ? "1" : ("2".equals(itn.getPayment_method()) ? "4" : null);
        }
        orderMap.put("projectName", insName);
        orderMap.put("paymentMethod", paymentMethod);
        orderMap.put("stagesNumber", stagesNumber);
        orderMap.put("currency", "CNY");
        orderMap.put("startDate", DateUtil.convertDateToString(policy.getInception_date(), "yyyy-MM-dd HH:mm:ss"));
        orderMap.put("endDate", DateUtil.convertDateToString(policy.getPlanned_end_date(), "yyyy-MM-dd HH:mm:ss"));
        if (policy.getMailPolicy().getNeed_receipt() == 1) {
            orderMap.put("invoiceType", policy.getMailPolicy().getInvoice_type());
        } else {
            orderMap.put("invoiceType", "");
        }
        orderMap.put("productId", String.valueOf(policy.getPro_primary().getPro_primary_id()));
        orderMap.put("webUserId", String.valueOf(sup_id));
        List<InsRoleInpolicy> roleList = policy.getRolesOfKind("1");
        String province = "0";
        String city = "0";
        String area = "0";
        String address = "";
        if (roleList != null && roleList.size() > 0) {
            InsRoleInpolicy role = roleList.get(0);
            if (StringUtils.isNotEmpty((CharSequence)role.getReg_province())) {
                province = role.getReg_province();
            }
            if (StringUtils.isNotEmpty((CharSequence)role.getReg_city())) {
                city = role.getReg_city();
            }
            if (StringUtils.isNotEmpty((CharSequence)role.getReg_district())) {
                area = role.getReg_district();
            }
            if (StringUtils.isNotEmpty((CharSequence)role.getReg_address())) {
                address = role.getReg_address();
            }
        }
        orderMap.put("province", province);
        orderMap.put("city", city);
        orderMap.put("district", area);
        orderMap.put("address", address);
        if (policy.getRecommend_code() != null) {
            orderMap.put("distributorId", policy.getRecommend_code());
        }
        orderMap.put("fcy", policy.getPremium());
        orderMap.put("webOrderFormId", orderVo.getOid());
        orderMap.put("policyNo", orderVo.getExternal_reference());
        if (itn != null) {
            orderMap.put("orderPayment.paymentPeriod", "");
            orderMap.put("orderPayment.payDate", DateUtil.convertDateToString(itn.getStart_time(), "yyyy-MM-dd HH:mm:ss"));
            orderMap.put("orderPayment.payCode", itn.getPay_order_number() == null || "null".equals(itn.getPay_order_number()) || "".equals(itn.getPay_order_number()) ? "" : itn.getPay_order_number());
            orderMap.put("orderPayment.paySerialNumber", itn.getTrade_serial_number());
            orderMap.put("orderPayment.paymentMethod", itn.getPay_type());
            orderMap.put("orderPayment.remainingNumber", String.valueOf(policy.getInsTransaction().size()));
            orderMap.put("orderPayment.currentPayable", itn.getPay_amount() == null ? "0" : String.valueOf(itn.getPay_amount()));
            orderMap.put("orderPayment.actualPayment", itn.getOut_of_pocket() == null ? "0" : String.valueOf(itn.getOut_of_pocket()));
        } else {
            orderMap.put("orderPayment.paymentPeriod", "");
            orderMap.put("orderPayment.payDate", DateUtil.getCurrentDate());
            orderMap.put("orderPayment.payCode", "0");
            orderMap.put("orderPayment.paySerialNumber", "0");
            orderMap.put("orderPayment.paymentMethod", "0");
            orderMap.put("orderPayment.remainingNumber", "0");
            orderMap.put("orderPayment.currentPayable", StringUtils.isNotEmpty((CharSequence)stagesNumber) ? String.valueOf(policy.getPremium().divide(new BigDecimal(stagesNumber), 2, 4)) : String.valueOf(policy.getPremium()));
            orderMap.put("orderPayment.actualPayment", "0");
        }
        try {
            log.info("\u62a5\u6587\u683c\u5f0f\uff1aJSON");
            log.info("\u8bf7\u6c42\u62a5\u6587\uff1a" + ((Object)orderMap).toString());
            String result = HttpUtil.doPost2((String)url, orderMap);
            JSONObject json = JSON.parseObject((String)result);
            log.info("\u8fd4\u56de\u62a5\u6587\uff1a" + json.toString());
            if (json != null && json.get((Object)"success").toString().equals("true")) {
                return json.get((Object)"data").toString();
            }
        }
        catch (Exception ex) {
            log.info("\u8bf7\u6c42\u5f02\u5e38\uff1a" + ex.getMessage());
            ex.printStackTrace();
        }
        return "";
    }

    public static boolean receiveTrancetionData(InsInsuranceSlip policy, InsTransaction itn) {
        String url = GlobalResources.map.get("YWZC_URL") + TRAN_SYNCHRONIZATION;
        log.info("\u8bf7\u6c42\u5730\u5740\uff1a" + url);
        HashMap<String, Object> tranMap = new HashMap<String, Object>();
        tranMap.put("paymentPeriod", "");
        tranMap.put("payDate", DateUtil.convertDateToString(itn.getStart_time(), "yyyy-MM-dd HH:mm:ss"));
        tranMap.put("payCode", itn.getPay_order_number() == null || "null".equals(itn.getPay_order_number()) || "".equals(itn.getPay_order_number()) ? "" : itn.getPay_order_number());
        tranMap.put("paySerialNumber", itn.getTrade_serial_number());
        tranMap.put("paymentMethod", itn.getPay_type());
        tranMap.put("remainingNumber", "6".equals(itn.getPay_type()) ? itn.getPath_sign() : "1");
        tranMap.put("currentPayable", itn.getPay_amount());
        tranMap.put("actualPayment", itn.getOut_of_pocket() == null ? "0" : itn.getOut_of_pocket());
        tranMap.put("orderFormId", policy.getOrder_zc_id());
        try {
            log.info("\u62a5\u6587\u683c\u5f0f\uff1aJSON");
            log.info("\u8bf7\u6c42\u62a5\u6587\uff1a" + ((Object)tranMap).toString());
            String result = HttpUtil.doPost2((String)url, tranMap);
            log.info("\u8fd4\u56de\u62a5\u6587\uff1a" + result);
            JSONObject json = JSON.parseObject((String)result);
            if (json != null && json.get((Object)"success").toString().equals("true")) {
                log.info("\u652f\u4ed8\u4fe1\u606f\u63a8\u9001\u4e1a\u52a1\u652f\u6491\u7cfb\u7edf\u6210\u529f\uff1a" + json);
                return true;
            }
        }
        catch (Exception ex) {
            log.info("\u8bf7\u6c42\u5f02\u5e38\uff1a" + ex.getMessage());
            ex.printStackTrace();
        }
        return false;
    }

    public static boolean cancellationOrder(String tradeSerialNumber) {
        String url = GlobalResources.map.get("YWZC_URL") + ORDER_CANCELLATIONS;
        StringBuffer params = new StringBuffer("sign=BLB&webType=BLB");
        if (StringUtils.isNotEmpty((CharSequence)tradeSerialNumber)) {
            params.append("&data=" + tradeSerialNumber);
        }
        try {
            String s = RequestUtil.sendPost(url, params.toString());
            JSONObject json = JSON.parseObject((String)s);
            if (json != null && json.get((Object)"success").toString().equals("true")) {
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public static String receivePreservationData(String sup_id, InsInsuranceSlip policy, InsPreservationRecordVo pvo) {
        String url = GlobalResources.map.get("YWZC_URL") + ORDER_SYNCHRONIZATION;
        log.info("\u8bf7\u6c42\u5730\u5740\uff1a" + url);
        HashMap<String, String> orderMap = new HashMap<String, String>();
        orderMap.put("sign", "BLB");
        orderMap.put("orderNumber", pvo.getRevise_serial_number());
        orderMap.put("sign", "BLB");
        orderMap.put("orderDate", pvo.getStart_time());
        orderMap.put("projectName", "\u4fdd\u5355\u6279\u6539");
        orderMap.put("reviseType", pvo.getRevise_type());
        if ("1".equals(pvo.getRevise_type())) {
            orderMap.put("reviseNum", pvo.getAdd_count());
        } else if ("2".equals(pvo.getRevise_type())) {
            orderMap.put("reviseNum", pvo.getMinus_count());
        } else {
            orderMap.put("reviseNum", pvo.getReplace_count());
        }
        orderMap.put("paymentMethod", "1");
        orderMap.put("stagesNumber", "1");
        orderMap.put("currency", "CNY");
        orderMap.put("startDate", pvo.getInception_date());
        orderMap.put("endDate", pvo.getPlanned_end_date());
        if (policy.getMailPolicy().getNeed_receipt() == 1) {
            orderMap.put("invoiceType", policy.getMailPolicy().getInvoice_type());
        } else {
            orderMap.put("invoiceType", "");
        }
        orderMap.put("productId", String.valueOf(policy.getPro_primary().getPro_primary_id()));
        orderMap.put("webUserId", String.valueOf(sup_id));
        List<InsRoleInpolicy> roleList = policy.getRolesOfKind("1");
        String province = "0";
        String city = "0";
        String area = "0";
        String address = "";
        if (roleList != null && roleList.size() > 0) {
            InsRoleInpolicy role = roleList.get(0);
            if (StringUtils.isNotEmpty((CharSequence)role.getReg_province())) {
                province = role.getReg_province();
            }
            if (StringUtils.isNotEmpty((CharSequence)role.getReg_city())) {
                city = role.getReg_city();
            }
            if (StringUtils.isNotEmpty((CharSequence)role.getReg_district())) {
                area = role.getReg_district();
            }
            if (StringUtils.isNotEmpty((CharSequence)role.getReg_address())) {
                address = role.getReg_address();
            }
        }
        orderMap.put("province", province);
        orderMap.put("city", city);
        orderMap.put("district", area);
        orderMap.put("address", address);
        if (policy.getRecommend_code() != null) {
            orderMap.put("distributorId", policy.getRecommend_code());
        }
        orderMap.put("fcy", pvo.getTotal_premium());
        orderMap.put("webOrderFormId", String.valueOf(pvo.getOid()));
        orderMap.put("parentOrderFormId", String.valueOf(policy.getIns_insurance_slip_id()));
        orderMap.put("policyNo", pvo.getExternal_reference());
        orderMap.put("orderPayment.paymentPeriod", "");
        orderMap.put("orderPayment.payDate", DateUtil.getCurrentDate());
        orderMap.put("orderPayment.payCode", "0");
        orderMap.put("orderPayment.paySerialNumber", "0");
        orderMap.put("orderPayment.paymentMethod", "0");
        orderMap.put("orderPayment.remainingNumber", "0");
        orderMap.put("orderPayment.currentPayable", StringUtils.isNotEmpty((CharSequence)pvo.getTotal_premium()) ? pvo.getTotal_premium() : "0");
        orderMap.put("orderPayment.actualPayment", "0");
        if (orderMap == null) {
            return "";
        }
        try {
            log.info("\u62a5\u6587\u683c\u5f0f\uff1aJSON");
            log.info("\u8bf7\u6c42\u62a5\u6587\uff1a" + ((Object)orderMap).toString());
            String result = HttpUtil.doPost2((String)url, orderMap);
            JSONObject json = JSON.parseObject((String)result);
            log.info("\u8fd4\u56de\u62a5\u6587\uff1a" + json.toString());
            if (json != null && json.get((Object)"success").toString().equals("true")) {
                return json.get((Object)"data").toString();
            }
        }
        catch (Exception ex) {
            log.info("\u8bf7\u6c42\u5f02\u5e38\uff1a" + ex.getMessage());
            ex.printStackTrace();
        }
        return "";
    }

    public static String sendOrderFormData(OrderFormVo orderVo, InsInsuranceSlip policy, InsTransaction itn) {
        String platUrl = "http://bms.test.bcxin.com.cn";
        String interFaceUrl = "/order/ins/sync";
        String url = platUrl + interFaceUrl;
        log.info("\u8bf7\u6c42\u5730\u5740\uff1a" + url);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orderNo", policy.getTrade_serial_number());
        param.put("orderAmount", policy.getPremium());
        param.put("totalAmount", itn.getOut_of_pocket() == null ? "0" : String.valueOf(itn.getOut_of_pocket()));
        param.put("customName", orderVo.getApplicant_name());
        List<InsRoleInpolicy> roleList = policy.getRolesOfKind("1");
        String province = "0";
        String city = "0";
        String area = "0";
        if (roleList != null && roleList.size() > 0) {
            InsRoleInpolicy role = roleList.get(0);
            if (StringUtils.isNotEmpty((CharSequence)role.getReg_province())) {
                province = role.getReg_province();
            }
            if (StringUtils.isNotEmpty((CharSequence)role.getReg_city())) {
                city = role.getReg_city();
            }
            if (StringUtils.isNotEmpty((CharSequence)role.getReg_district())) {
                area = role.getReg_district();
            }
        }
        param.put("province", Integer.parseInt(province));
        param.put("city", Integer.parseInt(city));
        param.put("area", Integer.parseInt(area));
        param.put("productId", 0L);
        param.put("orderCreateTime", orderVo.getStart_time());
        param.put("payTime", DateUtil.convertDateToString(itn.getStart_time(), "yyyy-MM-dd HH:mm:ss"));
        param.put("policyNo", orderVo.getExternal_reference());
        param.put("endorsementNo", "");
        param.put("insuredPers", orderVo.getInsurance_name());
        param.put("economicCompanyNo", "");
        param.put("economicCompanyName", orderVo.getInsurance_name());
        param.put("guarantStartTime", orderVo.getInception_date());
        param.put("guarantEndTime", orderVo.getPlanned_end_date());
        try {
            log.info("\u62a5\u6587\u683c\u5f0f\uff1aJSON");
            log.info("\u8bf7\u6c42\u62a5\u6587\uff1a" + ((Object)param).toString());
            String result = HttpUtil.doPost2((String)url, param);
            JSONObject json = JSON.parseObject((String)result);
            log.info("\u8fd4\u56de\u62a5\u6587\uff1a" + json.toString());
            if (json != null && json.get((Object)"ret").toString().equals("0")) {
                return json.get((Object)"data").toString();
            }
        }
        catch (Exception ex) {
            log.info("\u8bf7\u6c42\u5f02\u5e38\uff1a" + ex.getMessage());
            ex.printStackTrace();
        }
        return "";
    }

    public static String sendOrderFormData(OrderFormVo orderVo, InsInsuranceSlip policy, InsPreservationRecordVo pvo) {
        String platUrl = "http://bms.test.bcxin.com.cn";
        String interFaceUrl = "/order/ins/sync";
        String url = platUrl + interFaceUrl;
        log.info("\u8bf7\u6c42\u5730\u5740\uff1a" + url);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orderNo", pvo.getRevise_serial_number());
        param.put("orderAmount", pvo.getTotal_premium());
        param.put("totalAmount", "0");
        param.put("customName", orderVo.getApplicant_name());
        List<InsRoleInpolicy> roleList = policy.getRolesOfKind("1");
        String province = "0";
        String city = "0";
        String area = "0";
        if (roleList != null && roleList.size() > 0) {
            InsRoleInpolicy role = roleList.get(0);
            if (StringUtils.isNotEmpty((CharSequence)role.getReg_province())) {
                province = role.getReg_province();
            }
            if (StringUtils.isNotEmpty((CharSequence)role.getReg_city())) {
                city = role.getReg_city();
            }
            if (StringUtils.isNotEmpty((CharSequence)role.getReg_district())) {
                area = role.getReg_district();
            }
        }
        param.put("province", Integer.parseInt(province));
        param.put("city", Integer.parseInt(city));
        param.put("area", Integer.parseInt(area));
        param.put("productId", 0L);
        param.put("orderCreateTime", pvo.getRelease_time());
        param.put("payTime", "");
        param.put("policyNo", orderVo.getExternal_reference());
        param.put("endorsementNo", pvo.getRevise_serial_num_ins());
        param.put("insuredPers", orderVo.getInsurance_name());
        param.put("economicCompanyNo", "");
        param.put("economicCompanyName", orderVo.getInsurance_name());
        param.put("guarantStartTime", pvo.getInception_date());
        param.put("guarantEndTime", orderVo.getPlanned_end_date());
        try {
            log.info("\u62a5\u6587\u683c\u5f0f\uff1aJSON");
            log.info("\u8bf7\u6c42\u62a5\u6587\uff1a" + ((Object)param).toString());
            String result = HttpUtil.doPost2((String)url, param);
            JSONObject json = JSON.parseObject((String)result);
            log.info("\u8fd4\u56de\u62a5\u6587\uff1a" + json.toString());
            if (json != null && json.get((Object)"ret").toString().equals("0")) {
                return json.get((Object)"data").toString();
            }
        }
        catch (Exception ex) {
            log.info("\u8bf7\u6c42\u5f02\u5e38\uff1a" + ex.getMessage());
            ex.printStackTrace();
        }
        return "";
    }

    public static HttpServletRequest getRequest() {
        if (RequestContextHolder.getRequestAttributes() != null) {
            return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        }
        return null;
    }

    public static void main(String[] args) {
    }
}

