/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.util;

import com.bcxin.ins.obs.OBSUtil;
import com.bcxin.ins.oss.OSSServiceExecutor;
import com.bcxin.ins.util.BASE64Util;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.GlobalResources;
import com.google.common.base.Preconditions;
import com.xiaoleilu.hutool.io.FileUtil;
import com.xiaoleilu.hutool.util.RandomUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class OSSFileUtil {
    private static Logger logger = LoggerFactory.getLogger(OSSFileUtil.class);
    private static final String DEFAULT_UPLOAD_DIR = "upload";
    private static final String DEFAULT_UPLOAD_LINUX = "/data/upload/blb/";

    public static Map<String, String> ossFileUpload(MultipartFile materialFile, String directoryName, boolean radomFile, String customFileName) {
        HashMap<String, String> map = new HashMap<String, String>();
        String materialFileName = materialFile.getOriginalFilename();
        String fileType = StringUtils.substringAfterLast((String)materialFileName, (String)".").toLowerCase();
        String fileName = "";
        if (radomFile) {
            String radomNumber = DateUtil.generatorRadomNumber();
            fileName = radomNumber + "." + fileType;
        } else {
            fileName = customFileName;
        }
        String ossKey = directoryName + fileName;
        OSSServiceExecutor ossExecutor = new OSSServiceExecutor("jpg|jpeg|gif|png|bmp|JPG|JPEG|GIF|PNG|BMP".contains(fileType));
        try {
            if (!ossExecutor.isExitsDirectory(directoryName)) {
                ossExecutor.createDirectory(directoryName);
            }
            new Thread(() -> {
                try {
                    ossExecutor.put(ossKey, materialFile.getInputStream(), true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).start();
            String url = ossExecutor.getServer() + ossKey;
            map.put("url", url);
            map.put("key", ossKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    public static Map<String, String> ossFileUpload_sysc(MultipartFile materialFile, String directoryName, boolean radomFile, String customFileName) {
        HashMap<String, String> map = new HashMap<String, String>();
        String materialFileName = materialFile.getOriginalFilename();
        String fileType = StringUtils.substringAfterLast((String)materialFileName, (String)".").toLowerCase();
        String fileName = "";
        if (radomFile) {
            String radomNumber = DateUtil.generatorRadomNumber();
            fileName = radomNumber + "." + fileType;
        } else {
            fileName = customFileName;
        }
        String ossKey = directoryName + fileName;
        OSSServiceExecutor ossExecutor = new OSSServiceExecutor("jpg|jpeg|gif|png|bmp|JPG|JPEG|GIF|PNG|BMP".contains(fileType));
        try {
            if (!ossExecutor.isExitsDirectory(directoryName)) {
                ossExecutor.createDirectory(directoryName);
            }
            try {
                ossExecutor.put(ossKey, materialFile.getInputStream(), true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String url = ossExecutor.getServer() + ossKey;
            map.put("url", url);
            map.put("key", ossKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    public static Map<String, String> ossFileUpload(File materialFile, String directoryName, boolean radomFile, String customFileName) {
        HashMap<String, String> map = new HashMap<String, String>();
        String materialFileName = materialFile.getName();
        String fileType = StringUtils.substringAfterLast((String)materialFileName, (String)".").toLowerCase();
        String fileName = "";
        if (radomFile) {
            String radomNumber = DateUtil.generatorRadomNumber();
            fileName = radomNumber + "." + fileType;
        } else {
            fileName = customFileName;
        }
        String ossKey = directoryName + "/" + fileName;
        OSSServiceExecutor ossExecutor = new OSSServiceExecutor("jpg|jpeg|gif|png|bmp|JPG|JPEG|GIF|PNG|BMP".contains(fileType));
        try {
            if (!ossExecutor.isExitsDirectory(directoryName)) {
                ossExecutor.createDirectory(directoryName);
            }
            new Thread(() -> {
                try {
                    ossExecutor.put(ossKey, materialFile, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).start();
            String url = ossExecutor.getServer() + ossKey;
            map.put("url", url);
            map.put("key", ossKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    public static Map<String, String> ossFileUpload_sync(File materialFile, String directoryName, boolean radomFile, String customFileName) {
        HashMap<String, String> map = new HashMap<String, String>();
        String materialFileName = materialFile.getName();
        String fileType = StringUtils.substringAfterLast((String)materialFileName, (String)".").toLowerCase();
        String fileName = "";
        if (radomFile) {
            String radomNumber = DateUtil.generatorRadomNumber();
            fileName = radomNumber + "." + fileType;
        } else {
            fileName = customFileName;
        }
        String ossKey = directoryName + "/" + fileName;
        OSSServiceExecutor ossExecutor = new OSSServiceExecutor("jpg|jpeg|gif|png|bmp|JPG|JPEG|GIF|PNG|BMP".contains(fileType));
        try {
            if (!ossExecutor.isExitsDirectory(directoryName)) {
                ossExecutor.createDirectory(directoryName);
            }
            try {
                ossExecutor.put(ossKey, materialFile, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String url = ossExecutor.getServer() + ossKey;
            map.put("url", url);
            map.put("key", ossKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    public static Map<String, String> ossFileUpload(String base64Str, String directoryName, String customFileName) {
        HashMap<String, String> map = new HashMap<String, String>();
        String fileType = StringUtils.substringAfterLast((String)customFileName, (String)".").toLowerCase();
        String fileName = customFileName;
        String ossKey = directoryName + "/" + fileName;
        OSSServiceExecutor ossExecutor = new OSSServiceExecutor("jpg|jpeg|gif|png|bmp|JPG|JPEG|GIF|PNG|BMP".contains(fileType));
        try {
            if (!ossExecutor.isExitsDirectory(directoryName)) {
                ossExecutor.createDirectory(directoryName);
            }
            new Thread(() -> {
                try {
                    ossExecutor.put(ossKey, OSSFileUtil.BaseToInputStream(base64Str), true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).start();
            String url = ossExecutor.getServer() + ossKey;
            map.put("url", url);
            map.put("key", ossKey);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Map<String, String> ossFileUpload_sync(String base64Str, String directoryName, String customFileName) {
        HashMap<String, String> map = new HashMap<String, String>();
        String fileType = StringUtils.substringAfterLast((String)customFileName, (String)".").toLowerCase();
        String fileName = customFileName;
        String ossKey = directoryName + "/" + fileName;
        OSSServiceExecutor ossExecutor = new OSSServiceExecutor("jpg|jpeg|gif|png|bmp|JPG|JPEG|GIF|PNG|BMP".contains(fileType));
        try {
            if (!ossExecutor.isExitsDirectory(directoryName)) {
                ossExecutor.createDirectory(directoryName);
            }
            ossExecutor.put(ossKey, OSSFileUtil.BaseToInputStream(base64Str), true);
            String url = ossExecutor.getServer() + ossKey;
            map.put("url", url);
            map.put("key", ossKey);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static void ossFileDownload(String key, String fileName, HttpServletResponse response) {
        try {
            OSSServiceExecutor ossExecutor = new OSSServiceExecutor(false);
            String filenameEncode = URLEncoder.encode(fileName.replace("/", "_"), "utf-8");
            File file = ossExecutor.get(key, fileName.replace("/", "_"));
            response.reset();
            response.setHeader("Content-Disposition", "attachment; filename=" + filenameEncode);
            response.setContentType("application/octet-stream; charset=utf-8");
            response.setHeader("Content-Length", String.valueOf(file.length()));
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
                 BufferedOutputStream bos = new BufferedOutputStream((OutputStream)response.getOutputStream());){
                int bytesRead;
                byte[] buff = new byte[2048];
                while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                    bos.write(buff, 0, bytesRead);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("\u6587\u4ef6\u4e0b\u8f7d\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String huaweiOBSFileUpload_base64(String base64Str, String dir, String fileName) {
        if (StringUtils.isNotEmpty((CharSequence)dir)) {
            dir = dir.startsWith("/") ? dir : "/" + dir;
            dir = dir.endsWith("/") ? dir.substring(0, dir.length() - 1) : dir;
        }
        String directoryName = DEFAULT_UPLOAD_DIR + dir + "/" + DateUtil.getCurrentDate() + "/";
        String ossKey = DEFAULT_UPLOAD_DIR + dir + "/" + DateUtil.getCurrentDate() + "/" + fileName;
        OBSUtil obsUtil = new OBSUtil(GlobalResources.IS_TEST_ENVI);
        try (InputStream inputStream = OSSFileUtil.BaseToInputStream(base64Str);){
            String string = obsUtil.put(directoryName, ossKey, inputStream);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("huaweiOBSFileUpload_base64:" + e.getMessage(), (Throwable)e);
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String huaweiOBSFileUpload(MultipartFile xFile, String dir) {
        String fileType = com.google.common.io.Files.getFileExtension((String)xFile.getOriginalFilename());
        String randomNumber = System.currentTimeMillis() + RandomUtil.randomNumbers((int)6);
        String fileName = randomNumber + "." + fileType;
        if (StringUtils.isNotEmpty((CharSequence)dir)) {
            dir = dir.startsWith("/") ? dir : "/" + dir;
            dir = dir.endsWith("/") ? dir.substring(0, dir.length() - 1) : dir;
        }
        String directoryName = DEFAULT_UPLOAD_DIR + dir + "/" + DateUtil.getCurrentDate() + "/";
        String ossKey = DEFAULT_UPLOAD_DIR + dir + "/" + DateUtil.getCurrentDate() + "/" + fileName;
        OBSUtil obsUtil = new OBSUtil(GlobalResources.IS_TEST_ENVI);
        try (InputStream inputStream = xFile.getInputStream();){
            String string = obsUtil.put(directoryName, ossKey, inputStream);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("huaweiOBSFileUpload:" + e.getMessage(), (Throwable)e);
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String huaweiOBSFileUpload_base64(String base64Str, String fileType, String dir, String sign) {
        String randomNumber = System.currentTimeMillis() + RandomUtil.randomNumbers((int)6) + sign;
        String fileName = randomNumber + "." + fileType;
        if (StringUtils.isNotEmpty((CharSequence)dir)) {
            dir = dir.startsWith("/") ? dir : "/" + dir;
            dir = dir.endsWith("/") ? dir.substring(0, dir.length() - 1) : dir;
        }
        String directoryName = DEFAULT_UPLOAD_DIR + dir + "/" + DateUtil.getCurrentDate() + "/";
        String ossKey = DEFAULT_UPLOAD_DIR + dir + "/" + DateUtil.getCurrentDate() + "/" + fileName;
        OBSUtil obsUtil = new OBSUtil(GlobalResources.IS_TEST_ENVI);
        try (InputStream inputStream = OSSFileUtil.BaseToInputStream(base64Str);){
            String string = obsUtil.put(directoryName, ossKey, inputStream);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("huaweiOBSFileUpload_base64:" + e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static String huaweiOBSFileUpload(InputStream inputStream, String dir, String fileType) {
        String randomNumber = System.currentTimeMillis() + RandomUtil.randomNumbers((int)6);
        String fileName = randomNumber + "." + fileType;
        if (StringUtils.isNotEmpty((CharSequence)dir)) {
            dir = dir.startsWith("/") ? dir : "/" + dir;
            dir = dir.endsWith("/") ? dir.substring(0, dir.length() - 1) : dir;
        }
        String directoryName = DEFAULT_UPLOAD_DIR + dir + "/" + DateUtil.getCurrentDate() + "/";
        String ossKey = DEFAULT_UPLOAD_DIR + dir + "/" + DateUtil.getCurrentDate() + "/" + fileName;
        OBSUtil obsUtil = new OBSUtil(GlobalResources.IS_TEST_ENVI);
        try {
            return obsUtil.put(directoryName, ossKey, inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("huaweiOBSFileUpload:" + e.getMessage(), (Throwable)e);
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String huaweiOBSFileUpload(File file, String fileType, String dir) {
        String randomNumber = System.currentTimeMillis() + RandomUtil.randomNumbers((int)6);
        String fileName = randomNumber + "." + fileType;
        if (StringUtils.isNotEmpty((CharSequence)dir)) {
            dir = dir.startsWith("/") ? dir : "/" + dir;
            dir = dir.endsWith("/") ? dir.substring(0, dir.length() - 1) : dir;
        }
        String directoryName = DEFAULT_UPLOAD_DIR + dir + "/" + DateUtil.getCurrentDate() + "/";
        String ossKey = DEFAULT_UPLOAD_DIR + dir + "/" + DateUtil.getCurrentDate() + "/" + fileName;
        OBSUtil obsUtil = new OBSUtil(GlobalResources.IS_TEST_ENVI);
        try (BufferedInputStream inputStream = FileUtil.getInputStream((File)file);){
            String string = obsUtil.put(directoryName, ossKey, inputStream);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("huaweiOBSFileUpload(envi:" + GlobalResources.IS_TEST_ENVI + ",fileType:" + fileType + ",obsUtil:" + (obsUtil == null ? "null" : "not null") + "):" + e.getMessage(), (Throwable)e);
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String huaweiLocalFileUpload(File file, String date, String dir) {
        if (StringUtils.isNotEmpty((CharSequence)dir)) {
            dir = dir.startsWith("/") ? dir : "/" + dir;
            dir = dir.endsWith("/") ? dir.substring(0, dir.length() - 1) : dir;
        }
        String directoryName = DEFAULT_UPLOAD_DIR + dir + "/" + date + "/";
        String ossKey = DEFAULT_UPLOAD_DIR + dir + "/" + date + "/" + file.getName();
        OBSUtil obsUtil = new OBSUtil(GlobalResources.IS_TEST_ENVI);
        try (BufferedInputStream inputStream = FileUtil.getInputStream((File)file);){
            String string = obsUtil.put(directoryName, ossKey, inputStream);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("huaweiLocalFileUpload:" + e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static InputStream getInputStreamByUrl(String url) throws FileNotFoundException {
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            try {
                String fileType = url.substring(url.length() - 3, url.length());
                OSSServiceExecutor ossExecutor = new OSSServiceExecutor("jpg|jpeg|gif|png|bmp|JPG|JPEG|GIF|PNG|BMP".contains(fileType));
                String key = url.replace(ossExecutor.getServer(), "");
                return OSSFileUtil.getInputStreamByKey(key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static InputStream getInputStreamByKey(String key) throws FileNotFoundException {
        OSSServiceExecutor ossExecutor = new OSSServiceExecutor(false);
        File file = ossExecutor.get(key, key.replace("/", "_"));
        return new BufferedInputStream(new FileInputStream(file));
    }

    public static boolean ossFileDelete(String key) {
        OSSServiceExecutor ossExecutor = new OSSServiceExecutor(false);
        return ossExecutor.deleteFile(key);
    }

    public static void ossFileDelete_sync(String key) {
        new Thread(() -> OSSFileUtil.ossFileDelete(key)).start();
    }

    public static String downZip(List<String> filePaths, String zipBasePath, String zipName, HttpServletResponse response) {
        byte[] buffer = new byte[1024];
        String strZipPath = zipBasePath + "/" + zipName;
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(strZipPath));){
            ArrayList<File> files = new ArrayList<File>();
            for (String filePath : filePaths) {
                File policyFile = new File(filePath);
                files.add(policyFile);
            }
            for (File file : files) {
                try {
                    FileInputStream fis = new FileInputStream(file);
                    Throwable throwable = null;
                    try {
                        int len;
                        out.putNextEntry(new ZipEntry(file.getName()));
                        while ((len = fis.read(buffer)) > 0) {
                            out.write(buffer, 0, len);
                        }
                        out.closeEntry();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fis == null) continue;
                        if (throwable != null) {
                            try {
                                fis.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fis.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            OSSFileUtil.downloadFile(strZipPath, zipName, response);
            for (File file : files) {
                if (!file.isFile() || !file.exists()) continue;
                try {
                    Files.delete(file.toPath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void downloadFile(String fileName, String downloadName, HttpServletResponse response) {
        response.setContentType("octets/stream");
        response.addHeader("Content-Type", "text/html; charset=utf-8");
        String downLoadName = "";
        try {
            downLoadName = new String(downloadName.getBytes("gbk"), "iso8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        response.addHeader("Content-Disposition", "attachment;filename=" + downLoadName);
        try (FileInputStream fileInputStream = new FileInputStream(fileName);
             ServletOutputStream out = response.getOutputStream();){
            int i = 0;
            while ((i = fileInputStream.read()) != -1) {
                out.write(i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean fileUpload(MultipartFile file, String radomfileName, String materialFilePath) {
        boolean flag = true;
        File baseFile = new File(materialFilePath);
        File trainFile = new File(baseFile, radomfileName);
        if (!baseFile.exists()) {
            baseFile.mkdirs();
        }
        try {
            file.transferTo(trainFile);
        }
        catch (IllegalStateException e) {
            flag = false;
        }
        catch (IOException e) {
            flag = false;
        }
        return flag;
    }

    public static String getImageStr(String imgFile) throws Exception {
        byte[] data = null;
        try (FileInputStream in = new FileInputStream(imgFile);){
            data = new byte[((InputStream)in).available()];
            ((InputStream)in).read(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String back = BASE64Util.encryptBASE64Byte(data);
        System.out.println(back);
        return back;
    }

    private static InputStream BaseToInputStream(String base64string) {
        ByteArrayInputStream stream = null;
        try {
            byte[] bytes1 = BASE64Util.decryptBASE64Byte(base64string);
            stream = new ByteArrayInputStream(bytes1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean generateImage(String imgStr, String imgFile) throws Exception {
        if (StringUtils.isEmpty((CharSequence)imgStr)) {
            return false;
        }
        byte[] b = BASE64Util.decryptBASE64Byte(imgStr);
        for (int i = 0; i < b.length; ++i) {
            if (b[i] >= 0) continue;
            int n = i;
            b[n] = (byte)(b[n] + 256);
        }
        String imgFilePath = imgFile;
        File file = new File(imgFilePath);
        file.getParentFile().mkdirs();
        try (FileOutputStream out = new FileOutputStream(imgFilePath);){
            ((OutputStream)out).write(b);
            out.flush();
            boolean bl = true;
            return bl;
        }
    }

    public static void download(String urlString, String filename, String savePath) throws Exception {
        URL url = new URL(urlString);
        URLConnection con = url.openConnection();
        con.setConnectTimeout(5000);
        byte[] bs = new byte[1024];
        File sf = new File(savePath);
        if (!sf.exists()) {
            sf.mkdirs();
        }
        try (InputStream is = con.getInputStream();
             FileOutputStream os = new FileOutputStream(sf.getPath() + "/" + filename);){
            int len;
            while ((len = is.read(bs)) != -1) {
                ((OutputStream)os).write(bs, 0, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String mkdirsFile(String basePath, String resourcePath, String baseFile) throws Exception {
        String pathStr = "";
        if (StringUtils.isNotEmpty((CharSequence)baseFile)) {
            String str1 = baseFile.split(",")[0];
            String str1_1 = str1.split(";")[0];
            String imgType = str1_1.split("/")[1];
            String str2 = baseFile.split(",")[1];
            byte[] bytes = BASE64Util.decryptBASE64Byte(str2);
            FilterOutputStream bos = null;
            FileOutputStream fos = null;
            File file = null;
            try {
                File dir = new File(basePath);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                String fileName = DateUtil.generatorRadomNumber();
                String pathStrLI = basePath + fileName + "." + imgType;
                pathStr = resourcePath + fileName + "." + imgType;
                file = new File(pathStrLI);
                fos = new FileOutputStream(file);
                bos = new BufferedOutputStream(fos);
                bos.write(bytes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return pathStr;
    }

    public static void fileWrite(String fileName, String contents) {
        Preconditions.checkNotNull((Object)fileName, (Object)"\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkNotNull((Object)contents, (Object)"Unable to write null contents.");
        File newFile = new File(fileName);
        try {
            com.google.common.io.Files.write((byte[])contents.getBytes(), (File)newFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("running here");
    }

    public static void copyFile(String oldPath, String newPath) {
        int bytesum = 0;
        int byteread = 0;
        File oldfile = new File(oldPath);
        if (oldfile.exists()) {
            try (FileInputStream inStream = new FileInputStream(oldPath);
                 FileOutputStream fs = new FileOutputStream(newPath);){
                byte[] buffer = new byte[1444];
                while ((byteread = ((InputStream)inStream).read(buffer)) != -1) {
                    bytesum += byteread;
                    fs.write(buffer, 0, byteread);
                }
            }
            catch (Exception e) {
                System.out.println("\u590d\u5236\u5355\u4e2a\u6587\u4ef6\u64cd\u4f5c\u51fa\u9519");
                e.printStackTrace();
            }
        }
    }
}

