/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;

public class MultipartFileImpl
implements MultipartFile {
    private String name;
    private String fileName;
    private String contentType;
    private byte[] content;

    public MultipartFileImpl(String fileName, byte[] content) {
        this(fileName, "application/octet-stream", content);
    }

    public MultipartFileImpl(String fileName, String contentType, byte[] content) {
        this.fileName = fileName;
        this.contentType = contentType;
        this.content = content;
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalFilename() {
        return this.fileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isEmpty() {
        return this.content.length == 0;
    }

    public long getSize() {
        return this.content.length;
    }

    public byte[] getBytes() throws IOException {
        return this.content;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.content);
    }

    public void transferTo(File dest) throws IOException, IllegalStateException {
        FileCopyUtils.copy((byte[])this.content, (File)dest);
    }
}

