/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.util;

import com.alibaba.fastjson.JSON;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.map.HashedMap;

public class JSONUtils {
    public static String objectToJson(Object object) {
        StringBuilder json = new StringBuilder();
        if (object == null) {
            json.append("\"\"");
        } else if (object instanceof String || object instanceof Integer || object instanceof Double) {
            json.append("\"").append(object.toString()).append("\"");
        } else {
            json.append(JSONUtils.beanToJson(object));
        }
        return json.toString();
    }

    public static String beanToJson(Object bean) {
        StringBuilder json = new StringBuilder();
        json.append("{");
        PropertyDescriptor[] props = null;
        try {
            props = Introspector.getBeanInfo(bean.getClass(), Object.class).getPropertyDescriptors();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (props != null) {
            for (int i = 0; i < props.length; ++i) {
                try {
                    String name = JSONUtils.objectToJson(props[i].getName());
                    String value = JSONUtils.objectToJson(props[i].getReadMethod().invoke(bean, new Object[0]));
                    json.append(name);
                    json.append(":");
                    json.append(value);
                    json.append(",");
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            json.setCharAt(json.length() - 1, '}');
        } else {
            json.append("}");
        }
        return json.toString();
    }

    public static String beanToJsonByName(String[] names, String[] values) {
        StringBuilder json = new StringBuilder();
        json.append("{");
        if (values != null && names.length == values.length) {
            for (int i = 0; i < values.length; ++i) {
                try {
                    String name = JSONUtils.objectToJson(names[i]);
                    String value = JSONUtils.objectToJson(values[i]);
                    json.append(name);
                    json.append(":");
                    json.append(value);
                    json.append(",");
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            json.setCharAt(json.length() - 1, '}');
        } else {
            json.append("}");
        }
        return json.toString();
    }

    public static String getBackJson(String resultCode, String message) {
        if (StringUtils.isEmpty((CharSequence)resultCode)) {
            return null;
        }
        StringBuilder json = new StringBuilder();
        json.append("{\"code\":");
        json.append(resultCode);
        json.append(",\"message\":\"");
        json.append(message);
        json.append("\"}");
        return json.toString();
    }

    public static String getBackObjJson(String resultCode, String message) {
        if (StringUtils.isEmpty((CharSequence)resultCode)) {
            return null;
        }
        StringBuilder json = new StringBuilder();
        json.append("{\"code\":");
        json.append(resultCode);
        json.append(",\"object\":");
        json.append(message);
        json.append("}");
        return json.toString();
    }

    public static String getBackObjJson(String[] names, String[] values, List<Integer> atList) {
        if (names == null || names.length != values.length) {
            return null;
        }
        StringBuilder json = new StringBuilder();
        json.append("{");
        for (int i = 0; i < names.length; ++i) {
            if (i == 0) {
                json.append("\"");
            } else {
                json.append(",\"");
            }
            json.append(names[i]);
            json.append("\":");
            if (atList.contains(i)) {
                json.append(values[i]);
                continue;
            }
            json.append("\"");
            json.append(values[i]);
            json.append("\"");
        }
        json.append("}");
        return json.toString();
    }

    public static String getBackMultiObjJson(String[] names, String[] values) {
        if (names == null || names.length != values.length) {
            return null;
        }
        StringBuilder json = new StringBuilder();
        json.append("{");
        for (int i = 0; i < names.length; ++i) {
            if (i != 0) {
                json.append(",");
            }
            json.append("\"" + names[i] + "\":");
            if (StringUtils.isEmpty((CharSequence)values[i])) {
                json.append("[]");
                continue;
            }
            json.append(values[i]);
        }
        json.append("}");
        return json.toString();
    }

    public static String listToJsonByName(String[] names, List<String[]> list) {
        StringBuilder json = new StringBuilder();
        json.append("[");
        if (list != null && list.size() > 0) {
            for (String[] obj : list) {
                json.append(JSONUtils.beanToJsonByName(names, obj));
                json.append(",");
            }
            json.setCharAt(json.length() - 1, ']');
        } else {
            json.append("]");
        }
        return json.toString();
    }

    public static String listToJson(List<?> list) {
        StringBuilder json = new StringBuilder();
        json.append("[");
        if (list != null && list.size() > 0) {
            for (Object obj : list) {
                json.append(JSONUtils.objectToJson(obj));
                json.append(",");
            }
            json.setCharAt(json.length() - 1, ']');
        } else {
            json.append("]");
        }
        return json.toString();
    }

    public static Map<String, Object> parseJSON2Map(String jsonStr) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        JSONObject json = JSONObject.fromObject((Object)jsonStr);
        for (Object k : json.keySet()) {
            Object v = json.get(k);
            if (v instanceof JSONArray) {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                for (JSONObject json2 : (JSONArray)v) {
                    list.add(JSONUtils.parseJSON2Map(json2.toString()));
                }
                map.put(k.toString(), list);
                continue;
            }
            map.put(k.toString(), v);
        }
        return map;
    }

    public static Map<String, Object> getUpperMap(Map<String, Object> body) {
        Set<String> keys = body.keySet();
        HashedMap resultMap = new HashedMap();
        for (String key : keys) {
            resultMap.put(key.toUpperCase(), body.get(key));
        }
        return resultMap;
    }

    public static void main(String[] args) {
        String json2 = "{\"header\":{\"transactionCode\":\"TCEGISNBUAPC001\",\"partnerId\":\"PCXM001\",\"requestId\":\"1494307726824\",\"code\":\"CRIGHT_0000\",\"message\":null},\"body\":\"{\\\"barCode\\\":\\\"9041K009838136\\\",\\\"fromPartnerId\\\":\\\"PAEGISNBU001\\\",\\\"realFromPartnerId\\\":\\\"PCXM001\\\",\\\"receiptNo\\\":\\\"30000070075779085\\\",\\\"responseMsg\\\":\\\"AMESB\u63a5\u53e3InsuredAMESBService\u8c03\u7528\u6210\u529f\uff01\\\",\\\"returnFlag\\\":\\\"1\\\",\\\"totalPremium\\\":\\\"510\\\"}\"}";
        Map map = (Map)JSON.parseObject((String)json2, Map.class);
        Map header = (Map)JSON.parseObject((String)map.get("header").toString(), Map.class);
        Map<String, Object> header1 = JSONUtils.getUpperMap(header);
        Map body = (Map)JSON.parseObject((String)map.get("body").toString(), Map.class);
        Map<String, Object> body1 = JSONUtils.getUpperMap(body);
        System.out.println("\u8c03\u7528\u540ebody" + body.toString());
        System.out.println("\u8c03\u7528\u524dbody" + body1.toString());
        System.out.println("\u8c03\u7528\u540eheader" + header.toString());
        System.out.println("\u8c03\u7528\u524dheader" + header1.toString());
    }

    public static class User {
        private String name = "";
        private String sex = "";
        private String birthdat;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSex() {
            return this.sex;
        }

        public void setSex(String sex) {
            this.sex = sex;
        }

        public String getBirthdat() {
            return this.birthdat;
        }

        public void setBirthdat(String birthdat) {
            this.birthdat = birthdat;
        }
    }
}

