/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.util;

import com.bcxin.ins.util.DateUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.CharUtils;

public final class IdNumberValidator {
    public static boolean verify(String idNumber) {
        if (idNumber == null) {
            return false;
        }
        if (idNumber.length() != 15 && idNumber.length() != 18) {
            return false;
        }
        for (int i = 0; i < idNumber.length(); ++i) {
            char c = idNumber.charAt(i);
            if (i >= 17 || CharUtils.isAsciiNumeric((char)c)) continue;
            return false;
        }
        if ((idNumber = idNumber.toUpperCase()).length() == 18 && idNumber.charAt(17) != 'X' && !CharUtils.isAsciiNumeric((char)idNumber.charAt(17))) {
            return false;
        }
        String dateStr = idNumber.length() == 18 ? idNumber.substring(6, 14) : idNumber.substring(6, 12);
        return IdNumberValidator.isValidDate(dateStr) && IdNumberValidator.verifyCheckDigit(idNumber);
    }

    public static boolean verifyB(String idNumber, Date birthDate) {
        if (idNumber == null) {
            return false;
        }
        if (birthDate == null) {
            return true;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(birthDate);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int date = cal.get(5);
        if (idNumber.length() == 18) {
            String yearStr = idNumber.substring(6, 10);
            String monthStr = idNumber.substring(10, 12);
            String dateStr = idNumber.substring(12, 14);
            try {
                return Integer.parseInt(dateStr) == date && Integer.parseInt(monthStr) == month && Integer.parseInt(yearStr) == year;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (idNumber.length() == 15) {
            String yearStr = idNumber.substring(6, 8);
            String monthStr = idNumber.substring(8, 10);
            String dateStr = idNumber.substring(10, 12);
            try {
                return Integer.parseInt(dateStr) == date && Integer.parseInt(monthStr) == month && Integer.parseInt(yearStr) == year % 100;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean verifyG(String idNumber, String gender) {
        if (idNumber == null) {
            return false;
        }
        if (gender == null || "".equals(gender)) {
            return true;
        }
        if (idNumber.length() != 18 && idNumber.length() != 15) {
            return false;
        }
        char g = idNumber.length() == 18 ? idNumber.charAt(16) : idNumber.charAt(14);
        return "2".equals(gender) && g % 2 == 0 || "1".equals(gender) && g % 2 == 1;
    }

    public static boolean verifyR(String idNumber, String regionalCode) {
        if (idNumber == null) {
            return false;
        }
        if (regionalCode == null || regionalCode.length() != 6) {
            return true;
        }
        return idNumber.startsWith(regionalCode);
    }

    public static boolean verifyCheckDigit(String idNumber) {
        if (idNumber == null) {
            return false;
        }
        if (idNumber.length() == 15) {
            return true;
        }
        return idNumber.length() == 18;
    }

    public static String transferTo18Bit(String personIDCode) {
        int i;
        if (personIDCode == null || personIDCode.trim().length() != 15) {
            return personIDCode;
        }
        char[] id15 = personIDCode.trim().toCharArray();
        char[] id18 = new char[18];
        for (i = 0; i < 6; ++i) {
            id18[i] = id15[i];
        }
        for (i = 6; i < 15; ++i) {
            id18[i + 2] = id15[i];
        }
        id18[6] = 49;
        id18[7] = 57;
        id18[17] = IdNumberValidator.checkDigit(id18);
        return String.valueOf(id18);
    }

    public static String transferTo15Bit(String personIDCode) {
        if (personIDCode == null || personIDCode.trim().length() != 18) {
            return personIDCode;
        }
        char[] id18 = personIDCode.trim().toCharArray();
        if (id18[6] == '1' && id18[7] == '9') {
            int i;
            char[] id15 = new char[15];
            for (i = 0; i < 6; ++i) {
                id15[i] = id18[i];
            }
            for (i = 8; i < 17; ++i) {
                id15[i - 2] = id18[i];
            }
            return String.valueOf(id15);
        }
        return personIDCode;
    }

    protected static char checkDigit(char[] id18) {
        char[] code = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
        int sum = 0;
        for (int i = 0; i < 17; ++i) {
            sum += CharUtils.toIntValue((char)id18[i]) * IdNumberValidator.wi(i);
        }
        int index = sum % 11;
        return code[index];
    }

    protected static int wi(int index) {
        if (index > 17 || index < 0) {
            throw new IllegalArgumentException("index out of bound");
        }
        int n = 17 - index;
        return (1 << n) % 11;
    }

    private static boolean isValidDate(String dateString) {
        if (dateString == null) {
            return false;
        }
        String pattern = "yyyyMMdd";
        if (dateString.length() == 6) {
            pattern = "yyMMdd";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        try {
            Date birthDate = dateFormat.parse(dateString);
            String birthDateStr = dateFormat.format(birthDate);
            return birthDateStr.equals(dateString);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Date idNumber2BirthDate(String idNumber) {
        Calendar cal = Calendar.getInstance();
        if (idNumber.length() == 18) {
            int yearStr = Integer.parseInt(idNumber.substring(6, 10));
            int monthStr = Integer.parseInt(idNumber.substring(10, 12)) - 1;
            int dateStr = Integer.parseInt(idNumber.substring(12, 14));
            cal.set(yearStr, monthStr, dateStr);
        } else if (idNumber.length() == 15) {
            int year = Integer.parseInt(idNumber.substring(6, 8));
            int yearStr = year + 1900;
            int monthStr = Integer.parseInt(idNumber.substring(8, 10)) - 1;
            int dateStr = Integer.parseInt(idNumber.substring(10, 12));
            cal.set(yearStr, monthStr, dateStr);
        }
        return DateUtil.getDayStart(cal.getTime());
    }

    public static String getSexFromCard(String idNumber) {
        String inputStr = idNumber.toUpperCase().toString();
        if (inputStr.length() == 18) {
            char sex = inputStr.charAt(16);
            if (sex % 2 == 0) {
                return "2";
            }
            return "1";
        }
        char sex = inputStr.charAt(14);
        if (sex % 2 == 0) {
            return "2";
        }
        return "1";
    }

    public static int getAgeFromCard(String idNumber) {
        String inputStr = idNumber.toUpperCase().toString();
        int age = 0;
        if (inputStr.length() == 18) {
            int birthday = Integer.parseInt(idNumber.substring(6, 10));
            Calendar date = Calendar.getInstance();
            int year = date.get(1);
            age = year - birthday;
        }
        return age;
    }

    public static int getAgeFromBirthday(String birthday) {
        String inputStr = birthday.toUpperCase().toString();
        int age = 0;
        if (inputStr.length() == 10) {
            int bd = 0;
            if (birthday.contains("/")) {
                bd = Integer.parseInt(birthday.split("/")[0]);
            } else if (birthday.contains("-")) {
                bd = Integer.parseInt(birthday.split("-")[0]);
            } else {
                return age;
            }
            Calendar date = Calendar.getInstance();
            int year = date.get(1);
            age = year - bd;
        }
        return age;
    }

    public static String lowerToUpper(String idNumber) {
        if ((idNumber.length() == 15 || idNumber.length() == 18) && idNumber.endsWith("x")) {
            idNumber = idNumber.toUpperCase();
        }
        return idNumber;
    }
}

