/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class IdCardVerify {
    private static String[] cityCode = new String[]{"11", "12", "13", "14", "15", "21", "22", "23", "31", "32", "33", "34", "35", "36", "37", "41", "42", "43", "44", "45", "46", "50", "51", "52", "53", "54", "61", "62", "63", "64", "65", "71", "81", "82", "91"};
    private static int[] power = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};

    public static boolean isValidatedAllIdcard(String idcard) {
        if (idcard == null || "".equals(idcard)) {
            return false;
        }
        int s = 15;
        if (idcard.length() == s) {
            return IdCardVerify.validate15IDCard(idcard);
        }
        int s1 = 18;
        if (idcard.length() == s1) {
            return IdCardVerify.validate18Idcard(idcard);
        }
        return false;
    }

    private static boolean isDigital(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (Character.isDigit(ch)) continue;
            return false;
        }
        return true;
    }

    public static boolean validate15IDCard(String idcard) {
        if (idcard == null) {
            return false;
        }
        int s = 15;
        if (idcard.length() != s) {
            return false;
        }
        if (!IdCardVerify.isDigital(idcard)) {
            return false;
        }
        String provinceid = idcard.substring(0, 2);
        if (!IdCardVerify.checkProvinceid(provinceid)) {
            return false;
        }
        String birthday = "19" + idcard.substring(6, 12);
        String birthYear = "19" + idcard.substring(6, 8);
        Date dt = new Date();
        String temp_str = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        temp_str = sdf.format(dt);
        temp_str = temp_str.substring(0, 4);
        int Year = 0;
        try {
            Date birthDate = sdf.parse(birthday);
            String tmpDate = sdf.format(birthDate);
            if (!tmpDate.equals(birthday)) {
                return false;
            }
            Year = Integer.parseInt(temp_str) - Integer.parseInt(birthYear);
            if (Year < 3 || Year > 100) {
                return false;
            }
        }
        catch (ParseException e1) {
            return false;
        }
        return true;
    }

    public static boolean validate18Idcard(String idcard) {
        if (idcard == null) {
            return false;
        }
        int s = 18;
        if (idcard.length() != s) {
            return false;
        }
        String idcard17 = idcard.substring(0, 17);
        if (!IdCardVerify.isDigital(idcard17)) {
            return false;
        }
        String provinceid = idcard.substring(0, 2);
        if (!IdCardVerify.checkProvinceid(provinceid)) {
            return false;
        }
        String birthday = idcard.substring(6, 14);
        String birthYear = idcard.substring(6, 10);
        Date dt = new Date();
        String temp_str = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        temp_str = sdf.format(dt);
        temp_str = temp_str.substring(0, 4);
        int Year = 0;
        try {
            Date birthDate = sdf.parse(birthday);
            String tmpDate = sdf.format(birthDate);
            if (!tmpDate.equals(birthday)) {
                return false;
            }
            Year = Integer.parseInt(temp_str) - Integer.parseInt(birthYear);
            if (Year < 3 && Year > 100) {
                return false;
            }
        }
        catch (ParseException e1) {
            return false;
        }
        String idcard18Code = idcard.substring(17, 18);
        char[] c = idcard17.toCharArray();
        int[] bit = IdCardVerify.converCharToInt(c);
        int sum17 = 0;
        sum17 = IdCardVerify.getPowerSum(bit);
        String checkCode = IdCardVerify.getCheckCodeBySum(sum17);
        return null != checkCode;
    }

    private static int[] converCharToInt(char[] chars) {
        int[] i = new int[chars.length];
        for (int j = 0; j < chars.length; ++j) {
            i[j] = IdCardVerify.getNumericValue(chars[j]);
        }
        return i;
    }

    public static int getNumericValue(char ch) {
        return Character.getNumericValue((int)ch);
    }

    private static boolean checkProvinceid(String provinceid) {
        for (String id : cityCode) {
            if (!id.equals(provinceid)) continue;
            return true;
        }
        return false;
    }

    private static int getPowerSum(int[] bit) {
        int sum = 0;
        if (power.length != bit.length) {
            return sum;
        }
        for (int i = 0; i < bit.length; ++i) {
            for (int j = 0; j < power.length; ++j) {
                if (i != j) continue;
                sum += bit[i] * power[j];
            }
        }
        return sum;
    }

    private static String getCheckCodeBySum(int sum17) {
        String checkCode = null;
        switch (sum17 % 11) {
            case 10: {
                checkCode = "2";
                break;
            }
            case 9: {
                checkCode = "3";
                break;
            }
            case 8: {
                checkCode = "4";
                break;
            }
            case 7: {
                checkCode = "5";
                break;
            }
            case 6: {
                checkCode = "6";
                break;
            }
            case 5: {
                checkCode = "7";
                break;
            }
            case 4: {
                checkCode = "8";
                break;
            }
            case 3: {
                checkCode = "9";
                break;
            }
            case 2: {
                checkCode = "x";
                break;
            }
            case 1: {
                checkCode = "0";
                break;
            }
            case 0: {
                checkCode = "1";
                break;
            }
        }
        return checkCode;
    }

    public static void main(String[] args) {
        boolean JY = IdCardVerify.isValidatedAllIdcard("372425196108194614");
        System.out.println(JY);
    }
}

