/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.util;

import com.bcxin.ins.util.BASE64Util;
import com.google.common.collect.Maps;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class FileHelp {
    private static Logger logger = LoggerFactory.getLogger(FileHelp.class);

    public static void mFile(MultipartFile mFile, String path, String fileName) {
        try {
            File fileP = new File(path);
            if (!fileP.exists()) {
                fileP.mkdirs();
            }
            File file = new File(path + fileName);
            mFile.transferTo(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void byteFile(byte[] bytes, String path, String fileName) {
        File fileP = new File(path);
        if (!fileP.exists()) {
            fileP.mkdirs();
        }
        File file = new File(path + fileName);
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file, true));){
            for (int h = 0; h < bytes.length; ++h) {
                bos.write(bytes[h]);
            }
            bos.write("\r\n".getBytes());
            bos.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String reportUpload(MultipartFile file, String pathHead, String folder, String domainName) {
        if (file == null) return "";
        String fileType = file.getOriginalFilename().split(".")[1];
        String fileName = System.currentTimeMillis() + "_RNO." + fileType;
        try (InputStream inStream = file.getInputStream();){
            String path = pathHead + folder;
            FileHelp.isFile(inStream, path, fileName);
            FileHelp.imageOp(path + fileName, 100, 80);
            String string = domainName + "/getResource?path=" + folder + fileName;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static void isFile(InputStream inStream, String path, String fileName) {
        File fileP = new File(path);
        if (!fileP.exists()) {
            fileP.mkdirs();
        }
        File file = new File(path + fileName);
        try (BufferedInputStream bis = new BufferedInputStream(inStream);
             BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file, true));){
            int bytesRead;
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
            bos.write("\r\n".getBytes());
            bos.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String saveFile(String fileUrl) {
        String filePath = "/data/upload/blb/policy/";
        String fileName = new Date().getTime() + RandomStringUtils.random((int)5, (char[])new char[]{'a', 'b', 'c', 'd', 'e', 'f'});
        return FileHelp.downloadFileAndSave(fileUrl, filePath, fileName, ".jpg");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String downloadFileAndSave(String fileUrl, String filePath, String fileName, String fileFix) {
        String result = fileUrl;
        if (StringUtils.isNotEmpty((CharSequence)fileUrl)) {
            InputStream inStream = null;
            try {
                URL url = new URL(fileUrl);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(5000);
                inStream = conn.getInputStream();
                FileHelp.isFile(inStream, filePath, fileName + fileFix);
                result = "/getResource?path=/policy/" + fileName + fileFix;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> httpFileToBase64(String fileUrl) {
        HashMap map = Maps.newHashMap();
        String base64 = "";
        String size = "0";
        if (StringUtils.isNotEmpty((CharSequence)fileUrl)) {
            InputStream inStream = null;
            try {
                URL url = new URL(fileUrl);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(5000);
                inStream = conn.getInputStream();
                size = String.valueOf(inStream.available() / 1000);
                base64 = BASE64Util.encryptBASE64Byte(IOUtils.toByteArray((InputStream)inStream));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
        map.put("size", size);
        map.put("base64", base64);
        return map;
    }

    public static void imageOp(String inFilePath, int width, int height) {
        File tempFile = new File(inFilePath);
        BufferedImage image = null;
        try {
            image = ImageIO.read(tempFile);
        }
        catch (IOException e) {
            System.out.println("file path error...");
        }
        int originalImageWidth = ((Image)image).getWidth(null);
        int originalImageHeight = ((Image)image).getHeight(null);
        BufferedImage originalImage = new BufferedImage(originalImageWidth, originalImageHeight, 5);
        Graphics2D g2d = originalImage.createGraphics();
        g2d.drawImage((Image)image, 0, 0, null);
        BufferedImage changedImage = new BufferedImage(width, height, 5);
        double widthBo = (double)width / (double)originalImageWidth;
        double heightBo = (double)width / (double)originalImageHeight;
        AffineTransform transform = new AffineTransform();
        transform.setToScale(widthBo, heightBo);
        AffineTransformOp ato = new AffineTransformOp(transform, null);
        ato.filter(originalImage, changedImage);
        String outFilePath = inFilePath.replace(".", "_THUMB.");
        File fo = new File(outFilePath);
        try {
            ImageIO.write((RenderedImage)changedImage, "jpeg", fo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

