/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.util;

import com.bcxin.ins.util.CxfBase64Utility;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.OSSFileUtil;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.xiaoleilu.hutool.io.FileUtil;
import com.xiaoleilu.hutool.lang.Console;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBatchUtil {
    private static Logger logger = LoggerFactory.getLogger(FileBatchUtil.class);
    private static String MAP_URL = "url";
    private static String MAP_NAME = "name";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeFileToZip(String zipName, List<Map<String, String>> list) {
        String resultPath = "";
        String downloadFilename = zipName + ".zip";
        try {
            downloadFilename = URLEncoder.encode(downloadFilename, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String pathTop = GlobalResources.COM_IMG_RE + "/zip/";
        resultPath = pathTop + downloadFilename;
        logger.info("writeFileToZip:(resultPath)-" + resultPath);
        File resultPathFile = new File(pathTop);
        if (!resultPathFile.exists()) {
            resultPathFile.mkdirs();
        }
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(new File(resultPath)));){
            for (Map<String, String> map : list) {
                String urls = map.get(MAP_URL);
                InputStream fis = null;
                try {
                    if (!StringUtils.isNotEmpty((CharSequence)urls)) continue;
                    String fTy = urls.substring(urls.indexOf(46), urls.length());
                    if (urls.contains(".com/")) {
                        String keyH = urls.split(".com/")[1];
                        fTy = keyH.substring(keyH.indexOf(46), keyH.length());
                        fis = OSSFileUtil.getInputStreamByKey(keyH);
                    } else {
                        URL url = new URL(urls);
                        fis = url.openConnection().getInputStream();
                    }
                    zos.putNextEntry(new ZipEntry(map.get(MAP_NAME) + fTy));
                    logger.info("writeFileToZip:(zip.index)-name:" + urls + ",url:" + map.get(MAP_NAME) + fTy);
                    byte[] buffer = new byte[1024];
                    int r = 0;
                    while ((r = fis.read(buffer)) != -1) {
                        zos.write(buffer, 0, r);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (fis == null) continue;
                    fis.close();
                }
            }
            zos.flush();
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage() + e);
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.error(e.getMessage() + e);
            e.printStackTrace();
        }
        logger.info("writeFileToZip:(return)-resultPath:" + resultPath);
        return resultPath;
    }

    public static boolean deleteFile(String sPath) {
        Boolean flag = false;
        File file = new File(sPath);
        if (file.isFile() && file.exists()) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            flag = true;
        }
        return flag;
    }

    public static String dealErJinZhiFile(String zipName, List<Map<String, String>> list) throws Exception {
        String zipPath = FileBatchUtil.writeFileToZip(zipName, list);
        String fileString = "";
        if (StringUtils.isNotEmpty((CharSequence)zipPath)) {
            byte[] buff = FileUtil.readBytes((File)new File(zipPath));
            fileString = CxfBase64Utility.encode(buff);
        }
        return fileString;
    }

    public static void main(String[] args) throws Exception {
        String zipFil = "F://D_pan/ase/zip/1524039872820.zip";
        byte[] buff = FileUtil.readBytes((File)new File(zipFil));
        String fileString = CxfBase64Utility.encode(buff);
        Console.log((Object)fileString);
        byte[] zipInfoByte = CxfBase64Utility.decode(fileString);
        String zipNamePath = "F:\\D_pan\\ase\\zip\\new_aa.zip";
        File file = new File(zipNamePath);
        if (file.exists()) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try (FileOutputStream fileout = new FileOutputStream(file);){
            fileout.write(zipInfoByte, 0, zipInfoByte.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

