/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.util;

import com.bcxin.ins.util.DesUtil;
import com.bcxin.ins.util.GlobalResources;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;

public class ErweimaUtil {
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;

    public static void main(String[] args) throws Exception {
        String oidStr = DesUtil.desEncodeCBC("SFJJSKFJMW%^@234J41A5DSFAHI", "AXIM999Z2016E100101H");
        oidStr = URLEncoder.encode(oidStr, "UTF-8");
        System.out.println(oidStr);
        String vv = URLDecoder.decode(oidStr, "UTF-8");
        vv = DesUtil.desDecodeCBC("SFJJSKFJMW%^@234J41A5DSFAHI", vv);
        System.out.println(vv);
    }

    public static void compound(String pno, String pdfPath, String codePath, String resultPath) throws Exception {
        GlobalResources res = new GlobalResources();
        ErweimaUtil.createErWeiMa(GlobalResources.DIMENSIONCODE + pno, codePath);
        PdfReader pdfReader = new PdfReader(pdfPath);
        PdfStamper pdfStamper = new PdfStamper(pdfReader, (OutputStream)new FileOutputStream(resultPath));
        PdfContentByte over = pdfStamper.getOverContent(1);
        Image img = Image.getInstance((String)codePath);
        img.setAlignment(1);
        img.scaleAbsolute(100.0f, 100.0f);
        img.setAbsolutePosition(52.0f, 390.0f);
        over.addImage(img);
        pdfStamper.close();
    }

    public static BufferedImage toBufferedImage(BitMatrix matrix) {
        int[] rec = matrix.getEnclosingRectangle();
        int resWidth = rec[2] + 1;
        int resHeight = rec[3] + 1;
        BitMatrix resMatrix = new BitMatrix(resWidth, resHeight);
        resMatrix.clear();
        for (int i = 0; i < resWidth; ++i) {
            for (int j = 0; j < resHeight; ++j) {
                if (!matrix.get(i + rec[0], j + rec[1])) continue;
                resMatrix.set(i, j);
            }
        }
        int width = resMatrix.getWidth();
        int height = resMatrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, resMatrix.get(x, y) ? -16777216 : -1);
            }
        }
        return image;
    }

    public static void writeToFile(BitMatrix matrix, String format, File file) throws IOException {
        BufferedImage image = ErweimaUtil.toBufferedImage(matrix);
        if (!ImageIO.write((RenderedImage)image, format, file)) {
            throw new IOException("Could not write an image of format " + format + " to " + file);
        }
    }

    public static void writeToStream(BitMatrix matrix, String format, OutputStream stream) throws IOException {
        BufferedImage image = ErweimaUtil.toBufferedImage(matrix);
        if (!ImageIO.write((RenderedImage)image, format, stream)) {
            throw new IOException("Could not write an image of format " + format);
        }
    }

    public static void createErWeiMa(String url, String path) throws Exception {
        String oid = url.substring(url.lastIndexOf(47) + 1, url.length());
        String oidStr = DesUtil.desEncodeCBC("SFJJSKFJMW%^@234J41A5DSFAHI", oid);
        oidStr = URLEncoder.encode(oidStr, "UTF-8");
        url = url.substring(0, url.lastIndexOf(47));
        url = url + "?pno=" + oidStr;
        System.out.println(url);
        int width = 300;
        int height = 300;
        String format = "jpg";
        Hashtable<EncodeHintType, String> hints = new Hashtable<EncodeHintType, String>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        BitMatrix bitMatrix = new MultiFormatWriter().encode(url, BarcodeFormat.QR_CODE, width, height, hints);
        File outputFile = new File(path);
        ErweimaUtil.writeToFile(bitMatrix, format, outputFile);
    }

    public static String createErWeiMaToBase64(String data) throws Exception {
        int width = 300;
        int height = 300;
        String format = "jpg";
        Hashtable<EncodeHintType, String> hints = new Hashtable<EncodeHintType, String>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        BitMatrix bitMatrix = new MultiFormatWriter().encode(data, BarcodeFormat.QR_CODE, width, height, hints);
        BufferedImage image = ErweimaUtil.toBufferedImage(bitMatrix);
        return ErweimaUtil.bufferedImageToBase64(image);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String bufferedImageToBase64(BufferedImage bufferedImage) {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)bufferedImage, "jpg", stream);
            byte[] bytes = Base64.encodeBase64((byte[])stream.toByteArray());
            String base64 = new String(bytes);
            String string = "data:image/jpeg;base64," + base64;
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }
}

