/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.util;

import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static Logger log = LoggerFactory.getLogger(DateUtil.class);
    public static final String FORMAT1 = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT1_1 = "yyyy-MM-dd HH:mm";
    public static final String FORMAT1_2 = "yyyyMMddHHmmss";
    public static final String FORMAT2 = "yyyy-MM-dd";
    public static final String FORMAT3 = "MM/dd/yyyy HH:mm:ss";
    public static final String FORMAT4 = "MM/dd/yyyy";
    public static final String FORMAT5 = "HH:mm:ss";
    public static final String FORMAT6 = "yyyyMMdd";
    public static final String FORMAT7 = "HH";
    public static final int DATATYPE_YEAR = 1;
    public static final int DATATYPE_MONTH = 2;
    public static final int DATATYPE_DAY = 3;
    public static final int DATATYPE_HOUR = 4;
    public static final int DATATYPE_MINUTE = 5;
    public static final int DATATYPE_SECOND = 6;

    private DateUtil() {
    }

    public static String getFormat(String date) throws Exception {
        String reg1 = "\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}(.\\d{1,3}){0,1}";
        String reg2 = "\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}";
        String reg3 = "\\d{4}-\\d{1,2}-\\d{1,2}";
        String reg4 = "\\d{1,2}/\\d{1,2}/\\d{4} \\d{1,2}:\\d{1,2}:\\d{1,2}(.\\d{1,3}){0,1}";
        String reg5 = "\\d{1,2}/\\d{1,2}/\\d{4}";
        if (date.matches(reg1)) {
            return FORMAT1;
        }
        if (date.matches(reg2)) {
            return FORMAT1_1;
        }
        if (date.matches(reg3)) {
            return FORMAT2;
        }
        if (date.matches(reg4)) {
            return FORMAT3;
        }
        if (date.matches(reg5)) {
            return FORMAT4;
        }
        throw new Exception("\u4e0d\u652f\u6301\u7684\u65e5\u671f\u683c\u5f0f\uff1a" + date);
    }

    public static String formatDate(java.util.Date date, Object ... pattern) {
        String formatDate = null;
        formatDate = pattern != null && pattern.length > 0 ? DateFormatUtils.format((java.util.Date)date, (String)pattern[0].toString()) : DateFormatUtils.format((java.util.Date)date, (String)FORMAT2);
        return formatDate;
    }

    public static String getCurrentDate() {
        return DateUtil.getCurrentDateTime(FORMAT2);
    }

    public static String getCurrentDate_1() {
        return DateUtil.getCurrentDateTime(FORMAT1_1);
    }

    public static String getCurrentTime() {
        return DateUtil.getCurrentDateTime(FORMAT5);
    }

    public static String getCurrentDateTime() {
        return DateUtil.getCurrentDateTime(FORMAT1);
    }

    public static String getCurrentDateTime(String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(new java.util.Date());
    }

    public static String getYesterday() {
        SimpleDateFormat df = new SimpleDateFormat(FORMAT2);
        Calendar c = Calendar.getInstance();
        c.add(5, -1);
        return df.format(c.getTime());
    }

    public static String getTomorrow() {
        SimpleDateFormat df = new SimpleDateFormat(FORMAT2);
        Calendar c = Calendar.getInstance();
        c.add(5, 1);
        return df.format(c.getTime());
    }

    public static String dateFormatLast(String value) {
        try {
            java.util.Date date = DateUtil.convertStringToDate(value);
            String dateStr = DateUtil.convertDateToString(date, FORMAT2);
            return dateStr + " 24:00:00";
        }
        catch (Exception e) {
            log.error("+23.59.59", (Throwable)e);
            return "";
        }
    }

    public static java.util.Date convertStringToDate(String date) {
        try {
            SimpleDateFormat df = new SimpleDateFormat(DateUtil.getFormat(date));
            return df.parse(date);
        }
        catch (Exception e) {
            log.error("String\u8f6c\u6362date", (Throwable)e);
            return new java.util.Date();
        }
    }

    public static String convertDateToString(java.util.Date date, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    public static String dateFormat(String value, String format) {
        try {
            java.util.Date date = DateUtil.convertStringToDate(value);
            return DateUtil.convertDateToString(date, format);
        }
        catch (Exception e) {
            log.error("dateFormat", (Throwable)e);
            return "";
        }
    }

    public static int dateDiff(int type, String sdate1, String sdate2) throws Exception {
        java.util.Date date1 = new SimpleDateFormat(DateUtil.getFormat(sdate1)).parse(sdate1);
        java.util.Date date2 = new SimpleDateFormat(DateUtil.getFormat(sdate2)).parse(sdate2);
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        int yearDiff = cal2.get(1) - cal1.get(1);
        if (type == 1) {
            return yearDiff;
        }
        if (type == 2) {
            int monthDiff = yearDiff * 12 + cal2.get(2) - cal1.get(2);
            return monthDiff;
        }
        long ldate1 = date1.getTime() + (long)cal1.get(15) + (long)cal1.get(16);
        long ldate2 = date2.getTime() + (long)cal2.get(15) + (long)cal2.get(16);
        if (type == 4) {
            return (int)((ldate2 - ldate1) / 3600000L);
        }
        if (type == 5) {
            return (int)((ldate2 - ldate1) / 60000L);
        }
        if (type == 6) {
            return (int)((ldate2 - ldate1) / 1000L);
        }
        return (int)((ldate2 - ldate1) / 86400000L);
    }

    public static String dateAdd(int type, String sdate, int num) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat(DateUtil.getFormat(sdate));
        java.util.Date date = df.parse(sdate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (type == 1) {
            cal.add(1, num);
        } else if (type == 2) {
            cal.add(2, num);
        } else if (type == 4) {
            cal.add(10, num);
        } else if (type == 5) {
            cal.add(12, num);
        } else if (type == 6) {
            cal.add(13, num);
        } else {
            cal.add(5, num);
        }
        return df.format(cal.getTime());
    }

    public static int calAge(String birthday, String type) throws Exception {
        String currDate = DateUtil.getCurrentDate();
        if ("D".equalsIgnoreCase(type)) {
            return DateUtil.dateDiff(3, birthday, currDate);
        }
        if ("M".equalsIgnoreCase(type)) {
            int result = DateUtil.dateDiff(2, birthday, currDate);
            String temp = DateUtil.dateAdd(2, birthday, result);
            if (DateUtil.dateDiff(3, temp, currDate) <= 0) {
                --result;
            }
            return result;
        }
        int result = DateUtil.dateDiff(1, birthday, currDate);
        String temp = DateUtil.dateAdd(1, birthday, result);
        if (DateUtil.dateDiff(3, temp, currDate) <= 0) {
            --result;
        }
        return result;
    }

    public static int getYearOfDate(java.util.Date date) {
        Calendar gc = DateUtil.prepare(date);
        return gc.get(1);
    }

    public static int getMonthOfDate(java.util.Date date) {
        Calendar gc = DateUtil.prepare(date);
        return gc.get(2);
    }

    public static int getDayOfDate(java.util.Date date) {
        Calendar gc = DateUtil.prepare(date);
        return gc.get(5);
    }

    public static java.util.Date addYear(java.util.Date date, int year) {
        Calendar gc = DateUtil.prepare(date);
        gc.add(1, year);
        return gc.getTime();
    }

    public static java.util.Date addMonth(java.util.Date date, int month) {
        Calendar gc = DateUtil.prepare(date);
        gc.add(2, month);
        return gc.getTime();
    }

    public static java.util.Date addDay(java.util.Date date, int day) {
        Calendar gc = DateUtil.prepare(date);
        gc.add(5, day);
        return gc.getTime();
    }

    private static Calendar prepare(java.util.Date date) {
        Calendar gc = Calendar.getInstance();
        gc.setTime(date);
        return gc;
    }

    public static java.util.Date rollingDate(java.util.Date date, int field, int amount) {
        Calendar gc = DateUtil.prepare(date);
        gc.roll(field, amount);
        return gc.getTime();
    }

    public static String dateExcel(String excTime) {
        excTime = excTime.split("-")[2] + "\u5e74" + DateUtil.monthChange(excTime.split("-")[1]) + "\u6708" + excTime.split("-")[1] + "\u65e5";
        return DateUtil.marsalDate(excTime);
    }

    private static String monthChange(String month) {
        String result = null;
        switch (month) {
            case "\u5341\u4e8c\u6708": {
                result = "12";
                break;
            }
            case "\u5341\u4e00\u6708": {
                result = "11";
                break;
            }
            case "\u5341\u6708": {
                result = "10";
                break;
            }
            case "\u4e5d\u6708": {
                result = "09";
                break;
            }
            case "\u516b\u6708": {
                result = "08";
                break;
            }
            case "\u4e03\u6708": {
                result = "07";
                break;
            }
            case "\u516d\u6708": {
                result = "06";
                break;
            }
            case "\u4e94\u6708": {
                result = "05";
                break;
            }
            case "\u56db\u6708": {
                result = "04";
                break;
            }
            case "\u4e09\u6708": {
                result = "03";
                break;
            }
            case "\u4e8c\u6708": {
                result = "02";
                break;
            }
            case "\u4e00\u6708": {
                result = "01";
                break;
            }
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(DateUtil.getHours());
    }

    public static boolean timestampIntervalIntersection(java.util.Date firstStart, java.util.Date firstEnd, java.util.Date twoStart, java.util.Date twoEnd) {
        if (firstStart.after(twoStart) && firstStart.before(twoEnd)) {
            return true;
        }
        if (firstEnd.after(twoStart) && firstEnd.before(twoEnd)) {
            return true;
        }
        if (firstStart.equals(twoStart) || firstStart.equals(twoEnd)) {
            return true;
        }
        if (firstEnd.equals(twoStart) || firstEnd.equals(twoEnd)) {
            return true;
        }
        return firstStart.before(twoStart) && firstEnd.after(twoEnd);
    }

    public static java.util.Date setFieldInLimit(java.util.Date date, int field, int value) {
        Calendar gc = DateUtil.prepare(date);
        gc.set(field, Math.min(gc.getActualMaximum(field), value));
        return gc.getTime();
    }

    public static java.util.Date parseDate(String value) {
        Date date = Date.valueOf(value);
        return date;
    }

    public static java.util.Date getDayStart(java.util.Date currentDate) {
        java.util.Date result = null;
        Calendar current = Calendar.getInstance();
        current.setTime(currentDate);
        current.set(11, 0);
        current.clear(14);
        current.clear(12);
        current.clear(13);
        result = current.getTime();
        return result;
    }

    public static java.util.Date getDayEnd(java.util.Date day) {
        java.util.Date result = null;
        Calendar date = Calendar.getInstance();
        date.setTime(day);
        date.set(11, 24);
        date.clear(12);
        date.clear(13);
        date.set(14, -1);
        result = date.getTime();
        return result;
    }

    public static java.util.Date getTodayStart() {
        return DateUtil.getDayStart(new java.util.Date());
    }

    public static java.util.Date getTodayEnd() {
        return DateUtil.getDayEnd(new java.util.Date());
    }

    public static String thisMonday() {
        try {
            return DateUtil.dateAdd(3, DateUtil.convertDateToString(DateUtil.getWeekStart(), FORMAT2), 1);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static java.util.Date getWeekStart() {
        java.util.Date result = null;
        Calendar current = Calendar.getInstance();
        current.set(11, 0);
        current.clear(14);
        current.clear(12);
        current.clear(13);
        current.set(7, current.getFirstDayOfWeek());
        result = current.getTime();
        return result;
    }

    public static java.util.Date getWeekEnd() {
        java.util.Date result = null;
        Calendar current = Calendar.getInstance();
        current.setTime(DateUtil.getWeekStart());
        current.add(3, 1);
        current.set(14, -1);
        result = current.getTime();
        return result;
    }

    public static java.util.Date getMonthStart(java.util.Date currentDate) {
        java.util.Date result = null;
        Calendar current = Calendar.getInstance();
        current.setTime(DateUtil.getDayStart(currentDate));
        current.set(5, 1);
        result = current.getTime();
        return result;
    }

    public static java.util.Date getYearStart(java.util.Date date) {
        int year = DateUtil.getYearOfDate(date);
        Calendar result = Calendar.getInstance();
        result.set(year, 0, 1);
        return result.getTime();
    }

    public static java.util.Date getMonthStart(int year, int month) {
        Calendar sampleDate = Calendar.getInstance();
        sampleDate.set(1, year);
        sampleDate.set(2, month);
        return DateUtil.getMonthStart(sampleDate.getTime());
    }

    public static java.util.Date getMonthEnd(java.util.Date currentDate) {
        java.util.Date result = null;
        Calendar current = Calendar.getInstance();
        current.setTime(DateUtil.getMonthStart(currentDate));
        current.add(2, 1);
        current.add(14, -1);
        result = current.getTime();
        return result;
    }

    public static java.util.Date getMonthEnd(int year, int month) {
        Calendar sampleDate = Calendar.getInstance();
        sampleDate.set(1, year);
        sampleDate.set(2, month);
        return DateUtil.getMonthEnd(sampleDate.getTime());
    }

    public static int calculateDisparity(java.util.Date beforeDate, java.util.Date afterDate, int calendar_time_type, int roundingMode) {
        int result;
        block6: {
            Calendar before;
            Calendar after;
            block7: {
                block5: {
                    result = 0;
                    if (beforeDate == null || afterDate == null) {
                        throw new IllegalArgumentException("beforeDate and afterDate can not be null.");
                    }
                    if (calendar_time_type == 5) {
                        throw new IllegalArgumentException("Calendar.Date is not supported now.");
                    }
                    after = DateUtil.prepare(afterDate);
                    before = DateUtil.prepare(beforeDate);
                    if (calendar_time_type != 5) break block5;
                    result -= before.get(6);
                    while (before.before(after)) {
                        result += before.getActualMaximum(6);
                        before.add(1, 1);
                    }
                    result += before.get(6);
                    break block6;
                }
                if (roundingMode != 1) break block7;
                result = -1;
                while (!before.after(after)) {
                    ++result;
                    before.add(calendar_time_type, 1);
                }
                break block6;
            }
            if (roundingMode != 0) break block6;
            result = 0;
            while (before.before(after)) {
                ++result;
                before.add(calendar_time_type, 1);
            }
        }
        return result;
    }

    public static java.util.Date mergeDate(java.util.Date day, java.util.Date time) {
        Calendar result = Calendar.getInstance();
        result.setTime(time);
        Calendar dayHelper = Calendar.getInstance();
        dayHelper.setTime(day);
        result.set(dayHelper.get(1), dayHelper.get(2), dayHelper.get(5));
        return result.getTime();
    }

    public static Iterator dateIterator(java.util.Date start, java.util.Date end) {
        return new DateIterator(start, end);
    }

    public static Iterator calendarIterator(Calendar start, Calendar end) {
        return new CalendarIterator(start, end);
    }

    public static boolean isInThePeriod(java.util.Date asOfDate, java.util.Date start, java.util.Date end) {
        return !asOfDate.before(start) && !asOfDate.after(end);
    }

    public static java.util.Date getFirstDayOfLastMonth() throws ParseException {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.add(2, -1);
        calendar1.set(5, 1);
        java.util.Date day = calendar1.getTime();
        return day;
    }

    public static java.util.Date getLastDayOfLastMonth() throws ParseException {
        Calendar calendar2 = Calendar.getInstance();
        calendar2.add(2, -1);
        calendar2.set(5, 0);
        java.util.Date day = calendar2.getTime();
        return day;
    }

    public static java.util.Date getFirstDayOfThisMonth() throws ParseException {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.add(2, 0);
        calendar1.set(5, 1);
        java.util.Date day = calendar1.getTime();
        return day;
    }

    public static java.util.Date getLastDayOfThisMonth() throws ParseException {
        Calendar calendar2 = Calendar.getInstance();
        calendar2.add(2, 1);
        calendar2.set(5, 0);
        java.util.Date day = calendar2.getTime();
        return day;
    }

    public static java.util.Date getFirstDayOfThisQuarter() throws ParseException {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new java.util.Date());
        int month = DateUtil.getQuarterInMonth(calendar.get(2), true);
        calendar.set(2, month);
        calendar.set(5, 1);
        java.util.Date day = calendar.getTime();
        return day;
    }

    public static java.util.Date getLastDayOfThisQuarter() throws ParseException {
        GregorianCalendar endCalendar = new GregorianCalendar();
        endCalendar.setTime(new java.util.Date());
        int month = DateUtil.getQuarterInMonth(endCalendar.get(2), false);
        endCalendar.set(2, month + 1);
        endCalendar.set(5, 0);
        java.util.Date day = endCalendar.getTime();
        return day;
    }

    private static int getQuarterInMonth(int month, boolean isQuarterStart) {
        int[] months = new int[]{1, 4, 7, 10};
        if (!isQuarterStart) {
            months = new int[]{3, 6, 9, 12};
        }
        if (month >= 1 && month <= 3) {
            return months[0];
        }
        if (month >= 4 && month <= 6) {
            return months[1];
        }
        if (month >= 7 && month <= 9) {
            return months[2];
        }
        return months[3];
    }

    public static java.util.Date getCurrentYearStartTime() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(5, cal.getActualMinimum(1));
        return cal.getTime();
    }

    public static java.util.Date getCurrentYearEndTime() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getCurrentYearStartTime());
        cal.add(1, 1);
        return cal.getTime();
    }

    public static String getThisYearLastDay() {
        Calendar c = Calendar.getInstance();
        c.setTime(new java.util.Date());
        String nextYear = c.get(1) + 1 + "-01-01";
        String ld = "";
        try {
            ld = DateUtil.dateAdd(3, nextYear, -1);
        }
        catch (Exception e) {
            ld = c.get(1) + "-12-31";
        }
        return ld;
    }

    public static String getThisYearThisDay() {
        Calendar c = Calendar.getInstance();
        c.setTime(new java.util.Date());
        return c.get(1) + "-01-01";
    }

    public static boolean isSameDay(java.util.Date one, java.util.Date two) {
        return DateUtil.getYearOfDate(one) == DateUtil.getYearOfDate(two) && DateUtil.getMonthOfDate(one) == DateUtil.getMonthOfDate(two) && DateUtil.getDayOfDate(one) == DateUtil.getDayOfDate(two);
    }

    public static boolean isFirstDateOfMonth(java.util.Date date) {
        int day = date.getDate();
        return day == 1;
    }

    public static boolean isFirstDayFromThisMonth(java.util.Date date) {
        java.util.Date today = new java.util.Date();
        return (today.before(date) || today.equals(date)) && DateUtil.isFirstDateOfMonth(date);
    }

    public static boolean isFirstDayFromNextMonth(java.util.Date date) {
        java.util.Date today = new java.util.Date();
        if (today.before(date) && DateUtil.isFirstDateOfMonth(date)) {
            return today.getMonth() != date.getMonth();
        }
        return false;
    }

    public static boolean laterThanToday(java.util.Date effectiveDate) {
        java.util.Date today = DateUtil.getTodayStart();
        return today.before(effectiveDate) || today.equals(effectiveDate);
    }

    public static boolean laterThanFirstDayOfThisMonth(java.util.Date effectiveDate) {
        java.util.Date firstDayOfThisMonth = DateUtil.getMonthStart(new java.util.Date());
        return firstDayOfThisMonth.before(effectiveDate) || firstDayOfThisMonth.equals(effectiveDate);
    }

    public static boolean isValidFormat(String externalReference) {
        boolean isValid = true;
        Integer year = 0;
        Integer month = 0;
        if (externalReference.length() == 6) {
            try {
                year = Integer.valueOf(externalReference.substring(0, 4));
                month = Integer.valueOf(externalReference.substring(4));
            }
            catch (Exception e) {
                log.error("externalReference", (Throwable)e);
                isValid = false;
            }
        } else {
            isValid = false;
        }
        if (year < 1970 || year > 2099 || month > 12 || month < 1) {
            isValid = false;
        }
        return isValid;
    }

    public static int compareDate(java.util.Date date1, java.util.Date date2, int stype) {
        int n = 0;
        String[] u = new String[]{"\ufffd\ufffd", "\ufffd\ufffd", "\ufffd\ufffd"};
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        try {
            c1.setTime(date1);
            c2.setTime(date2);
        }
        catch (Exception e3) {
            log.error("wrong occured", (Throwable)e3);
        }
        while (!c1.after(c2)) {
            ++n;
            if (stype == 1) {
                c1.add(2, 1);
                continue;
            }
            c1.add(5, 1);
        }
        --n;
        if (stype == 2) {
            n /= 365;
        }
        System.out.println(date1 + " -- " + date2 + " \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd" + u[stype] + ":" + n);
        return n;
    }

    public static java.util.Date getDate(String date) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(FORMAT2);
        String dateValue = DateUtil.marsalDate(date);
        if (StringUtils.isNotEmpty((CharSequence)dateValue)) {
            return dateFormat.parse(dateValue);
        }
        return null;
    }

    public static java.util.Date StingToDate(String dateValue) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(FORMAT2);
        if (StringUtils.isNotEmpty((CharSequence)dateValue)) {
            return dateFormat.parse(dateValue);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String marsalDate(String date) {
        String day;
        String month;
        String year;
        date = date.replace("\u5e74", "-").replace("\u6708", "-").replace("\u65e5", "");
        String split = "./-\t\\s";
        if (date.length() > 10) return null;
        StringTokenizer tokenizer = new StringTokenizer(date, split);
        int tokenCount = tokenizer.countTokens();
        if (tokenCount == 3) {
            year = tokenizer.nextToken();
            month = tokenizer.nextToken();
            day = tokenizer.nextToken();
            return DateUtil.marsalDate(year, month, day);
        } else {
            if (tokenCount != 1) return null;
            String dateTemp = tokenizer.nextToken();
            if (dateTemp.length() == 8) {
                year = dateTemp.substring(0, 4);
                month = dateTemp.substring(4, 6);
                day = dateTemp.substring(6, 8);
                return DateUtil.marsalDate(year, month, day);
            } else {
                if (dateTemp.length() != 6) return null;
                year = dateTemp.substring(0, 4);
                month = dateTemp.substring(4, 5);
                day = dateTemp.substring(5, 6);
            }
        }
        return DateUtil.marsalDate(year, month, day);
    }

    public static String marsalDate(String year, String month, String day) {
        if (year.length() != 4 || month.length() > 2 || day.length() > 2) {
            return null;
        }
        String yearTemp = year;
        String monthTemp = month.length() == 1 ? "0" + month : month;
        String dayTemp = day.length() == 1 ? "0" + day : day;
        String date = yearTemp + "-" + monthTemp + "-" + dayTemp;
        return date;
    }

    public static boolean checkIsValidDateFormat(String date) {
        if (date == null) {
            return false;
        }
        if (date.length() != 10) {
            return false;
        }
        String regex = "((\\d{2}(([02468][048])|([13579][26]))[\\-\\s]?((((0?[13578])|(1[02]))[\\-\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\s]?((((0?[13578])|(1[02]))[\\-\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))";
        Pattern pattern = Pattern.compile(regex);
        Matcher mather = pattern.matcher(date);
        return mather.matches();
    }

    public static boolean checkIsValidDateTimeFormat(String dateTime) {
        if (dateTime == null) {
            return false;
        }
        if (dateTime.length() != 8) {
            return false;
        }
        String regex = "^(([0|1][0-9])|(2[0-3])):[0-5][0-9]:[0-5][0-9]$";
        Pattern pattern = Pattern.compile(regex);
        Matcher mather = pattern.matcher(dateTime);
        return mather.matches();
    }

    public static boolean checkDate(String date) {
        String dateValue = DateUtil.marsalDate(date);
        return DateUtil.checkIsValidDateFormat(dateValue);
    }

    public static synchronized String generatorRadomNumber() {
        java.util.Date today = new java.util.Date();
        SimpleDateFormat format = new SimpleDateFormat(FORMAT1_2);
        String serialNumber = "";
        try {
            serialNumber = format.format(today) + new DecimalFormat("0000").format(new Random().nextInt(10000));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serialNumber;
    }

    public static synchronized String generatorRadomNumberForDate() {
        java.util.Date today = new java.util.Date();
        SimpleDateFormat format = new SimpleDateFormat(FORMAT1_2);
        String serialNumber = format.format(today);
        return serialNumber;
    }

    public static int getDistDates(java.util.Date startDate, java.util.Date endDate) {
        if (null == startDate || null == endDate) {
            return -1;
        }
        long intervalMilli = endDate.getTime() - startDate.getTime();
        return (int)(intervalMilli / 86400000L);
    }

    public static boolean compareDates(java.util.Date startDate, java.util.Date endDate) {
        if (null == startDate || null == endDate) {
            return false;
        }
        long intervalMilli = endDate.getTime() - startDate.getTime();
        return intervalMilli >= 0L;
    }

    public static boolean contains(java.util.Date startDate, java.util.Date endDate, java.util.Date date) {
        if (startDate == null || endDate == null || date == null) {
            return false;
        }
        Interval interval = new Interval((ReadableInstant)new DateTime((Object)startDate), (ReadableInstant)new DateTime((Object)endDate).plusDays(1));
        return interval.contains((ReadableInstant)new DateTime((Object)date));
    }

    public static java.util.Date convertString2Date(String time) {
        java.util.Date date = new java.util.Date();
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT1);
        try {
            date = sdf.parse(time);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return date;
    }

    public static int getHours() {
        java.util.Date date = new java.util.Date();
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT7);
        try {
            return Integer.parseInt(sdf.format(date));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static long calculateTwoDateDvalue(java.util.Date date1, java.util.Date date2) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        long date1value = cal.getTimeInMillis();
        cal.setTime(date2);
        long date2value = cal.getTimeInMillis();
        return date1value - date2value;
    }

    public static Timestamp getTimestamp() {
        java.util.Date date = new java.util.Date();
        Timestamp nousedate = new Timestamp(date.getTime());
        return nousedate;
    }

    public static String fomData(String data) {
        String year = data.split("-")[0];
        String month = data.split("-")[1];
        String day = data.split("-")[2];
        return year + "\u5e74" + month + "\u6708" + day + "\u65e5";
    }

    public static int getAge(String date) throws Exception {
        java.util.Date birthDay = DateUtil.convertStringToDate(date);
        Calendar cal = Calendar.getInstance();
        if (cal.before(birthDay)) {
            throw new IllegalArgumentException("The birthDay is before Now.It's unbelievable!");
        }
        int yearNow = cal.get(1);
        int monthNow = cal.get(2);
        int dayOfMonthNow = cal.get(5);
        cal.setTime(birthDay);
        int yearBirth = cal.get(1);
        int monthBirth = cal.get(2);
        int dayOfMonthBirth = cal.get(5);
        int age = yearNow - yearBirth;
        if (monthNow <= monthBirth) {
            if (monthNow == monthBirth) {
                if (dayOfMonthNow < dayOfMonthBirth) {
                    --age;
                }
            } else {
                --age;
            }
        }
        return age;
    }

    public static Long getTime() throws Exception {
        return System.currentTimeMillis();
    }

    static class DateIterator
    extends CalendarIterator
    implements Iterator {
        DateIterator(java.util.Date startFinal, java.util.Date endFinal) {
            super(DateUtil.prepare(startFinal), DateUtil.prepare(endFinal));
        }

        @Override
        public Object next() {
            return ((Calendar)super.next()).getTime();
        }
    }

    static class CalendarIterator
    implements Iterator {
        private final Calendar endFinal;
        private final Calendar spot;

        CalendarIterator(Calendar startFinal, Calendar endFinal) {
            this.endFinal = endFinal;
            this.spot = startFinal;
            this.spot.add(5, -1);
        }

        @Override
        public boolean hasNext() {
            return this.spot.before(this.endFinal);
        }

        public Object next() {
            if (this.spot.equals(this.endFinal)) {
                throw new NoSuchElementException();
            }
            this.spot.add(5, 1);
            return this.spot.clone();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

