/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.comm.Protocol;
import com.aliyun.oss.model.CopyObjectRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.bcxin.ins.oss.OSSResultInfo;
import com.bcxin.ins.oss.OSSResultObject;
import com.bcxin.ins.oss.OSSService;
import com.bcxin.ins.oss.OSSUtil;
import com.bcxin.ins.util.GlobalResources;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSSServiceExecutor
implements OSSService {
    private String server;
    private final String PROTOCOL_STRING = Protocol.HTTP + "://";
    private static final Logger logger = LoggerFactory.getLogger(OSSServiceExecutor.class);

    public OSSServiceExecutor(boolean isImgFile) {
        if (isImgFile) {
            String extranet = GlobalResources.OSS_SERVERADDRESSS;
            if (GlobalResources.IS_WINDOWS_ENVI) {
                extranet = GlobalResources.OSS_SERVERADDRESSS;
            }
            GlobalResources.OSS_SERVERADDRESSS = extranet;
        }
        this.server = this.PROTOCOL_STRING + GlobalResources.OSS_BUCKETNAME + "." + GlobalResources.OSS_SERVERADDRESSS + "/";
    }

    @Override
    public OSSClient getClient() {
        return new OSSClient(GlobalResources.OSS_SERVERADDRESSS, GlobalResources.OSS_ACCESSID, GlobalResources.OSS_ACCESSKEY);
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public OSSResultInfo createDirectory(String directoryName) {
        ObjectMetadata objectMeta = new ObjectMetadata();
        objectMeta.setContentLength(0L);
        byte[] buffer = new byte[]{};
        ByteArrayInputStream in = new ByteArrayInputStream(buffer);
        OSSClient ossClient = this.getClient();
        PutObjectResult result = ossClient.putObject(GlobalResources.OSS_BUCKETNAME, directoryName + "/", (InputStream)in, objectMeta);
        OSSResultInfo resultInfo = new OSSResultInfo();
        resultInfo.setBucketName(GlobalResources.OSS_BUCKETNAME);
        resultInfo.setName(directoryName);
        resultInfo.setTag(result.getETag());
        resultInfo.setUrl(this.formatUrl(this.PROTOCOL_STRING + GlobalResources.OSS_BUCKETNAME + "." + GlobalResources.OSS_SERVERADDRESSS + "/" + directoryName + "/"));
        return resultInfo;
    }

    @Override
    public OSSResultInfo createDirectory(String directoryName, ObjectMetadata meta) {
        ObjectMetadata objectMeta = new ObjectMetadata();
        objectMeta.setContentLength(0L);
        byte[] buffer = new byte[]{};
        ByteArrayInputStream in = new ByteArrayInputStream(buffer);
        OSSClient ossClient = this.getClient();
        PutObjectResult result = ossClient.putObject(GlobalResources.OSS_BUCKETNAME, directoryName + "/", (InputStream)in, objectMeta);
        OSSResultInfo resultInfo = new OSSResultInfo();
        resultInfo.setBucketName(GlobalResources.OSS_BUCKETNAME);
        resultInfo.setName(directoryName);
        resultInfo.setTag(result.getETag());
        resultInfo.setUrl(this.formatUrl(this.PROTOCOL_STRING + GlobalResources.OSS_BUCKETNAME + "." + GlobalResources.OSS_SERVERADDRESSS + "/" + directoryName + "/"));
        return resultInfo;
    }

    @Override
    public boolean deleteDirectory(String directoryName) {
        OSSClient ossClient = this.getClient();
        try {
            if (directoryName.lastIndexOf("/") != directoryName.length() - 1) {
                ossClient.deleteObject(GlobalResources.OSS_BUCKETNAME, directoryName + "/");
            } else {
                ossClient.deleteObject(GlobalResources.OSS_BUCKETNAME, directoryName);
            }
            return true;
        }
        catch (OSSException e) {
            if (e.getErrorCode().equals("NoSuchKey")) {
                return true;
            }
            throw new OSSException("", (Throwable)e);
        }
    }

    @Override
    public boolean deleteFile(String fileName) {
        OSSClient ossClient = this.getClient();
        try {
            ossClient.deleteObject(GlobalResources.OSS_BUCKETNAME, fileName);
            return true;
        }
        catch (OSSException e) {
            if (e.getErrorCode().equals("NoSuchKey")) {
                return true;
            }
            throw new OSSException("", (Throwable)e);
        }
    }

    @Override
    public boolean isExitsDirectory(String directoryName) {
        OSSClient ossClient = this.getClient();
        boolean result = directoryName.lastIndexOf("/") != directoryName.length() - 1 ? ossClient.doesObjectExist(GlobalResources.OSS_BUCKETNAME, directoryName + "/") : ossClient.doesObjectExist(GlobalResources.OSS_BUCKETNAME, directoryName);
        return result;
    }

    @Override
    public boolean isExitsFile(String file) {
        return this.getClient().doesObjectExist(GlobalResources.OSS_BUCKETNAME, file);
    }

    @Override
    public OSSResultInfo put(String url, File file, boolean isCover) {
        try {
            return this.put(url, (InputStream)new FileInputStream(file), isCover);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public OSSResultInfo put(String url, File file, ObjectMetadata meta, boolean isCover) {
        try {
            return this.put(url, new FileInputStream(file), meta, isCover);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public OSSResultInfo put(String url, InputStream input, ObjectMetadata meta) {
        return this.put(url, input, meta, false);
    }

    @Override
    public OSSResultInfo put(String url, InputStream input, boolean isCover) {
        return this.put(url, input, null, isCover);
    }

    @Override
    public OSSResultInfo put(String url, InputStream input, ObjectMetadata meta, boolean isCover) {
        return this.putObject(url, input, meta, isCover);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OSSResultInfo putObject(String url, InputStream input, ObjectMetadata meta, boolean isCover) {
        block9: {
            OSSClient ossClient = this.getClient();
            try {
                url = url.indexOf("/") == 0 ? url.substring(1) : url;
                boolean condition = url.contains("https://") || url.contains("http://");
                String tmpServer = !condition ? null : url.replace("https://", "").replace("http://", "").replace("//", "/").split("/")[0];
                String key = url.replace(this.server, "").replace("//", "/");
                if (tmpServer != null && !this.server.contains(tmpServer)) break block9;
                if (!isCover && this.isExitsFile(key)) {
                    throw new OSSException("OSS\u9519\u8bef\uff0c\u8be5\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728\uff01\u65e0\u6cd5\u8986\u76d6");
                }
                ObjectMetadata objMeta = OSSUtil.getObjectMetadata(key);
                String fileFix = url.split("\\.")[0];
                String string = fileFix = fileFix != "" ? "." + fileFix : "";
                if (meta != null) {
                    objMeta = meta;
                }
                PutObjectRequest obj = new PutObjectRequest(GlobalResources.OSS_BUCKETNAME, key, input, objMeta);
                logger.debug("\u6267\u884c\u6587\u4ef6OSS\u6587\u4ef6\u4e0a\u4f20");
                PutObjectResult result = ossClient.putObject(obj);
                logger.debug("\u6267\u884c\u6587\u4ef6OSS\u6587\u4ef6\u4e0a\u4f20\u6210\u529f:" + result.toString());
                try {
                    input.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("\u5173\u95ed\u4e0a\u4f20\u6587\u4ef6\u6d41\u5931\u8d25", e);
                }
                OSSResultInfo resultInfo = new OSSResultInfo();
                resultInfo.setBucketName(GlobalResources.OSS_BUCKETNAME);
                resultInfo.setName(key);
                resultInfo.setTag(result.getETag());
                resultInfo.setUrl(this.formatUrl(this.server + key));
                resultInfo.setServerAddress(GlobalResources.OSS_SERVERADDRESSS);
                resultInfo.setHttpUrl(resultInfo.getUrl().replace("https://", "http://"));
                logger.debug("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff01URL\uff1a" + resultInfo.getUrl());
                OSSResultInfo oSSResultInfo = resultInfo;
                return oSSResultInfo;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.debug("exception:\u4f20\u5165\u7684URL\u5730\u5740\u4e0e\u5f53\u524d\u670d\u52a1\u5668\u5730\u5740\u6216bucketName\u4e0d\u4e00\u81f4");
            }
            finally {
                ossClient.shutdown();
            }
        }
        return null;
    }

    @Override
    public File get(String url, String saveFileName) {
        String key = url.replace(this.server, "").replace("//", "/");
        File file = new File(saveFileName);
        OSSClient ossClient = this.getClient();
        ossClient.getObject(new GetObjectRequest(GlobalResources.OSS_BUCKETNAME, key), file);
        return file;
    }

    @Override
    public OSSResultObject get(String url) {
        url = url.indexOf("/") == 0 ? url.substring(1) : url;
        boolean condition = url.contains("https://") || url.contains("http://");
        String tmpServer = !condition ? null : url.replace("https://", "").replace("http://", "").replace("//", "/").split("/")[0];
        String key = url.replace(this.server, "").replace("//", "/");
        if (tmpServer == null || this.server.contains(tmpServer)) {
            OSSObject obj = this.getClient().getObject(GlobalResources.OSS_BUCKETNAME, key);
            OSSResultObject subobj = new OSSResultObject();
            subobj.setBucketName(obj.getBucketName());
            subobj.setKey(key);
            subobj.setFileType(OSSUtil.getFileType(url));
            subobj.setName(OSSUtil.getName(url));
            subobj.setObjectContent(obj.getObjectContent());
            subobj.setMetadata(obj.getObjectMetadata());
            subobj.setUrl(this.formatUrl(this.server + key));
            subobj.setServerAddress(GlobalResources.OSS_SERVERADDRESSS);
            subobj.setHttpUrl(subobj.getUrl().replace("https://", "http://"));
            return subobj;
        }
        throw new OSSException("\u4f20\u5165\u7684URL\u5730\u5740\u4e0e\u5f53\u524d\u670d\u52a1\u5668\u5730\u5740\u6216bucketName\u4e0d\u4e00\u81f4:" + tmpServer);
    }

    @Override
    public ObjectMetadata getFileMetadata(String url) {
        OSSClient ossClient = this.getClient();
        url = url.indexOf("/") == 0 ? url.substring(1) : url;
        boolean condition = url.contains("https://") || url.contains("http://");
        String tmpServer = !condition ? null : url.replace("https://", "").replace("http://", "").replace("//", "/").split("/")[0];
        String key = url.replace(this.server, "").replace("//", "/");
        if (tmpServer == null || this.server.contains(tmpServer)) {
            ObjectMetadata objMeta = ossClient.getObjectMetadata(GlobalResources.OSS_BUCKETNAME, key);
            return objMeta;
        }
        throw new OSSException("\u4f20\u5165\u7684URL\u5730\u5740\u4e0e\u5f53\u524d\u670d\u52a1\u5668\u5730\u5740\u6216bucketName\u4e0d\u4e00\u81f4:" + tmpServer);
    }

    @Override
    public String getBucketUrl() {
        return GlobalResources.OSS_BUCKETNAME + "." + GlobalResources.OSS_SERVERADDRESSS;
    }

    @Override
    public void copy(String srcPath, String desPath) {
        this.getClient().copyObject(GlobalResources.OSS_BUCKETNAME, this.getKey(srcPath), GlobalResources.OSS_BUCKETNAME, this.getKey(desPath));
    }

    @Override
    public void copy(String srcPath, String desPath, ObjectMetadata newMeta) {
        OSSClient ossClient = this.getClient();
        CopyObjectRequest obj = new CopyObjectRequest(GlobalResources.OSS_BUCKETNAME, this.getKey(srcPath), GlobalResources.OSS_BUCKETNAME, this.getKey(desPath));
        obj.setNewObjectMetadata(newMeta);
        ossClient.copyObject(obj);
    }

    @Override
    public void upMeta(String url, ObjectMetadata meta) {
        this.copy(url, url, meta);
    }

    private String formatUrl(String url) {
        return this.PROTOCOL_STRING + url.replace(this.PROTOCOL_STRING, "").replace("http://", "").replace("//", "/");
    }

    private String getKey(String url) {
        url = url.indexOf("/") == 0 ? url.substring(1) : url;
        String key = url.replace(this.server, "").replace("//", "/");
        return key;
    }
}

