/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.dto.oauth;

import com.bcxin.ins.vo.ClientUserVo;
import java.io.Serializable;
import java.util.Date;

public class AccessToken
implements Serializable {
    private static final long serialVersionUID = -3065517831372557033L;
    public static final String BEARER_TYPE = "Bearer";
    public static final int REFRESH_TOKEN_VALIDITY_SECONDS = 7200;
    public static final int ACCESS_TOKEN_WEB_VALIDITY_SECONDS = 86400;
    public static final int ACCESS_TOKEN_MOBILE_VALIDITY_SECONDS = 2592000;
    public static final int REFRESH_TOKEN_SECONDS = 600;
    protected static long THOUSAND = 1000L;
    private String tokenId;
    private String loginName;
    private String userId;
    private String name;
    private String refreshToken;
    private String webId;
    private String webType;
    private String tokenType = "Bearer";
    private ClientUserVo userVo;
    private int tokenExpiredSeconds;
    protected Date createTime = new Date();

    public boolean tokenExpired() {
        long time = this.createTime.getTime() + (long)this.tokenExpiredSeconds * THOUSAND;
        return time < System.currentTimeMillis();
    }

    public long currentTokenExpiredSeconds() {
        if (this.tokenExpired()) {
            return -1L;
        }
        long time = this.createTime.getTime() + (long)this.tokenExpiredSeconds * THOUSAND;
        return (time - System.currentTimeMillis()) / THOUSAND;
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getName() {
        return this.name;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getWebId() {
        return this.webId;
    }

    public String getWebType() {
        return this.webType;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public ClientUserVo getUserVo() {
        return this.userVo;
    }

    public int getTokenExpiredSeconds() {
        return this.tokenExpiredSeconds;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setWebId(String webId) {
        this.webId = webId;
    }

    public void setWebType(String webType) {
        this.webType = webType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public void setUserVo(ClientUserVo userVo) {
        this.userVo = userVo;
    }

    public void setTokenExpiredSeconds(int tokenExpiredSeconds) {
        this.tokenExpiredSeconds = tokenExpiredSeconds;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccessToken)) {
            return false;
        }
        AccessToken other = (AccessToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tokenId = this.getTokenId();
        String other$tokenId = other.getTokenId();
        if (this$tokenId == null ? other$tokenId != null : !this$tokenId.equals(other$tokenId)) {
            return false;
        }
        String this$loginName = this.getLoginName();
        String other$loginName = other.getLoginName();
        if (this$loginName == null ? other$loginName != null : !this$loginName.equals(other$loginName)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$refreshToken = this.getRefreshToken();
        String other$refreshToken = other.getRefreshToken();
        if (this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken)) {
            return false;
        }
        String this$webId = this.getWebId();
        String other$webId = other.getWebId();
        if (this$webId == null ? other$webId != null : !this$webId.equals(other$webId)) {
            return false;
        }
        String this$webType = this.getWebType();
        String other$webType = other.getWebType();
        if (this$webType == null ? other$webType != null : !this$webType.equals(other$webType)) {
            return false;
        }
        String this$tokenType = this.getTokenType();
        String other$tokenType = other.getTokenType();
        if (this$tokenType == null ? other$tokenType != null : !this$tokenType.equals(other$tokenType)) {
            return false;
        }
        ClientUserVo this$userVo = this.getUserVo();
        ClientUserVo other$userVo = other.getUserVo();
        if (this$userVo == null ? other$userVo != null : !this$userVo.equals(other$userVo)) {
            return false;
        }
        if (this.getTokenExpiredSeconds() != other.getTokenExpiredSeconds()) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        return !(this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccessToken;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tokenId = this.getTokenId();
        result = result * 59 + ($tokenId == null ? 43 : $tokenId.hashCode());
        String $loginName = this.getLoginName();
        result = result * 59 + ($loginName == null ? 43 : $loginName.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $refreshToken = this.getRefreshToken();
        result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
        String $webId = this.getWebId();
        result = result * 59 + ($webId == null ? 43 : $webId.hashCode());
        String $webType = this.getWebType();
        result = result * 59 + ($webType == null ? 43 : $webType.hashCode());
        String $tokenType = this.getTokenType();
        result = result * 59 + ($tokenType == null ? 43 : $tokenType.hashCode());
        ClientUserVo $userVo = this.getUserVo();
        result = result * 59 + ($userVo == null ? 43 : $userVo.hashCode());
        result = result * 59 + this.getTokenExpiredSeconds();
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        return result;
    }

    public String toString() {
        return "AccessToken(tokenId=" + this.getTokenId() + ", loginName=" + this.getLoginName() + ", userId=" + this.getUserId() + ", name=" + this.getName() + ", refreshToken=" + this.getRefreshToken() + ", webId=" + this.getWebId() + ", webType=" + this.getWebType() + ", tokenType=" + this.getTokenType() + ", userVo=" + this.getUserVo() + ", tokenExpiredSeconds=" + this.getTokenExpiredSeconds() + ", createTime=" + this.getCreateTime() + ")";
    }
}

