package com.bcxin.ins.vo.report_pac;

import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.entity.policy_report.InsCommonReport;
import com.bcxin.mybatisplus.annotations.TableField;
import com.bcxin.mybatisplus.annotations.TableId;
import com.bcxin.mybatisplus.annotations.TableName;
import com.bcxin.mybatisplus.enums.IdType;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Date;

/**
 * <b> 报案成功案件信息 </b>
 * @author ZXF
 * @create 2019/11/11 0011 11:06
 * @version
 * @注意事项 </b>
 */
public class InsCaseInfoVo {

    private String ins_case_info_id;

    /*
    * 基础报案信息表Id
    * */
    private String ins_common_report_id;

    private String audit_status;	//是否理赔状态【1理赔，0不理赔】

    private String claim_no;//运单号

    private String case_no;//赔案号

    private String case_times;	//赔付次数

    private String case_status;	//案件状态（0-已结案 1-已报案  2-已理算  6-已归档）

    private String case_status_1;	//案件状态【“查勘中”、“定责中”、“定损中”、“核赔前置中”、“理算中”、“审核中”、“支付退回中”、“待归档”、“已归档”】

    private String case_status_2;	//案件状态【审核中、案件已完结、赔款已到账】

    private String claim_phone;	//理赔人电话

    private String claim_name;	//理赔人名字

    private String end_case_amount_sum;	//结案赔款金额

    private String end_case_date;	//结案时间

    private String order_no;	//运单号

    private String indemnity_conclusion;	//赔付结论

    private String withdraw_reason;	//赔付说明

    private String reject_notice_date;	//拒赔时间

    private String reject_notice_url;	//拒赔通知书链接[有时效性，10-15分钟]

    /**
     * <b> 判断实体中所有属性值是否为空 </b>
     * @author ZXF
     * @create 2018/06/01 0001 9:56
     * @version
     * @注意事项 </b>
     */
    public boolean isNull() throws IllegalAccessException {
        boolean flag = true;
        for (Field f : this.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            //判断字段是否为空，并且对象属性中的基本都会转为对象类型来判断
            if (f.get(this) != null) {
                flag = false;
                break;
            }
        }
        return flag;
    }

    public String getIns_case_info_id() {
        return ins_case_info_id;
    }

    public void setIns_case_info_id(String ins_case_info_id) {
        this.ins_case_info_id = ins_case_info_id;
    }

    public String getIns_common_report_id() {
        return ins_common_report_id;
    }

    public void setIns_common_report_id(String ins_common_report_id) {
        this.ins_common_report_id = ins_common_report_id;
    }

    public String getAudit_status() {
        return audit_status;
    }

    public void setAudit_status(String audit_status) {
        this.audit_status = audit_status;
    }

    public String getClaim_no() {
        return claim_no;
    }

    public void setClaim_no(String claim_no) {
        this.claim_no = claim_no;
    }

    public String getCase_no() {
        return case_no;
    }

    public void setCase_no(String case_no) {
        this.case_no = case_no;
    }

    public String getCase_times() {
        return case_times;
    }

    public void setCase_times(String case_times) {
        this.case_times = case_times;
    }

    public String getCase_status() {
        return case_status;
    }

    public void setCase_status(String case_status) {
        this.case_status = case_status;
    }

    public String getCase_status_1() {
        return case_status_1;
    }

    public void setCase_status_1(String case_status_1) {
        this.case_status_1 = case_status_1;
    }

    public String getCase_status_2() {
        return case_status_2;
    }

    public void setCase_status_2(String case_status_2) {
        this.case_status_2 = case_status_2;
    }

    public String getClaim_phone() {
        return claim_phone;
    }

    public void setClaim_phone(String claim_phone) {
        this.claim_phone = claim_phone;
    }

    public String getClaim_name() {
        return claim_name;
    }

    public void setClaim_name(String claim_name) {
        this.claim_name = claim_name;
    }

    public String getEnd_case_amount_sum() {
        return end_case_amount_sum;
    }

    public void setEnd_case_amount_sum(String end_case_amount_sum) {
        this.end_case_amount_sum = end_case_amount_sum;
    }

    public String getEnd_case_date() {
        return end_case_date;
    }

    public void setEnd_case_date(String end_case_date) {
        this.end_case_date = end_case_date;
    }

    public String getOrder_no() {
        return order_no;
    }

    public void setOrder_no(String order_no) {
        this.order_no = order_no;
    }

    public String getIndemnity_conclusion() {
        return indemnity_conclusion;
    }

    public void setIndemnity_conclusion(String indemnity_conclusion) {
        this.indemnity_conclusion = indemnity_conclusion;
    }

    public String getWithdraw_reason() {
        return withdraw_reason;
    }

    public void setWithdraw_reason(String withdraw_reason) {
        this.withdraw_reason = withdraw_reason;
    }

    public String getReject_notice_date() {
        return reject_notice_date;
    }

    public void setReject_notice_date(String reject_notice_date) {
        this.reject_notice_date = reject_notice_date;
    }

    public String getReject_notice_url() {
        return reject_notice_url;
    }

    public void setReject_notice_url(String reject_notice_url) {
        this.reject_notice_url = reject_notice_url;
    }
}