package com.bcxin.ins.vo.excel;

import com.bcxin.ins.util.excel.ExcelVOAttribute;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

public class ResultSetExcelVo implements Serializable {


	@ExcelVOAttribute(name = "姓名", column = "A", isExport = true, isRequest = true)
	private String name;

	@ExcelVOAttribute(name = "身份证", column = "B", isExport = true, isRequest = true)
	private String id_card;

	@ExcelVOAttribute(name = "手机号码", column = "C", isExport = true, isRequest = true)
	private String tel;

	@ExcelVOAttribute(name = "出生日期", column = "D", isExport = true, isRequest = true)
	private String birthday;

	@ExcelVOAttribute(name = "性别", column = "E", isExport = true, isRequest = true)
	private String sex;

	@ExcelVOAttribute(name = "职业", column = "F", isExport = true, isRequest = true)
	private String career;

	@ExcelVOAttribute(name = "类型", column = "G", isExport = true, isRequest = false)
	private String revise_type;

	/**
	 * 导入的错误信息
	 */
	private String errorMsg;

	public ResultSetExcelVo(){}

	public ResultSetExcelVo(String name
			, String id_card
			, String tel
			, String birthday
			, String sex
			, String career
			, String revise_type){
		this.name = name;
		this.id_card = id_card;
		this.tel = tel;
		this.birthday = birthday;
		this.sex = sex;
		this.career = career;
		this.revise_type = revise_type;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getId_card() {
		return id_card;
	}

	public void setId_card(String id_card) {
		this.id_card = id_card;
	}

	public String getTel() {
		return tel;
	}

	public void setTel(String tel) {
		this.tel = tel;
	}

	public String getBirthday() {
		return birthday;
	}

	public void setBirthday(String birthday) {
		this.birthday = birthday;
	}

	public String getSex() {
		return sex;
	}

	public void setSex(String sex) {
		this.sex = sex;
	}

	public String getCareer() {
		return career;
	}

	public void setCareer(String career) {
		this.career = career;
	}

	public String getRevise_type() {
		return revise_type;
	}

	public void setRevise_type(String revise_type) {
		this.revise_type = revise_type;
	}

	public String getErrorMsg() {
		if (StringUtils.isNotEmpty(errorMsg)) {
			return errorMsg;
		} else {
			return "";
		}
	}

	public void setErrorMsg(String errorMsg) {
		this.errorMsg = errorMsg;
	}
}
