package com.bcxin.ins.vo.excel;

import com.bcxin.ins.util.excel.ExcelVOAttribute;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

public class RecordExcelVo implements Serializable {

	@ExcelVOAttribute(name = "保单号", column = "A", isExport = true, isRequest = true)
	private String external_reference;

	@ExcelVOAttribute(name = "姓名", column = "B", isExport = true, isRequest = true)
	private String name;

	@ExcelVOAttribute(name = "身份证", column = "C", isExport = true, isRequest = true)
	private String id_card;

	@ExcelVOAttribute(name = "保全类型", column = "D", isExport = true, isRequest = true)
	private String revise_type;

	@ExcelVOAttribute(name = "保全生效日期", column = "E", isExport = true, isRequest = true)
	private String inception_date;

	@ExcelVOAttribute(name = "失效日期", column = "F", isExport = true, isRequest = true)
	private String planned_date;

	@ExcelVOAttribute(name = "保全天数", column = "G", isExport = true, isRequest = true)
	private String lastDay;

	@ExcelVOAttribute(name = "原始保费", column = "H", isExport = true, isRequest = true)
	private String premium;

	@ExcelVOAttribute(name = "手机号码", column = "I", isExport = true, isRequest = true)
	private String tel;

	@ExcelVOAttribute(name = "投保人名称", column = "J", isExport = true, isRequest = true)
	private String com_name;

	/**
	 * 替减数据（替换时被替换的那个人）
	 */
	private String tjData;

	/**
	 * 导入的错误信息
	 */
	private String errorMsg;

	public RecordExcelVo(){}

	public RecordExcelVo(String external_reference
			, String com_name
			, String name
			, String id_card
			, String tel
			, String revise_type
			, String inception_date, String planned_date, String lastDay, String premium, String tjData){
		this.external_reference = external_reference;
		this.name = name;
		this.id_card = id_card;
		this.tel = tel;
		this.revise_type = revise_type;
		this.inception_date = inception_date;
		this.com_name = com_name;
		this.planned_date = planned_date;
		this.lastDay = lastDay;
		this.tjData = tjData;
		this.premium = premium;
	}

	public String getExternal_reference() {
		return external_reference;
	}

	public void setExternal_reference(String external_reference) {
		this.external_reference = external_reference;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getId_card() {
		return id_card;
	}

	public void setId_card(String id_card) {
		this.id_card = id_card;
	}

	public String getTel() {
		return tel;
	}

	public void setTel(String tel) {
		this.tel = tel;
	}

	public String getRevise_type() {
		return revise_type;
	}

	public void setRevise_type(String revise_type) {
		this.revise_type = revise_type;
	}

	public String getInception_date() {
		return inception_date;
	}

	public void setInception_date(String inception_date) {
		this.inception_date = inception_date;
	}

	public String getCom_name() {
		return com_name;
	}

	public void setCom_name(String com_name) {
		this.com_name = com_name;
	}

	public String getPlanned_date() {
		return planned_date;
	}

	public void setPlanned_date(String planned_date) {
		this.planned_date = planned_date;
	}

	public String getLastDay() {
		return lastDay;
	}

	public void setLastDay(String lastDay) {
		this.lastDay = lastDay;
	}

	public String getPremium() {
		return premium;
	}

	public void setPremium(String premium) {
		this.premium = premium;
	}

	public String getTjData() {
		return tjData;
	}

	public void setTjData(String tjData) {
		this.tjData = tjData;
	}

	public String getErrorMsg() {
		if (StringUtils.isNotEmpty(errorMsg)) {
			return errorMsg;
		} else {
			return "";
		}
	}

	public void setErrorMsg(String errorMsg) {
		this.errorMsg = errorMsg;
	}
}
