package com.bcxin.ins.vo;

import lombok.Data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 信用险-出运表<br>
 * @author liumd
 * @date 2016年12月30日
 */
@Data
public class ShipDeclareVo extends DataEntityVo {

	/** 订单信息表 */
	private Long ins_order_form_id;
	
	/** 保单买家限额表，可以获取到买家及保单*/
	public Long ins_top_buyers_id;

	/** 被保险人 */
	private String insured;

	/** 投保金额 */
	private BigDecimal coverage;

	/** 出运日期 */
	private Date delivery_time;
	
	/** 付款到期日*/
	private Date pay_expire_time;

	/** 商品名称 */
	private String trade_name;

	/** 海关商品代码 */
	private String ship_trade_no;

	/** 海关商品名称 */
	private String ship_trade_name;

	/** 数量/包装 */
	private String pack_num;

	/** 数量/包装占比 */
	private String ratio;

	/** 开证银行Swift */
	private String issuing_swift;//issuingSwift

	/** 合同账期 */
	private String contract_days;

	/** 报关单号 */
	private String declaration_no;

	/** 申报类型 */
	private String declare_type;
	
	/**通过计算当前时间和出运日期  提供给页面使用
	 * 小于   展示为  修改 ：0
	 * 当前时间大于出运时间  展示为  详情  值为：1
	 */
	private String view_type;
	
	/** 运输方式 */
	private String transport_type;
	
	/** 结算方式 */
	private String payment_terms;
	
	//-------------为了方便取用和日后扩展一个出运多个发票的业务，所以把发票合并进来-----------------//
	/** 发票ID*/
	private Long invoice_id;
	
	/** 发票号 */
	private String invoice_no;
	
	/** 发票金额 */
	private BigDecimal invoice_amounts;
	
	//-------------买家相关-----------------//
	
	/** 买家所属公司 */
	private String company;
	
	/** 买家所属国家*/
	private String country;
	
	//-------------被保险人下拉列表-----------------//
	
	private List<String> insuredNameList;

	/**
	 * 产品保障责任
	 */
	private List<ResponsibilityVo> responsibilityVoList = new ArrayList<ResponsibilityVo>();
}
