package com.bcxin.ins.vo;

import lombok.Data;

import java.util.List;

/**
 * 保全缴费表
 */
@Data
public class InsPreservationPayVo extends BaseVo{

    /**
     * id
     */
    private String oid;

    /**
     * 订单id
     */
    private String ins_insurance_slip_id;

    /**
     * 付款状态0.待处理；1.待支付；2.待审核；3.已支付；4.暂存
     */
    private String pay_status;

    /**
     * 保单号
     */
    private String external_reference;

    /**
     * 生效日期
     */
    private String inception_date;

    /**
     * 失效日期
     */
    private String planned_end_date;

    /**
     * 投保人名称
     */
    private String app_role_name;

    /**
     * 保险公司id
     */
    private String sys_ins_company_id;

    /**
     * 保险公司名称
     */
    private String company_name;
    /**
     * 保险产品名称
     */
    private String insurance_name;

    /**
     * 结算开始时间
     */
    private String star_pay_time;

    /**
     * 结算终止时间
     */
    private String end_pay_time;
    /**
     * 生成日期
     */
    private String build_data;

    /**
     * 保全单数
     */
    private String record_count;
    /**
     * 增员人数
     */
    private String add_count;

    /**
     * 减员人数
     */
    private String minus_count;

    /**
     * 替换人数
     */
    private String replace_count;

    /**
     * 付款通知书地址
     */
    private String pay_inform_path;

    /**
     * 支付凭证地址
     */
    private String pay_order_path;

    /**
     * 支付类型0：线下支付，1：在线支付
     */
    private String pay_type;

    /**
     * 支付号
     */
    private String pay_order_number;

    /**
     * 支付地址
     */
    private String pay_url;

    /**
     * 是否部分缴费状态 0：否，>0：是
     */
    private int is_part_status;
    /**
     * 是否归属部分账单
     */
    private int is_part;
    /**
     * 是否申请发票
     */
    private int is_fp;
    /**
     * 发票地址
     */
    private String fp_url;

    /**
     * 预期总保费
     */
    private String predict_total_amount;

    /**
     * 实际总保费
     */
    private String fact_total_amount;

    /**
     * 备注
     */
    private String remark;
    /**
     * 批改流水号
     */
    private String revise_serial_number;
    /**
     * 批改类型
     */
    private String revise_type;

    /**
     * 批改状态
     */
    private String revise_status;
    private String product_code;


    private List<InsPreservationRecordVo> insPreservationRecordVoList;//同一保单的保全申请单集合

}