package com.bcxin.ins.util.http;


import com.bcxin.ins.util.MD5Util;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;

public class RequestUtil {

	private static Logger log = LoggerFactory.getLogger(RequestUtil.class);

	public static HttpRequest initHttp() {
		HttpRequest httpRequest = new HttpRequest();
		return httpRequest;
	}


	/**
	 * 向指定URL发送GET方法的请求
	 *
	 * @param url
	 *            发送请求的URL
	 * @param param
	 *            请求参数，请求参数应该是 name1=value1&name2=value2 的形式。
	 * @return URL 所代表远程资源的响应结果
	 */
	public static String sendGet(String url, String param) {
		String result = "";
		BufferedReader in = null;
		try {
			String urlNameString = url;
			if(StringUtils.isNotEmpty(param)){
				urlNameString=url+ "?" + param;
			}
			URL realUrl = new URL(urlNameString);
			// 打开和URL之间的连接
			URLConnection connection = realUrl.openConnection();
			// 设置通用的请求属性
			connection.setRequestProperty("accept", "*/*");
			connection.setRequestProperty("Charset", "UTF-8");
			connection.setRequestProperty("connection", "Keep-Alive");
			connection.setRequestProperty("user-agent",
					"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
			// 建立实际的连接
			connection.connect();
			// 获取所有响应头字段
			Map<String, List<String>> map = connection.getHeaderFields();
			// 遍历所有的响应头字段
			for (String key : map.keySet()) {
				//System.out.println(key + "--->" + map.get(key));
			}
			// 定义 BufferedReader输入流来读取URL的响应
			in = new BufferedReader(new InputStreamReader(
					connection.getInputStream()));
			String line;
			while ((line = in.readLine()) != null) {
				result += line;
			}
		} catch (Exception e) {
//			System.out.println("发送GET请求出现异常！" + e);
			log.error("发送GET请求出现异常！",e);
//			e.printStackTrace();
		}
		// 使用finally块来关闭输入流
		finally {
			try {
				if (in != null) {
					in.close();
				}
			} catch (Exception e2) {
				log.error("发送GET请求异常！",e2);
				//e2.printStackTrace();
			}
		}
		return result;
	}

	/**
	 * 向指定 URL 发送POST方法的请求
	 *
	 * @param url
	 *            发送请求的 URL
	 * @param param
	 *            请求参数，请求参数应该是 name1=value1&name2=value2 的形式。
	 * @return 所代表远程资源的响应结果
	 */
	public static String sendPost(String url, String param) {
		PrintWriter out = null;
		BufferedReader in = null;
		String result = "";
		try {
			URL realUrl = new URL(url);
			// 打开和URL之间的连接
			URLConnection conn = realUrl.openConnection();
			// 设置通用的请求属性
			conn.setRequestProperty("accept", "*/*");
			conn.setRequestProperty("connection", "Keep-Alive");
			conn.setRequestProperty("Charset", "UTF-8");
			conn.setRequestProperty("user-agent",
					"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
			// 发送POST请求必须设置如下两行
			conn.setDoOutput(true);
			conn.setDoInput(true);
			// 获取URLConnection对象对应的输出流
			out = new PrintWriter(conn.getOutputStream());
			// 发送请求参数
			out.print(param);
			// flush输出流的缓冲
			out.flush();
			// 定义BufferedReader输入流来读取URL的响应
			in = new BufferedReader(
					new InputStreamReader(conn.getInputStream()));
			String line;
			while ((line = in.readLine()) != null) {
				result += line;
			}
		} catch (Exception e) {

			log.error("发送POST请求异常！",e);

		}
		//使用finally块来关闭输出流、输入流
		finally{
			try{
				if(out!=null){
					out.close();
				}
				if(in!=null){
					in.close();
				}
			}
			catch(IOException ex){
				log.error("发送POST关闭连接异常",ex);

			}
		}
		return result;
	}


	public static void main(String[] args) {

		dopay();


	}



	public  static void doSpilt(){
//		fenzhangPingAnReconciliationVo{requestId='1494319200158', clientType='P_ABC123', token='9db2557b1361b8efbf78ddb0b145ddc5', accountCheckResult='3', receiptNo='30000070075779069'}
//		String url ="http://120.76.218.179:9097/conins-web/test/testPingAnSplit";
		String  url ="http://192.168.30.29:8082/bcxin-conins/PA-API/pa_reconciliation";
		String requestId="1494319200158";
		String clientType="P_ABC123";
		String token="9db2557b1361b8efbf78ddb0b145ddc5";
		String accountCheckResult="5";
		String receiptNo="30000070075822074";
		String externalReference="GP30002013822070";
		String params="requestId="+requestId+"&clientType="+clientType+"&token="+token+"&accountCheckResult="+accountCheckResult+"&receiptNo="+receiptNo+"&externalReference="+externalReference;
		//发送 GET 请求
		try {
			String s= RequestUtil.sendGet(url, params);
			System.out.println(s);
		}catch (Exception ex){
			log.error("doSpilt",ex);

		}
	}

	public static   void dopay(){
//		bankTradeNo=4007192001201705232156291620&tranCode=200103&rcptno=pt00002&bankTranDa te=2017-05-23&bankTranTime=08:50:19&bankNo=99033222&bankTranChnl=NBU&status=pay_success&requestId=14 95504478952&token=d2940b24138df69a90c791ba4170d4cb&clientType=P_ABC123
//		String  url ="http://192.168.30.29:8082/bcxin-conins/PA-API/callbackPay";
		String  url ="http://120.76.218.179:9097/conins-web/PA-API/callbackPay";
		String requestId="1495504478952";
		String clientType="P_ABC123";
		String token="ba212b429da5e093511c2fa3a4e688b7";
		String bankTradeNo="4007192001201705232156291620";
		String tranCode="200103";
		String rcptno="pt00002";
		String bankTranDate="2017-05-23";
		String bankTranTime="08:50:19";
		String bankNo="99033222";
		String bankTranChnl="NBU";
		//d2940b24138df69a90c791ba4170d4cb
		//md5加密32位md5（requestId+clientType+"pingan"）
		System.out.println(requestId+clientType+"pingan");
		System.out.println(MD5Util.string2MD5(requestId+clientType+"pingan"));
//		String params="requestId="+requestId+"&clientType="+clientType+"&token="+token+"&bankTradeNo="+bankTradeNo+"&tranCode="+tranCode+"&rcptno="+rcptno+"&bankTranDate="+bankTranDate+"&bankTranTime="+bankTranTime+"&bankNo="+bankNo+"&bankTranChnl="+bankTranChnl;
//
//		//发送 GET 请求
//		try {
//			String s= RequestUtil.sendGet(url, params);
//			System.out.println(s);
//		}catch (Exception ex){
//			ex.printStackTrace();
//		}
	}
}
