package com.bcxin.ins.util.enums;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zxf
 **/
public enum OfficeType {
	LY("1", "楼宇", "OT")
	,GCQYJS("2", "工程企业建设", "OT")
	,GXGC("3", "管线工程", "OT")
	,LJJG("4", "陆上交通建设工程", "OT")
	,SSGC("5", "涉水工程", "OT")
	,QTGC("6", "其他工程", "OT")
	,SZGC("7", "市政工程", "OT")
	,SZGYGC("0001", "市政公用工程", "DB")
	,FWJZGC("0002", "房屋建筑工程", "DB")
	,GLGC("0003", "公路工程", "DB")
	,TLGC("0004", "铁路工程", "DB")
	,GHGC("0005", "港口与航道工程", "DB")
	,SDGC("0006", "水利水电工程", "DB")
	,DLGC("0007", "电力工程", "DB")
	,KSGC("0008", "矿山工程", "DB")
	,ZLGC("0009", "冶炼工程", "DB")
	,HGGC("0010", "化工石油工程", "DB")
	,TXGC("0011", "通信工程", "DB")
	,JDGC("0012", "机电安装工程", "DB");

	private String value;
	private String name;
	private String belong;

	private OfficeType(String value, String name, String belong){
		this.value = value;
		this.name = name;
		this.belong = belong;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getBelong() {
		return belong;
	}

	public void setBelong(String belong) {
		this.belong = belong;
	}

	public static OfficeType convert_value(String value){
		if ("1".equals(value)) {
			return OfficeType.LY;
		}else if ("2".equals(value)) {
			return OfficeType.GCQYJS;
		}else if ("3".equals(value)) {
			return OfficeType.GXGC;
		}else if ("4".equals(value)) {
			return OfficeType.LJJG;
		}else if ("5".equals(value)) {
			return OfficeType.SSGC;
		}else if ("6".equals(value)) {
			return OfficeType.QTGC;
		}else if ("7".equals(value)) {
			return OfficeType.SZGC;
		}else if ("0001".equals(value)) {
			return OfficeType.SZGYGC;
		}else if ("0002".equals(value)) {
			return OfficeType.FWJZGC;
		}else if ("0003".equals(value)) {
			return OfficeType.GLGC;
		}else if ("0004".equals(value)) {
			return OfficeType.TLGC;
		}else if ("0005".equals(value)) {
			return OfficeType.GHGC;
		}else if ("0006".equals(value)) {
			return OfficeType.SDGC;
		}else if ("0007".equals(value)) {
			return OfficeType.DLGC;
		}else if ("0008".equals(value)) {
			return OfficeType.KSGC;
		}else if ("0009".equals(value)) {
			return OfficeType.ZLGC;
		}else if ("0010".equals(value)) {
			return OfficeType.HGGC;
		}else if ("0011".equals(value)) {
			return OfficeType.TXGC;
		}else if ("0012".equals(value)) {
			return OfficeType.JDGC;
		}
		return null;
	}

	public static List<OfficeType> listT(String type){
		List<OfficeType> list = new ArrayList<OfficeType>();
		for(OfficeType ot : OfficeType.values()){
			if(ot.getBelong().equals(type)){
				list.add(ot);
			}
		}
		return list;
	}

}
