package com.bcxin.ins.util.enums;

import java.util.ArrayList;
import java.util.List;

/**
 * @author LeeJungHyun
 **/
public enum IdType {
	IDCARD {
		public String getValue(){return "0";}
		public String getName(){return "身份证";}
	},ORGANIZINGCARD {
		public String getValue(){return "1";}
		public String getName(){return "组织机构代码证";}
	},CREDITCODE {
		public String getValue(){return "2";}
		public String getName(){return "三证合一统一信用代码";}
	},PASSPORT {
		public String getValue(){return "3";}
		public String getName(){return "护照";}
	},HVPSANDMTP {
		public String getValue(){return "4";}
		public String getName(){return "台胞证";}
	},HOMECARD {
		public String getValue(){return "5";}
		public String getName(){return "回乡证";}
	},TAXCODE {
		public String getValue(){return "6";}
		public String getName(){return "税务登记证";}
	},BUSINESSCODE {
		public String getValue(){return "7";}
		public String getName(){return "营业执照";}
	},OTHER {
		public String getValue(){return "8";}
		public String getName(){return "其他";}
	},POLICECARD {
		public String getValue(){return "9";}
		public String getName(){return "军官证";}
	};
	
	 public abstract String getValue();
	 public abstract String getName();
	 
	 public static IdType convert(String name){
	    	if ( "IDCARD".equals(name) ) {
	    		return IdType.IDCARD;
	    	} else if ("ORGANIZINGCARD".equals(name)) {
	    		return IdType.ORGANIZINGCARD;
	    	}else if ("CREDITCODE".equals(name)) {
				return IdType.CREDITCODE;
			}else if ("PASSPORT".equals(name)) {
				return IdType.PASSPORT;
			}else if ("HVPSANDMTP".equals(name)) {
				return IdType.HVPSANDMTP;
			}else if ("HOMECARD".equals(name)) {
				return IdType.HOMECARD;
			}else if ("TAXCODE".equals(name)) {
				return IdType.TAXCODE;
			}else if ("BUSINESSCODE".equals(name)) {
				return IdType.BUSINESSCODE;
			}else if ("OTHER".equals(name)) {
				return IdType.OTHER;
			}
	    	return IdType.OTHER;
	    }


	public static IdType convert_value(String value){
		if ( "0".equals(value) ) {
			return IdType.IDCARD;
		} else if ("1".equals(value)) {
			return IdType.ORGANIZINGCARD;
		}else if ("2".equals(value)) {
			return IdType.CREDITCODE;
		}else if ("3".equals(value)) {
			return IdType.PASSPORT;
		}else if ("4".equals(value)) {
			return IdType.HVPSANDMTP;
		}else if ("5".equals(value)) {
			return IdType.HOMECARD;
		}else if ("6".equals(value)) {
			return IdType.TAXCODE;
		}else if ("7".equals(value)) {
			return IdType.BUSINESSCODE;
		}
		return IdType.OTHER;
	}

	 /**
	  * 保众网类型转换
	  * @param idType
	  * @return
	  */
	 public static String convert_bzw(IdType idType){
		String return_code = "";
		switch (idType) {
		case IDCARD:
			return_code = "0";
			break;
		case ORGANIZINGCARD:
			return_code = "1";
			break;
		case OTHER:
			return_code = "8";
			break;
		default:
			break;
		}
		 return return_code;
	 }

	/**
	 * 个人证件类型
	 * @return
	 */
	public static List<IdType> personList(){
		List<IdType> list = new ArrayList<IdType>();
		list.add(IDCARD);
		list.add(PASSPORT);
		list.add(HVPSANDMTP);
		list.add(HOMECARD);
		return list;
	}

	/**
	 * 企业证件类型
	 * @return
	 */
	public static List<IdType> comList(){
		List<IdType> list = new ArrayList<IdType>();
		list.add(ORGANIZINGCARD);
		list.add(TAXCODE);
		list.add(BUSINESSCODE);
		list.add(CREDITCODE);
		return list;
	}

	public static List<IdType> doList(){
		List<IdType> list = new ArrayList<IdType>();
		list.add(IDCARD);
		list.add(ORGANIZINGCARD);
		list.add(CREDITCODE);
		list.add(PASSPORT);
		list.add(HVPSANDMTP);
		list.add(HOMECARD);
		list.add(TAXCODE);
		list.add(BUSINESSCODE);
		return list;
	}

	public static String typeConversion_TK(String value){
		if("0".equals(value)){
			return "01";
		}else if("3".equals(value)){
			return "02";
		}else if("4".equals(value)){
			return "05";
		}else if("1".equals(value)){
			return "1";
		}else if("6".equals(value)){
			return "2";
		}else if("7".equals(value)){
			return "3";
		}else if("2".equals(value)){
			return "4";
		}else if("8".equals(value)){
			return "99";
		}
		return "99";
	}


	/**
	 * 企业完善资料列表 --联系人证件类型
	 * @return
	 */
	public static List<IdType> companyList(){
		List<IdType> list = new ArrayList<IdType>();
		list.add(IDCARD);
		list.add(POLICECARD);
		list.add(PASSPORT);
		list.add(HOMECARD);
		list.add(HVPSANDMTP);

		return list;
	}

	/**
	 * 企业完善资料列表 --组织机构代码
	 * @return
	 */
	public static List<IdType> companyCodeList(){
		List<IdType> list = new ArrayList<IdType>();
		list.add(ORGANIZINGCARD);
		list.add(CREDITCODE);
		list.add(BUSINESSCODE);
		return list;
	}
}
