package com.bcxin.ins.util.email;


import com.bcxin.ins.util.toolbox.StrUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.*;
import javax.mail.internet.*;
import javax.mail.internet.MimeMessage.RecipientType;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.Security;
import java.util.*;


public class SEAMUtil {


    private volatile static SEAMUtil sendEmailAndMsgUtil;

    /**
     * 单列模式
     * @return
     */
    public static SEAMUtil getSendEmailAndMsgUtil() {
        if (sendEmailAndMsgUtil == null) {
            synchronized (SEAMUtil.class) {
                if (sendEmailAndMsgUtil == null) {
                    sendEmailAndMsgUtil = new SEAMUtil();
                }
            }
        }
        return sendEmailAndMsgUtil;
    }

    private SEAMUtil(){

    }

    private final static String CHARSET = "utf-8";

    private static String host;// 发送方邮箱所在的smtp主机
    private static String from;// 发送方邮箱
    private static String bcc;// 密送方邮箱
    private static String emailPassword;// 密码
    private static String bcxHead;
    private static String bcxFooter;

    private static Session session;
    private static String gasPolicy_path = ""; //燃气保险电子保单存放地址

    private static String sender_username = "";
    private static Transport transport;

    private static MimeMessage message;

    public String typeName;

    final static Logger logger = LoggerFactory.getLogger(SEAMUtil.class);

    static {
        ResourceBundle rb = ResourceBundle.getBundle("properties/config");
        host = rb.getString("mail_host");
        from = rb.getString("mail_from");
        bcc = rb.getString("mail_bcc");
        emailPassword = rb.getString("mail_password");
        bcxHead = rb.getString("mail_bcxHead");
        bcxFooter = rb.getString("mail_bcxFooter");


        Properties props = new Properties();
        props.put("mail.smtp.host", host);// 设置smtp主机
        props.put("mail.smtp.auth", "true");// 使用smtp身份验证
        session = Session.getInstance(props, null);
        message = new MimeMessage(session);
        sender_username = from;


    }

    public static void sendEmail(EmailModel emailModel) {
        if (emailModel.getTo() == null || emailModel.getTo().size() < 1) {
            return;
        }
        System.out.println("进入发送邮件方法=============");
        try {
            String typeName = "";
            String content = "";
            if(StrUtil.isNotBlank(emailModel.getEmailType())) {
                // 发送方名称
                typeName = new SEAMUtil().getTypeName();
                content = bcxHead + "" + emailModel.getContent() + "" + bcxFooter;
            }else{
                content=emailModel.getContent();
            }

            Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());

            final String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";

            // Get a Properties object

            Properties props = System.getProperties();

            props.setProperty("mail.smtp.host", host);

            props.setProperty("mail.smtp.socketFactory.class", SSL_FACTORY);

            props.setProperty("mail.smtp.socketFactory.fallback", "false");

            props.setProperty("mail.smtp.port", "465");

            props.setProperty("mail.smtp.socketFactory.port", "465");

            props.put("mail.smtp.auth", "true");

            final String username = from;

            final String password = emailPassword;

            Session session = Session.getInstance(props, new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {

                    return new PasswordAuthentication(username, password);

                }});
            System.out.println("进入发送邮件方法,获取session");
            // -- Create a new message --
            Message msg = new MimeMessage(session);

            // -- Set the FROM and TO fields --

            msg.setFrom(new InternetAddress(username));

            List list = new ArrayList();//不能使用string类型的类型，这样只能发送一个收件人
            for(String recipient : emailModel.getTo()) {
                list.add(new InternetAddress(recipient));
            }
            InternetAddress[] address =(InternetAddress[])list.toArray(new InternetAddress[list.size()]);
            msg.setRecipients(Message.RecipientType.TO,address);

            msg.setSubject(emailModel.getSubject());
            System.out.println("进入发送邮件方法,加装配置");
            //msg.setText(content);
            // 向multipart对象中添加邮件的各个部分内容，包括文本内容和附件
            Multipart multipart = new MimeMultipart();

            // 添加邮件正文
            BodyPart contentPart = new MimeBodyPart();
            contentPart.setContent(content, "text/html;charset=UTF-8");
            multipart.addBodyPart(contentPart);
            msg.setContent(multipart);
            msg.setSentDate(new Date());
            Transport.send(msg); //需要10秒，可能是邮件服务器的原因
            System.out.println("进入发送邮件方法,加装内容");
            logger.info(host+from+emailPassword);
            logger.info("email-send"+content.toString());

        } catch (Exception e) {
            logger.error("邮件异常",e);

        }

    }

    public  static void sendPDFEmail(EmailModel emailModel, String proContNo) {
        if (emailModel.getTo() == null || emailModel.getTo().size() < 1) {
            return;
        }

        try {
            String typeName = "";
            String content = "";
            if(StrUtil.isNotBlank(emailModel.getEmailType())) {
                typeName = "百川信";// 发送方名称
                content = bcxHead + "" + emailModel.getContent() + "" + bcxFooter;
            }
            Properties props = new Properties();
            // Setup mail server
            props.put("mail.smtp.host", host);// 设置smtp主机
            props.put("mail.smtp.auth", "true");// 使用smtp身份验证
            // Get session
            Session session = Session.getInstance(props, null);
            // Define message
            MimeMessage message = new MimeMessage(session);
            message.setFrom(new InternetAddress(from, typeName));
            message.setSubject(emailModel.getSubject());
            Multipart multipart = new MimeMultipart();
            BodyPart bodyPart = new MimeBodyPart();

            bodyPart.setContent(content, "text/html;charset=UTF-8");
            multipart.addBodyPart(bodyPart);

            //加入附件
            if (proContNo != null) {

                pushPart(proContNo, multipart);

            }

            for(String filePath : emailModel.getFilePath()) {
                FileDataSource fds = new FileDataSource(filePath);
                BodyPart attachBodyPart = new MimeBodyPart();
                attachBodyPart.setDataHandler(new DataHandler(fds));

                attachBodyPart.setFileName(MimeUtility.encodeWord(fds.getName()));
                multipart.addBodyPart(attachBodyPart);
            }

            for(String recipient : emailModel.getTo()) {
                message.addRecipient(Message.RecipientType.TO, new InternetAddress(recipient));
            }
            message.setRecipient(RecipientType.BCC, new InternetAddress(bcc, typeName));

            message.setContent(multipart);
            message.saveChanges();
            Transport transport = session.getTransport("smtp");
            transport.connect(host, from, emailPassword);
            transport.sendMessage(message, message.getAllRecipients());

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * <b> 加入附件 </b>
     * @author ZXF
     * @create 2020/09/28 0028 14:22
     * @version
     * @注意事项 </b>
     */
    private static void pushPart(String proContNo, Multipart multipart) throws MessagingException, UnsupportedEncodingException {
        File file = new File(gasPolicy_path, proContNo+".pdf");
        if(file.exists()){
            BodyPart bodyPart = new MimeBodyPart();
            DataSource datasource = new FileDataSource(file);
            bodyPart.setDataHandler(new DataHandler(datasource));
            bodyPart.setFileName(MimeUtility.encodeWord(proContNo + ".pdf","utf-8", null));
            multipart.addBodyPart(bodyPart);
        }else{
            String err = "投保单号："+proContNo + ("路径："+file.getAbsolutePath());
            logger.error("文件不存在，" + err);
        }
    }

    public String getTypeName() {
        if(StrUtil.isBlank(typeName)){
            typeName="百联宝";
        }
        return typeName;
    }

    /**
     * 发送邮件
     *
     * @param subject
     *            邮件主题
     * @param sendHtml
     *            邮件内容
     * @param receiveUser
     *            收件人地址
     */
    public void sendEmail(String subject, String sendHtml, String receiveUser) {
        try {
            // 发件人
            InternetAddress from = new InternetAddress(sender_username);
            message.setFrom(from);

            if ( StrUtil.isBlank(receiveUser) ) {
                return;
            }
            // 收件人
            InternetAddress to = new InternetAddress(receiveUser);
            message.setRecipient(Message.RecipientType.TO, to);
            // 邮件主题
            message.setSubject(subject);
            // 向multipart对象中添加邮件的各个部分内容，包括文本内容和附件
            Multipart multipart = new MimeMultipart();

            // 添加邮件正文
            BodyPart contentPart = new MimeBodyPart();
            contentPart.setContent(sendHtml, "text/html;charset=UTF-8");
            multipart.addBodyPart(contentPart);
            // 将multipart对象放到message中
            message.setContent(multipart);
            // 保存邮件
            message.saveChanges();

            transport = session.getTransport("smtp");
            // smtp验证，就是你用来发邮件的邮箱用户名密码
            transport.connect(host, sender_username, emailPassword);
            // 发送
            transport.sendMessage(message, message.getAllRecipients());

            System.out.println("send success!");
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (transport != null) {
                try {
                    transport.close();
                } catch (MessagingException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }



}
