package com.bcxin.ins.util.email;

import java.util.ArrayList;
import java.util.List;


public class EmailModel {
	private String subject;
	private String emailType; // 默认发送保众网（即为空）
	private List<String> to = new ArrayList<String>();
	private List<String> cc = new ArrayList<String>();
	private List<String> bcc = new ArrayList<String>();
	private String content;
	private List<String> filePath = new ArrayList<String>();

	public EmailModel(){}

	public EmailModel(String subject, String content){
		this.subject = subject;
		this.content = content;
	}

	public EmailModel(EmailMsgType type, String productName, String policyNum, String date) {
		switch (type) {
			case INSURE_POLICY:
				this.subject = "保单承保通知";
				this.content = "<font color=\"#F18C1E\" style=\"font-family: '黑体';\">尊敬的客户，您好：</font><br>&nbsp;&nbsp;&nbsp;&nbsp;"
						+ "<p style=\"text-indent:2em;\">您投保的"+productName+"已经承保成功，保单号："+policyNum+"，保单生效日期："+date+"。</p>"
						+ "<p style=\"text-indent:2em;\">如有疑问，请致电400-662-9696咨询。</p>";
				break;
			case INSURE_POLICY_FAILD:
				this.subject = "保单承保失败通知";
				this.content = "<font color=\"#F18C1E\" style=\"font-family: '黑体';\">尊敬的客户，您好：</font><br>&nbsp;&nbsp;&nbsp;&nbsp;"
						+ "<p style=\"text-indent:2em;\">您投保的"+productName+"承保失败。</p>"
						+ "<p style=\"text-indent:2em;\">请及时致电400-662-9696进行咨询。</p>";
				break;
			case APPLYFOR:
				this.subject = "客户保单申请通知";
				this.content = "<font color=\"#F18C1E\" style=\"font-family: '黑体';\">您好：</font><br>&nbsp;&nbsp;&nbsp;&nbsp;"
						+ "<p style=\"text-indent:2em;\">有新订单生成(产品："+productName+")！请及时登录保险保函网（<a href='http://www.bailianbao.cn' target='_blank'>http://www.bailianbao.cn</a>）进行查看。</p>";
				break;
			case DECLINATURE:
				this.subject = "订单拒保通知";
				this.content = "<font color=\"#F18C1E\" style=\"font-family: '黑体';\">您好：</font><br>&nbsp;&nbsp;&nbsp;&nbsp;"
						+ "<p style=\"text-indent:2em;\">订单号为："+policyNum+"订单(产品："+productName+")保险公司已拒保！请及时登录保险保函网（<a href='http://www.bailianbao.cn' target='_blank'>http://www.bailianbao.cn</a>）进行查看。</p>";
				break;
			case PASSUNDERWRITING:
				this.subject = "保单核保通过通知";
				this.content = "<font color=\"#F18C1E\" style=\"font-family: '黑体';\">您好：</font><br>&nbsp;&nbsp;&nbsp;&nbsp;"
						+ "<p style=\"text-indent:2em;\">保险公司已核保通过，请及时登录保险保函网（<a href='http://www.bailianbao.cn' target='_blank'>http://www.bailianbao.cn</a>）进行查看。</p>";
				break;
			case ACCOUNTPAID:
				this.subject = "保单完成缴费通知";
				this.content = "<font color=\"#F18C1E\" style=\"font-family: '黑体';\">您好：</font><br>&nbsp;&nbsp;&nbsp;&nbsp;"
						+ "<p style=\"text-indent:2em;\">用户已缴费，请及时登录保险保函网（<a href='http://www.bailianbao.cn' target='_blank'>http://www.bailianbao.cn</a>）进行查看。</p>";
				break;
			case UPLOADBACKLETTER:
				this.subject = "保单保函上传通知";
				this.content = "<font color=\"#F18C1E\" style=\"font-family: '黑体';\">您好：</font><br>&nbsp;&nbsp;&nbsp;&nbsp;"
						+ "<p style=\"text-indent:2em;\">保险公司已上传保单、保函，请及时登录保险保函网（<a href='http://www.bailianbao.cn' target='_blank'>http://www.bailianbao.cn</a>）进行查看。</p>";
				break;
			default:
				break;
		}
	}

	public EmailModel( EmailMsgType type) {
		switch (type) {
			case INSURE_POLICY:
				this.subject = "报案";
				this.content = "<font color=\"#F18C1E\" style=\"font-family: '黑体';\">尊敬的客户，您好：</font><br>&nbsp;&nbsp;&nbsp;&nbsp;"
						+ "<p style=\"text-indent:2em;\">您投保的</p>"
						+ "<p style=\"text-indent:2em;\">如有疑问，请致电400-662-9696咨询。</p>";
				break;
			default:
				break;
		}
	}

	public EmailModel(String code, EmailMsgType type) {
		switch (type) {
			case SMYZM:
				this.subject = "实名认证-邮箱验证码";
				this.content = "<h3>尊敬的客户，您好！</h3> <p>您正在进行实名邮箱验证，本次请求的验证码为：</p> <p> <a>"+code+"</a> </p><p>(为了保障您账户的安全性，请在半小时内完成验证。)</p>";
				break;
			case BDYZM:
				this.subject = "邮箱绑定-邮箱验证码";
				this.content = "<h3>尊敬的客户，您好！</h3> <p>您正在进行实名邮箱验证，本次请求的验证码为：</p> <p> <a>"+code+"</a> </p><p>(为了保障您账户的安全性，请在半小时内完成验证。)</p>";
				break;
			case TYYZM:
				this.subject = "百联保-邮箱验证码";
				this.content = "<h3>尊敬的客户，您好！</h3> <p>本次请求的验证码为：</p> <p> <a>"+code+"</a> </p><p>(为了保障您账户的安全性，请在半小时内完成验证。)</p>";
				break;
			case PAS_DZ_T:
				this.subject = "平安养老险（团意险）-对账异常-订单存在";
				this.content = "<h3>订单对账问题</h3> <p>订单编号为："+code+"请跟进处理。</p>";
				break;
			case PAS_DZ_F:
				this.subject = "平安养老险（团意险）-对账异常-订单不存在";
				this.content = "<h3>订单对账问题</h3> <p>投保单号为："+code+"内部数据不存在。</p>";
				break;
			default:
				break;
		}
	}

	/**
	 * <b>  </b>
	 * @author ZXF
	 * @create 2017/12/22 0022 11:29
	 * @param type 保全类型枚举
	 * @param createTime 保全申请单创建时间
	 * @param ReviseType 申请类型
	 * @param personNum 申请人数
	 * @param tradeSerialNumber 订单号
	 * @param externalReference 保单号
	 * @param reviseSerialNumIns 批改单号
	 * @version
	 * @注意事项 </b>
	 */
	public EmailModel( EmailMsgRecordType type, String createTime, String ReviseType, String personNum, String tradeSerialNumber, String externalReference, String reviseSerialNumIns) {
		switch (type) {
			case RECORD_SEND_BACK:
				this.subject = "保全申请-审核退回";
				this.content = "<font color=\"#F18C1E\" style=\"font-family: '黑体';\">尊敬的客户，您好：</font><br>&nbsp;&nbsp;&nbsp;&nbsp;"
						+ "<p style=\"text-indent:2em;\">关于您["+createTime+"]在保险平台提交的保全申请单["+ReviseType+"]["+personNum+"]，已被退回。请及时处理，以免影响您的后续保障。</p>"
						+ "<p style=\"text-indent:2em;\">订单号：["+tradeSerialNumber+"]</p>"
						+ "<p style=\"text-indent:2em;\">保单号：["+externalReference+"]</p>"
						+ "<p style=\"text-indent:2em;\">暂批单号：["+reviseSerialNumIns+"]</p>"
						+ "<p style=\"text-indent:2em;\">如有疑问请联系客服，电话：400-662-9696。</p>";
				break;
			case RECORD_CHECKED:
				this.subject = "保全申请-已审核";
				this.content = "<font color=\"#F18C1E\" style=\"font-family: '黑体';\">尊敬的客户，您好：</font><br>&nbsp;&nbsp;&nbsp;&nbsp;"
						+ "<p style=\"text-indent:2em;\">关于您["+createTime+"]在保险平台提交的保全申请单["+ReviseType+"]["+personNum+"]，已通过审核。</p>"
						+ "<p style=\"text-indent:2em;\">订单号：["+tradeSerialNumber+"]</p>"
						+ "<p style=\"text-indent:2em;\">保单号：["+externalReference+"]</p>"
						+ "<p style=\"text-indent:2em;\">暂批单号：["+reviseSerialNumIns+"]</p>"
						+ "<p style=\"text-indent:2em;\">如有疑问请联系客服，电话：400-662-9696。</p>";
				break;
			default:
				break;
		}
	}

	public EmailModel( EmailMsgType type, String productName, String perNum, String external_reference, String planned_end_date) {
		switch (type) {
			case BD_JJ_DQ:
				this.subject = "您有保险保单即将到期，请及时处理！";
				this.content = "<font color=\"#F18C1E\" style=\"font-family: '黑体';\">尊敬的客户，您好：</font><br>&nbsp;&nbsp;&nbsp;&nbsp;"
						+ "<p style=\"text-indent:2em;\">保险产品："+productName+"</p>"
						+ "<p style=\"text-indent:2em;\">保 单 号："+external_reference+"</p>"
						+ "<p style=\"text-indent:2em;\">到期时间："+planned_end_date+"</p>"
						+ "<p style=\"text-indent:2em;\">承保人数："+perNum+"</p>"
						+ "<p style=\"text-indent:2em;\">该保单承保的人员将在 "+planned_end_date+" 保障失效（人员投保状态将变成“未投保”），请于 "+planned_end_date+" 为其重新购买保险，进行安全保障！</p>"
						+ "<p style=\"text-indent:2em;\">如有疑问请联系客服，电话：400-662-9696。</p>";
				break;
			case BD_DQ:
				this.subject = "您有保险保单今日到期，请及时处理！";
				this.content = "<font color=\"#F18C1E\" style=\"font-family: '黑体';\">尊敬的客户，您好：</font><br>&nbsp;&nbsp;&nbsp;&nbsp;"
						+ "<p style=\"text-indent:2em;\">保险产品： "+productName+" </p>"
						+ "<p style=\"text-indent:2em;\">保 单 号： "+external_reference+" </p>"
						+ "<p style=\"text-indent:2em;\">到期时间： "+planned_end_date+" </p>"
						+ "<p style=\"text-indent:2em;\">承保人数： "+perNum+" </p>"
						+ "<p style=\"text-indent:2em;\">该保单承保的人员将在今日保障失效（人员投保状态将变成“未投保”），请于今日为其重新购买保险，进行安全保障！</p>"
						+ "<p style=\"text-indent:2em;\">如有疑问请联系客服，电话：400-662-9696。</p>";
				break;
			default:
				break;
		}
	}

	public EmailModel( EmailMsgType type, String productName, String appName, String payUrl, String tradeSerialNumber, String policySerialNumber, String yxDate, String premium) {
		switch (type) {
			case BD_JFPZ:
				this.subject = "订单缴费凭证上传通知";
				this.content = "<font color=\"#F18C1E\" style=\"font-family: '黑体';\">用户已上传付款凭证，请及时处理：</font><br>&nbsp;&nbsp;&nbsp;&nbsp;"
						+ "<p style=\"text-indent:2em;\">保险产品："+productName+"</p>"
						+ "<p style=\"text-indent:2em;\">订 单 号："+tradeSerialNumber+"</p>"
						+ "<p style=\"text-indent:2em;\">投保单号："+policySerialNumber+"</p>"
						+ "<p style=\"text-indent:2em;\">投 保 人："+appName+"</p>"
						+ "<p style=\"text-indent:2em;\">保障期限："+yxDate+"</p>"
						+ "<p style=\"text-indent:2em;\">保    费："+premium+"</p>"
						+ "<p style=\"text-indent:2em;\">缴费凭证：<img src=\""+payUrl+"\" width=\"300\"></p>"
						+ "<p style=\"text-indent:2em;\">如有疑问请联系客服，电话：400-662-9696。</p>";
				break;
			default:
				break;
		}
	}


	/**
	 * <b>  </b>
	 * @author ZXF
	 * @create 2017/12/22 0022 11:29
	 * @param type 保全类型枚举
	 * @param externalReference 保单号
	 * @param starPayTime 缴费周期开始
	 * @param endPayTime 缴费周期结束
	 * @param insuranceName 保险公司名称
	 * @version
	 * @注意事项 </b>
	 */
	public EmailModel( EmailMsgRecordType type, String externalReference, String starPayTime, String endPayTime, String insuranceName) {
		switch (type) {
			case PAY_PENDING:
				this.subject = "保全缴费-待处理";
				this.content = "<p style=\"text-indent:2em;\">保全缴费单已生成，保单号：["+externalReference+"]结算周期:["+starPayTime+"]至["+endPayTime+"]。请及时与["+insuranceName+"]核对，并上传缴费通知单。</p>";
				break;
			default:
				break;
		}
	}

	/**
	 * <b>  </b>
	 * @author ZXF
	 * @create 2017/12/22 0022 11:29
	 * @param type 保全类型枚举
	 * @param name 用户名称
	 * @param username 账号
	 * @param externalReference 保单号
	 * @param starPayTime 缴费周期开始
	 * @param endPayTime 缴费周期结束
	 * @version
	 * @注意事项 </b>
	 */
	public EmailModel( EmailMsgRecordType type, String name, String username, String externalReference, String starPayTime, String endPayTime ) {
		switch (type) {
			case PAY_CHECK_PENDING:
				this.subject = "保全缴费-待审核";
				this.content = "<p style=\"text-indent:2em;\">["+name+"](["+username+"])保全缴费已上传缴费凭证，保单号：["+externalReference+"]结算周期:["+starPayTime+"]至["+endPayTime+"]。请及时处理，并确认缴费是否正确。</p>";
				break;
			default:
				break;
		}
	}


	public String getSubject() {
		return subject;
	}

	public void setSubject(String subject) {
		this.subject = subject;
	}

	public String getEmailType() {
		return emailType;
	}

	public void setEmailType(String emailType) {
		this.emailType = emailType;
	}

	public List<String> getTo() {
		return to;
	}

	public void setTo(List<String> to) {
		this.to = to;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public List<String> getFilePath() {
		return filePath;
	}

	public void setFilePath(List<String> filePath) {
		this.filePath = filePath;
	}

	public void addTo(String email) {
		if(this.to == null) {
			this.to = new ArrayList<String>();
		}
		this.to.add(email);
	}

	public void addFilePath(String filePath) {
		if(this.filePath == null) {
			this.filePath = new ArrayList<String>();
		}
		this.filePath.add(filePath);
	}

	public List<String> getCc() {
		return cc;
	}

	public void setCc(List<String> cc) {
		this.cc = cc;
	}

	public List<String> getBcc() {
		return bcc;
	}

	public void setBcc(List<String> bcc) {
		this.bcc = bcc;
	}


}
