package com.bcxin.ins.util;

import com.bcxin.ins.util.enums.BenefitPeriodType;

import java.util.Calendar;
import java.util.Date;

public class PolicyUtils {

	
	public static Date calcPlannedEndDate(Date inceptionDate,int benefitPeriod,BenefitPeriodType type) {

		Calendar plannedEndDateCal = Calendar.getInstance();
		plannedEndDateCal.setTime(inceptionDate);
		if (BenefitPeriodType.ANNUAL == type) {
			plannedEndDateCal.add(plannedEndDateCal.YEAR, benefitPeriod);
			plannedEndDateCal.add(plannedEndDateCal.DATE, -1);
		} else if (BenefitPeriodType.MONTHLY == type) {
			int startDayOfMonth = plannedEndDateCal.get(plannedEndDateCal.DAY_OF_MONTH);
			plannedEndDateCal.add(plannedEndDateCal.MONTH, benefitPeriod);
			int endDayOfMonth = plannedEndDateCal.get(plannedEndDateCal.DAY_OF_MONTH);
			if (endDayOfMonth == startDayOfMonth) {
				plannedEndDateCal.add(plannedEndDateCal.DATE, -1);
			}
		} else if (BenefitPeriodType.DAILY == type) {
			plannedEndDateCal.add(plannedEndDateCal.DAY_OF_MONTH, benefitPeriod - 1);
		}

		return plannedEndDateCal.getTime();
	}
}
