package com.bcxin.ins.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.util.HttpUtil;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsRoleInpolicy;
import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.util.http.RequestUtil;
import com.bcxin.ins.vo.DictConst;
import com.bcxin.ins.vo.InsPreservationRecordVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OrderSupportUtil {

    private static Logger log = LoggerFactory.getLogger(OrderSupportUtil.class);
//    private final static String  URL ="http://192.168.30.147:8080/";

    //1.3.1.订单推送给支撑接口地址
    private  final  static  String  ORDER_SYNCHRONIZATION="/api/webOrderForm/receiveOrderFormData";

    //1.3.1.交易推送给支撑接口地址
    private  final  static  String  TRAN_SYNCHRONIZATION="/api/webOrderForm/receiveOrderPaymentData";

    //1.3.3.订单撤单
    private  final  static  String  ORDER_CANCELLATIONS="/api/webOrderForm/cancellationOrder";

    public static  String  receiveOrderFormData(String sup_id,OrderFormVo orderVo,InsInsuranceSlip policy, InsTransaction itn, String insName){//有效订单推送
        //需要记录请求记录信息
        String  url =  GlobalResources.map.get("YWZC_URL") +ORDER_SYNCHRONIZATION;
        log.info("请求地址："+url);
        Map<String,Object> orderMap = new HashMap<String,Object>();
        orderMap.put("sign",Constant.WEB_TYPE_COINS);//订单编号
        orderMap.put("orderNumber",policy.getTrade_serial_number());//订单编号
        orderMap.put("sign",Constant.WEB_TYPE_COINS);//平台标识(来源)
        orderMap.put("orderDate", policy.getSigned_date() == null ? ConstProp.BLANK_CHAR : DateUtil.convertDateToString(policy.getSigned_date(),DateUtil.FORMAT1));//购买时间
        String paymentMethod = ConstProp.BLANK_CHAR;
        String stagesNumber = ConstProp.BLANK_CHAR;
        if(policy.getUnderwrite() != null ? StringUtils.isNotEmpty(policy.getUnderwrite().getPayment_way()) : false){
            paymentMethod = policy.getUnderwrite().getPayment_way();
            stagesNumber = ConstProp.DIGIT_ONE.equals(paymentMethod) ? ConstProp.DIGIT_ONE
                    : ConstProp.DIGIT_TWO.equals(paymentMethod) ? "4"
                    : null;
        }else{
            if(itn != null){
                paymentMethod = itn.getPayment_method();
                stagesNumber = ConstProp.DIGIT_ONE.equals(itn.getPayment_method()) ? ConstProp.DIGIT_ONE
                        : ConstProp.DIGIT_TWO.equals(itn.getPayment_method()) ? "4"
                        : null;
            }
        }
        orderMap.put("projectName",insName);//活动名称
        orderMap.put("paymentMethod",paymentMethod);//缴费方式
        orderMap.put("stagesNumber", stagesNumber);//分期期数
        orderMap.put("currency","CNY");//币种
        orderMap.put("startDate",DateUtil.convertDateToString(policy.getInception_date(),DateUtil.FORMAT1));//订单有效期
        orderMap.put("endDate",DateUtil.convertDateToString(policy.getPlanned_end_date(),DateUtil.FORMAT1));//订单失效期
        if(policy.getMailPolicy().getNeed_receipt()==1){
            orderMap.put("invoiceType",policy.getMailPolicy().getInvoice_type());//发票类型
        }else{
            orderMap.put("invoiceType","");//发票类型
        }
        orderMap.put("productId",String.valueOf(policy.getPro_primary().getPro_primary_id()));//产品ID
        orderMap.put("webUserId",String.valueOf(sup_id));//购买用户id
        List<InsRoleInpolicy> roleList = policy.getRolesOfKind("1");
        String province = "0",city = "0",area = "0",address = "";
        if(roleList!=null&&roleList.size()>0){
            InsRoleInpolicy role = roleList.get(0);
            if(StringUtils.isNotEmpty(role.getReg_province())){
                province = role.getReg_province();
            }
            if(StringUtils.isNotEmpty(role.getReg_city())){
                city = role.getReg_city();
            }
            if(StringUtils.isNotEmpty(role.getReg_district())){
                area = role.getReg_district();
            }
            if(StringUtils.isNotEmpty(role.getReg_address())){
                address = role.getReg_address();
            }
        }
        orderMap.put("province",province);//省
        orderMap.put("city",city);//市
        orderMap.put("district",area);//区/县
        orderMap.put("address",address);//详细地址
        if(policy.getRecommend_code()!=null) orderMap.put("distributorId",policy.getRecommend_code());//所属分销商
        orderMap.put("fcy",policy.getPremium());//订单金额
        orderMap.put("webOrderFormId",orderVo.getOid());//订单id
        orderMap.put("policyNo",orderVo.getExternal_reference());//保单号
        if(itn != null){
            orderMap.put("orderPayment.paymentPeriod","");//付款期限
            orderMap.put("orderPayment.payDate",DateUtil.convertDateToString(itn.getStart_time(),DateUtil.FORMAT1));//支付日期
            orderMap.put("orderPayment.payCode",itn.getPay_order_number()==null||"null".equals(itn.getPay_order_number())||"".equals(itn.getPay_order_number())?"":itn.getPay_order_number());//支付编号
            orderMap.put("orderPayment.paySerialNumber",itn.getTrade_serial_number());//支付流水号
            orderMap.put("orderPayment.paymentMethod",itn.getPay_type());//支付方式
            orderMap.put("orderPayment.remainingNumber",String.valueOf(policy.getInsTransaction().size()));//支付期数
            orderMap.put("orderPayment.currentPayable",itn.getPay_amount()==null?"0":String.valueOf(itn.getPay_amount()));//本期应付
            orderMap.put("orderPayment.actualPayment",itn.getOut_of_pocket()==null?"0":String.valueOf(itn.getOut_of_pocket()));//实际支付
        }else{
            orderMap.put("orderPayment.paymentPeriod","");//付款期限
            orderMap.put("orderPayment.payDate",DateUtil.getCurrentDate());//支付日期
            orderMap.put("orderPayment.payCode","0");//支付编号
            orderMap.put("orderPayment.paySerialNumber","0");//支付流水号
            orderMap.put("orderPayment.paymentMethod","0");//支付方式
            orderMap.put("orderPayment.remainingNumber","0");//支付期数
            orderMap.put("orderPayment.currentPayable",StringUtils.isNotEmpty(stagesNumber) ? String.valueOf(policy.getPremium().divide(new BigDecimal(stagesNumber),2,BigDecimal.ROUND_HALF_UP)) : String.valueOf(policy.getPremium()));//本期应付
            orderMap.put("orderPayment.actualPayment","0");//实际支付
        }
        try {
            log.info("报文格式：JSON");
            log.info("请求报文："+orderMap.toString());
            String result= HttpUtil.doPost2(url, orderMap);
            JSONObject  json = JSON.parseObject(result);
            log.info("返回报文："+json.toString());
            if(json!=null&&json.get("success").toString().equals("true")){
                return json.get("data").toString();
            }

        }catch (Exception ex){
            log.info("请求异常："+ex.getMessage());
            ex.printStackTrace();
        }
        return "";
    }

    public static  boolean  receiveTrancetionData(InsInsuranceSlip policy, InsTransaction itn){//有效订单推送
        //需要记录请求记录信息
        String  url = GlobalResources.map.get("YWZC_URL") +TRAN_SYNCHRONIZATION;
        log.info("请求地址："+url);
        Map<String,Object> tranMap = new HashMap<String,Object>();
        tranMap.put("paymentPeriod","");//付款期限
        tranMap.put("payDate",DateUtil.convertDateToString(itn.getStart_time(),DateUtil.FORMAT1));//支付日期
        tranMap.put("payCode",itn.getPay_order_number()==null||"null".equals(itn.getPay_order_number())||"".equals(itn.getPay_order_number())?"":itn.getPay_order_number());//支付编号
        tranMap.put("paySerialNumber",itn.getTrade_serial_number());//支付流水号
        tranMap.put("paymentMethod",itn.getPay_type());//支付方式
        tranMap.put("remainingNumber", DictConst.PAY_TYPE_XX.equals(itn.getPay_type()) ? itn.getPath_sign() : "1");//支付期数
        tranMap.put("currentPayable",itn.getPay_amount());//本期应付
        tranMap.put("actualPayment",itn.getOut_of_pocket()==null?"0":itn.getOut_of_pocket());//实际支付
        tranMap.put("orderFormId",policy.getOrder_zc_id());//
        try {
            log.info("报文格式：JSON");
            log.info("请求报文："+tranMap.toString());
            String result= HttpUtil.doPost2(url, tranMap);
            log.info("返回报文："+result);
            JSONObject  json = JSON.parseObject(result);
            if(json!=null&&json.get("success").toString().equals("true")){
                log.info("支付信息推送业务支撑系统成功："+json);
                return true;
            }
        }catch (Exception ex){
            log.info("请求异常："+ex.getMessage());
            ex.printStackTrace();
        }
        return   false;
    }

    public static  boolean  cancellationOrder(String tradeSerialNumber){//撤单
        //需要记录请求记录信息
        String  url = GlobalResources.map.get("YWZC_URL") +ORDER_CANCELLATIONS;
        StringBuffer params =new StringBuffer("sign="+ Constant.WEB_TYPE_COINS+"&webType="+Constant.WEB_TYPE_COINS);

        if(StringUtils.isNotEmpty(tradeSerialNumber)){
            params.append("&data="+tradeSerialNumber);
        }
        try {
            String s= RequestUtil.sendPost(url, params.toString());
            JSONObject  json = JSON.parseObject(s);
            if(json!=null&&json.get("success").toString().equals("true")){
                return true;
            }
        }catch (Exception ex){
            ex.printStackTrace();
        }
        return   false;
    }

    /**
     * <b> 审批通过的保全单同步业务支撑 </b>
     * @author ZXF
     * @create 2020/02/03 0003 15:04
     * @version
     * @注意事项 </b>
     */
    public static String receivePreservationData(String sup_id, InsInsuranceSlip policy, InsPreservationRecordVo pvo){//有效订单推送
        //需要记录请求记录信息
        String  url =  GlobalResources.map.get("YWZC_URL") +ORDER_SYNCHRONIZATION;
        log.info("请求地址："+url);
        Map<String,Object> orderMap = new HashMap<String,Object>();
        orderMap.put("sign",Constant.WEB_TYPE_COINS);//订单编号
        orderMap.put("orderNumber",pvo.getRevise_serial_number());//订单编号
        orderMap.put("sign",Constant.WEB_TYPE_COINS);//平台标识(来源)
        orderMap.put("orderDate", pvo.getStart_time());//购买时间
//        String paymentMethod = ConstProp.BLANK_CHAR;
//        String stagesNumber = ConstProp.BLANK_CHAR;
//        if(policy.getUnderwrite() != null ? StringUtils.isNotEmpty(policy.getUnderwrite().getPayment_way()) : false){
//            paymentMethod = policy.getUnderwrite().getPayment_way();
//            stagesNumber = ConstProp.DIGIT_ONE.equals(paymentMethod) ? ConstProp.DIGIT_ONE : ConstProp.DIGIT_TWO.equals(paymentMethod) ? "4" : null;
//        }
        orderMap.put("projectName","保单批改");//活动名称
        orderMap.put("reviseType",pvo.getRevise_type());//批改类型
        if(ConstProp.DIGIT_ONE.equals(pvo.getRevise_type())){//增员
            orderMap.put("reviseNum",pvo.getAdd_count());//批改人数
        }else if(ConstProp.DIGIT_TWO.equals(pvo.getRevise_type())){//减员
            orderMap.put("reviseNum",pvo.getMinus_count());//批改人数
        }else {//替换
            orderMap.put("reviseNum",pvo.getReplace_count());//批改人数
        }
        orderMap.put("paymentMethod","1");//缴费方式
        orderMap.put("stagesNumber", "1");//分期期数
        orderMap.put("currency","CNY");//币种
        orderMap.put("startDate",pvo.getInception_date());//订单有效期
        orderMap.put("endDate",pvo.getPlanned_end_date());//订单失效期
        if(policy.getMailPolicy().getNeed_receipt()==1){
            orderMap.put("invoiceType",policy.getMailPolicy().getInvoice_type());//发票类型
        }else{
            orderMap.put("invoiceType","");//发票类型
        }
        orderMap.put("productId",String.valueOf(policy.getPro_primary().getPro_primary_id()));//产品ID
        orderMap.put("webUserId",String.valueOf(sup_id));//购买用户id
        List<InsRoleInpolicy> roleList = policy.getRolesOfKind("1");
        String province = "0",city = "0",area = "0",address = "";
        if(roleList!=null&&roleList.size()>0){
            InsRoleInpolicy role = roleList.get(0);
            if(StringUtils.isNotEmpty(role.getReg_province())){
                province = role.getReg_province();
            }
            if(StringUtils.isNotEmpty(role.getReg_city())){
                city = role.getReg_city();
            }
            if(StringUtils.isNotEmpty(role.getReg_district())){
                area = role.getReg_district();
            }
            if(StringUtils.isNotEmpty(role.getReg_address())){
                address = role.getReg_address();
            }
        }
        orderMap.put("province",province);//省
        orderMap.put("city",city);//市
        orderMap.put("district",area);//区/县
        orderMap.put("address",address);//详细地址
        if(policy.getRecommend_code()!=null) orderMap.put("distributorId",policy.getRecommend_code());//所属分销商
        orderMap.put("fcy",pvo.getTotal_premium());//订单金额
        orderMap.put("webOrderFormId",String.valueOf(pvo.getOid()));//订单id
        orderMap.put("parentOrderFormId",String.valueOf(policy.getIns_insurance_slip_id()));//订单id
        orderMap.put("policyNo",pvo.getExternal_reference());//保单号

        //保全无交易记录，统一给默认值
        orderMap.put("orderPayment.paymentPeriod","");//付款期限
        orderMap.put("orderPayment.payDate",DateUtil.getCurrentDate());//支付日期
        orderMap.put("orderPayment.payCode","0");//支付编号
        orderMap.put("orderPayment.paySerialNumber","0");//支付流水号
        orderMap.put("orderPayment.paymentMethod","0");//支付方式
        orderMap.put("orderPayment.remainingNumber","0");//支付期数
        orderMap.put("orderPayment.currentPayable",StringUtils.isNotEmpty(pvo.getTotal_premium())?pvo.getTotal_premium():"0");//本期应付
        orderMap.put("orderPayment.actualPayment","0");//实际支付

        if(orderMap==null){
            return "";
        }
        try {
            log.info("报文格式：JSON");
            log.info("请求报文："+orderMap.toString());
            String result= HttpUtil.doPost2(url, orderMap);
            JSONObject  json = JSON.parseObject(result);
            log.info("返回报文："+json.toString());
            if(json!=null&&json.get("success").toString().equals("true")){
                return json.get("data").toString();
            }

        }catch (Exception ex){
            log.info("请求异常："+ex.getMessage());
            ex.printStackTrace();
        }
        return "";
    }

    /**
     * <b> 对接新的业务系统 </b>
     * @author ZXF
     * @create 2021/02/03 0003 21:46
     * @version
     * @注意事项 </b>
     */
    public static String sendOrderFormData(OrderFormVo orderVo,InsInsuranceSlip policy, InsTransaction itn){//有效订单推送
        /*** 保险订单同步接口的业务参数  ***/
        String platUrl = "http://bms.test.bcxin.com.cn";
        String interFaceUrl = "/order/ins/sync";
        String url = platUrl + interFaceUrl;
        log.info("请求地址："+url);
        Map<String,Object> param =  new HashMap<>();
        param.put("orderNo",policy.getTrade_serial_number()); // 订单编号:对应系统的订单编号 不可为空
        param.put("orderAmount",policy.getPremium()); // 订单金额 不可为空
        param.put("totalAmount",itn.getOut_of_pocket()==null?"0":String.valueOf(itn.getOut_of_pocket())); // 实收金额：实收金额<= 订单金额 不可为空
        param.put("customName",orderVo.getApplicant_name()); // 下单客户的名称：例如保险就是下单的saas企业名称 不可为空
        List<InsRoleInpolicy> roleList = policy.getRolesOfKind("1");
        String province = "0",city = "0",area = "0";
        if(roleList!=null&&roleList.size()>0){
            InsRoleInpolicy role = roleList.get(0);
            if(StringUtils.isNotEmpty(role.getReg_province())){
                province = role.getReg_province();
            }
            if(StringUtils.isNotEmpty(role.getReg_city())){
                city = role.getReg_city();
            }
            if(StringUtils.isNotEmpty(role.getReg_district())){
                area = role.getReg_district();
            }
        }
        param.put("province",Integer.parseInt(province)); // 订单所在省id 不可为空
        param.put("city",Integer.parseInt(city)); // 订单所在市id :
        param.put("area",Integer.parseInt(area)); // 订单所在区县id :
        param.put("productId",0L); // 产品ID: 需要从业务系统获取 不可为空 TODO 待完善
        param.put("orderCreateTime",orderVo.getStart_time()); // 订单创建时间 不可为空
        param.put("payTime",DateUtil.convertDateToString(itn.getStart_time(),DateUtil.FORMAT1)); // 支付时间 不可为空
        param.put("policyNo",orderVo.getExternal_reference()); // 保单号 不可为空
        param.put("endorsementNo",""); // 批单号 不可为空 TODO 初次投保没批单号
        param.put("insuredPers",orderVo.getInsurance_name()); // 被保险人 不可为空
        param.put("economicCompanyNo",""); // 经济公司编号 不可为空 TODO 待完善
        param.put("economicCompanyName",orderVo.getInsurance_name()); // 经济公司名称 不可为空
        param.put("guarantStartTime",orderVo.getInception_date()); // 保障开始时间 不可为空
        param.put("guarantEndTime",orderVo.getPlanned_end_date()); // 保障结束时间 不可为空 需大于保障开始时间


        try {
            log.info("报文格式：JSON");
            log.info("请求报文："+param.toString());
            String result= HttpUtil.doPost2(url, param);
            JSONObject json = JSON.parseObject(result);
            log.info("返回报文："+json.toString());
            if(json!=null&&json.get("ret").toString().equals("0")){
                return json.get("data").toString();
            }

        }catch (Exception ex){
            log.info("请求异常："+ex.getMessage());
            ex.printStackTrace();
        }
        return "";
    }

    /**
     * <b> 对接新的业务系统 </b>
     * @author ZXF
     * @create 2021/02/03 0003 21:46
     * @version
     * @注意事项 </b>
     */
    public static String sendOrderFormData(OrderFormVo orderVo,InsInsuranceSlip policy, InsPreservationRecordVo pvo){//有效订单推送
        /*** 保险订单同步接口的业务参数  ***/
        String platUrl = "http://bms.test.bcxin.com.cn";
        String interFaceUrl = "/order/ins/sync";
        String url = platUrl + interFaceUrl;
        log.info("请求地址："+url);
        Map<String,Object> param =  new HashMap<>();
        param.put("orderNo",pvo.getRevise_serial_number()); // 订单编号:对应系统的订单编号 不可为空
        param.put("orderAmount",pvo.getTotal_premium()); // 订单金额 不可为空
        param.put("totalAmount","0"); // 实收金额：实收金额<= 订单金额 不可为空 TODO 批单统一走线下结算 无实收
        param.put("customName",orderVo.getApplicant_name()); // 下单客户的名称：例如保险就是下单的saas企业名称 不可为空
        List<InsRoleInpolicy> roleList = policy.getRolesOfKind("1");
        String province = "0",city = "0",area = "0";
        if(roleList!=null&&roleList.size()>0){
            InsRoleInpolicy role = roleList.get(0);
            if(StringUtils.isNotEmpty(role.getReg_province())){
                province = role.getReg_province();
            }
            if(StringUtils.isNotEmpty(role.getReg_city())){
                city = role.getReg_city();
            }
            if(StringUtils.isNotEmpty(role.getReg_district())){
                area = role.getReg_district();
            }
        }
        param.put("province",Integer.parseInt(province)); // 订单所在省id 不可为空
        param.put("city",Integer.parseInt(city)); // 订单所在市id :
        param.put("area",Integer.parseInt(area)); // 订单所在区县id :
        param.put("productId",0L); // 产品ID: 需要从业务系统获取 不可为空 TODO 待完善
        param.put("orderCreateTime",pvo.getRelease_time()); // 订单创建时间 不可为空
        param.put("payTime",""); // 支付时间 不可为空 TODO 批单统一走线下结算 无时间
        param.put("policyNo",orderVo.getExternal_reference()); // 保单号 不可为空
        param.put("endorsementNo",pvo.getRevise_serial_num_ins()); // 批单号 不可为空 TODO 初次投保没批单号
        param.put("insuredPers",orderVo.getInsurance_name()); // 被保险人 不可为空
        param.put("economicCompanyNo",""); // 经济公司编号 不可为空 TODO 待完善
        param.put("economicCompanyName",orderVo.getInsurance_name()); // 经济公司名称 不可为空
        param.put("guarantStartTime",pvo.getInception_date()); // 保障开始时间 不可为空
        param.put("guarantEndTime",orderVo.getPlanned_end_date()); // 保障结束时间 不可为空 需大于保障开始时间


        try {
            log.info("报文格式：JSON");
            log.info("请求报文："+param.toString());
            String result= HttpUtil.doPost2(url, param);
            JSONObject json = JSON.parseObject(result);
            log.info("返回报文："+json.toString());
            if(json!=null&&json.get("ret").toString().equals("0")){
                return json.get("data").toString();
            }

        }catch (Exception ex){
            log.info("请求异常："+ex.getMessage());
            ex.printStackTrace();
        }
        return "";
    }

    public static HttpServletRequest getRequest(){
        if(RequestContextHolder.getRequestAttributes() != null){
            return ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        }else{
            return null;
        }
    }

    public static void main(String[] args) {
//        getUserSynchronization();
    }
}