package com.bcxin.ins.util;

import com.alibaba.fastjson.JSON;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.map.HashedMap;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.*;

public class JSONUtils {

	/**
	 * 传入任意一个 object对象生成一个指定规格的字符串
	 * 
	 * @param object
	 *            任意对象
	 * @return String
	 */
	public static String objectToJson(Object object) {
		StringBuilder json = new StringBuilder();
		if (object == null) {
			json.append("\"\"");
		} else if (object instanceof String || object instanceof Integer
				|| object instanceof Double) {
			json.append("\"").append(object.toString()).append("\"");
		} else {
			json.append(beanToJson(object));
		}
		return json.toString();
	}

	/**
	 * 传入任意一个 Javabean对象生成一个指定规格的字符串
	 * 
	 * @param bean
	 *            bean对象
	 * @return String "{}"
	 */
	public static String beanToJson(Object bean) {
		StringBuilder json = new StringBuilder();
		json.append("{");
		PropertyDescriptor[] props = null;
		try {
			props = Introspector.getBeanInfo(bean.getClass(), Object.class)
					.getPropertyDescriptors();
		} catch (Exception e) {
			e.printStackTrace();
		}
		if (props != null) {
			for (int i = 0; i < props.length; i++) {
				try {
					String name = objectToJson(props[i].getName());
					String value = objectToJson(props[i].getReadMethod()
							.invoke(bean));
					json.append(name);
					json.append(":");
					json.append(value);
					json.append(",");
				} catch (Exception e) {
				}
			}
			json.setCharAt(json.length() - 1, '}');
		} else {
			json.append("}");
		}
		return json.toString();
	}

	/**
	 * 传入任意一个 Javabean对象生成一个指定规格，指定名称的字符串
	 * 
	 * @param values
	 *            属性值
	 * @param names
	 *            字段名称数组
	 * @return String "{}"
	 */
	public static String beanToJsonByName(String[] names, String[] values) {
		StringBuilder json = new StringBuilder();
		json.append("{");
		
		if (values != null && names.length == values.length) {
			for (int i = 0; i < values.length; i++) {
				try {
					String name = objectToJson(names[i]);
					String value = objectToJson(values[i]);
					json.append(name);
					json.append(":");
					json.append(value);
					json.append(",");
				} catch (Exception e) {
				}
			}
			json.setCharAt(json.length() - 1, '}');
		} else {
			json.append("}");
		}
		return json.toString();
	}

	/**
	 * 请求返回json串
	 * 
	 * @param resultCode
	 *            结果code
	 * @param message
	 *            返回信息
	 * @return
	 */
	public static String getBackJson(String resultCode, String message) {

		if (StringUtils.isEmpty(resultCode)) {
			return null;
		}
		StringBuilder json = new StringBuilder();
		json.append("{\"code\":");
		json.append(resultCode);
		json.append(",\"message\":\"");
		json.append(message);
		json.append("\"}");

		return json.toString();
	}
	
	/**
	 * 请求返回对象类json串
	 * 
	 * @param resultCode
	 *            结果code
	 * @param message
	 *            返回信息
	 * @return
	 */
	public static String getBackObjJson(String resultCode, String message) {
		
		if (StringUtils.isEmpty(resultCode)) {
			return null;
		}
		StringBuilder json = new StringBuilder();
		json.append("{\"code\":");
		json.append(resultCode);
		json.append(",\"object\":");
		json.append(message);
		json.append("}");
		
		return json.toString();
	}
	
	/**
	 * 请求返回多字段带对象类json串
	 * 
	 * @param names
	 *            字段名
	 * @param values
	 *            字段值
	 * @param atList
	 *            对象所在位置
	 * @return
	 */
	public static String getBackObjJson(String[] names, String[] values, List<Integer> atList) {
		
		if (names == null || names.length != values.length) {
			return null;
		}
		StringBuilder json = new StringBuilder();
		json.append("{");
		for (int i = 0; i < names.length; i++) {
			if (i == 0) {
				json.append("\"");
			} else {
				json.append(",\"");
			}
			json.append(names[i]);
			json.append("\":");
			if (atList.contains(i)) {
				json.append(values[i]);
			} else {
				json.append("\"");
				json.append(values[i]);
				json.append("\"");
			}
		}
		json.append("}");
		
		return json.toString();
	}
	
	/**
	 * 请求返回多个对象类json串
	 * 
	 * @param names 对象名称
	 * @param values 对象转换后JSON串
	 * @return
	 */
	public static String getBackMultiObjJson(String[] names, String[] values) {
		
		if (names == null || names.length != values.length) {
			return null;
		}
		StringBuilder json = new StringBuilder();
		json.append("{");
		for (int i = 0; i < names.length ; i++) {
			if (i != 0) {
				json.append(",");
			}
			json.append("\"" + names[i] + "\":");
			if (StringUtils.isEmpty(values[i])) {
				json.append("[]");
			} else {
				json.append(values[i]);
			}
		}
		json.append("}");
		
		return json.toString();
	}

	/**
	 * 通过传入一个列表对象,调用指定方法将列表中的数据生成一个JSON规格指定字符串
	 * 
	 * @param names
	 *            字段名称数组
	 * @param list
	 *            列表对象
	 * @return String "[{},{}]"
	 */
	public static String listToJsonByName(String[] names, List<String[]> list) {
		StringBuilder json = new StringBuilder();
		json.append("[");
		if (list != null && list.size() > 0) {
			for (String[] obj : list) {
				json.append(beanToJsonByName(names, obj));
				json.append(",");
			}
			json.setCharAt(json.length() - 1, ']');
		} else {
			json.append("]");
		}
		return json.toString();
	}

	/**
	 * 通过传入一个列表对象,调用指定方法将列表中的数据生成一个JSON规格指定字符串
	 * 
	 * @param list
	 *            列表对象
	 * @return String "[{},{}]"
	 */
	public static String listToJson(List<?> list) {
		StringBuilder json = new StringBuilder();
		json.append("[");
		if (list != null && list.size() > 0) {
			for (Object obj : list) {
				json.append(objectToJson(obj));
				json.append(",");
			}
			json.setCharAt(json.length() - 1, ']');
		} else {
			json.append("]");
		}
		return json.toString();
	}

	/**
	 * json转换为Map
	 * 
	 * @param jsonStr
	 * @return
	 */
	public static Map<String, Object> parseJSON2Map(String jsonStr) {
		Map<String, Object> map = new HashMap<String, Object>();
		// 最外层解析
		JSONObject json = JSONObject.fromObject(jsonStr);
		for (Object k : json.keySet()) {
			Object v = json.get(k);
			// 如果内层还是数组的话，继续解析
			if (v instanceof JSONArray) {
				List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
				Iterator<JSONObject> it = ((JSONArray) v).iterator();
				while (it.hasNext()) {
					JSONObject json2 = it.next();
					list.add(parseJSON2Map(json2.toString()));
				}
				map.put(k.toString(), list);
			} else {
				map.put(k.toString(), v);
			}
		}
		return map;
	}

	/**
	 * 由json转换的map再处理转key为大写
	 * @param body
	 * @return
	 */
	public static Map<String, Object> getUpperMap(Map<String, Object> body) {
		Set<String> keys = body.keySet();
		Map<String, Object> resultMap = new HashedMap();
		for(String key :keys){
			resultMap.put(key.toUpperCase(),body.get(key));
		}
		return resultMap;
	}

	public static void main(String[] args) {
		String  json2 ="{\"header\":{\"transactionCode\":\"TCEGISNBUAPC001\",\"partnerId\":\"PCXM001\",\"requestId\":\"1494307726824\",\"code\":\"CRIGHT_0000\",\"message\":null},\"body\":\"{\\\"barCode\\\":\\\"9041K009838136\\\",\\\"fromPartnerId\\\":\\\"PAEGISNBU001\\\",\\\"realFromPartnerId\\\":\\\"PCXM001\\\",\\\"receiptNo\\\":\\\"30000070075779085\\\",\\\"responseMsg\\\":\\\"AMESB接口InsuredAMESBService调用成功！\\\",\\\"returnFlag\\\":\\\"1\\\",\\\"totalPremium\\\":\\\"510\\\"}\"}";
		Map<String, Object> map  = JSON.parseObject(json2,Map.class);
		Map<String, Object> header = JSON.parseObject( map.get("header").toString(),Map.class);
		Map<String, Object> header1 = getUpperMap(header);
		Map<String, Object> body = JSON.parseObject( map.get("body").toString(),Map.class);
		Map<String, Object> body1 = getUpperMap(body);


		System.out.println("调用后body"+body.toString());
		System.out.println("调用前body"+body1.toString());
		System.out.println("调用后header"+header.toString());
		System.out.println("调用前header"+header1.toString());
//		User u = new User();
//		u.setName("張三");
//		u.setSex("男");
//		u.setBirthdat(DateUtil
//				.convertDateToString(new Date(), DateUtil.FORMAT2));
//
//		List<User> uList = new ArrayList<User>();
//		uList.add(u);
//		for (int i = 0; i < 3; i++) {
//			User u1 = new User();
//			u1.setName("李四" + i);
//			u1.setSex("女");
//			u1.setBirthdat(DateUtil.convertDateToString(new Date(),
//					DateUtil.FORMAT2));
//			uList.add(u1);
//		}
//		String[] names = new String[] { "姓名", "性别", "生日" };
//		String[] values = new String[]{u.getName(), u.getSex(), u.getBirthdat()};
//		String uStr = beanToJson(u);
//		String uStr1 = objectToJson(u);
//		String uStr3 = beanToJsonByName(names, values);
//		String uListStr = listToJson(uList);
//		String uListStr2 = listToJsonByName(names, uList);

//		System.out.println("uStr==" + uStr);
//		System.out.println("uStr1==" + uStr1);
//		System.out.println("uStr3==" + uStr3);
//		System.out.println("uListStr==" + uListStr);
//		System.out.println("uListSt2r==" + uListStr2);

		// JSONObject uStr2 = JSONObject.fromObject(u);
		// JSONArray uListStr2 = JSONArray.fromObject(uList);
		//
		// System.out.println("uStr2==" + uStr2.toString());
		// System.out.println("uListStr2==" + uListStr2.toString());
	}

	public static class User {

		private String name = "";

		private String sex = "";

		private String birthdat;

		public String getName() {
			return name;
		}

		public void setName(String name) {
			this.name = name;
		}

		public String getSex() {
			return sex;
		}

		public void setSex(String sex) {
			this.sex = sex;
		}

		public String getBirthdat() {
			return birthdat;
		}

		public void setBirthdat(String birthdat) {
			this.birthdat = birthdat;
		}

	}
}
