package com.bcxin.ins.util;


import com.google.common.collect.Maps;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.Map;

/**
 * <b>
 *     用于帮助不同文件读写的帮助类
 * </b>
 * @author ZXF
 * @create 2018/06/08 0008 14:50
 * @version
 * @注意事项 </b>
 */
public class FileHelp {

	private static Logger logger = LoggerFactory.getLogger(FileHelp.class);

	/**
	 * <b>
	 *     专门帮助为MultipartFile形式的文件对象做读写操作
	 * </b>
	 * @param mFile 原生的文件上传获取的
	 * @param path 保存文件的路径（/data/upload/blb/policy/）
	 * @param fileName 文件命名（123.pdf）
	 * @author ZXF
	 * @create 2018/06/08 0008 14:14
	 * @version
	 * @注意事项 </b>
	 */
	public static void mFile(MultipartFile mFile, String path, String fileName){
		try {
			File fileP = new File(path);
			if (!fileP.exists()) {
				fileP.mkdirs();
			}
			File file = new File(path + fileName);

			mFile.transferTo(file);
		} catch(Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * <b>
	 *     inStream流文件写入，专门帮助为输入流形式的文件读写操作
	 * </b>
	 * @param bytes 字节数组（可以是BASE64Util.decryptBASE64Byte对字符流转换得到）
	 * @param path 保存文件的路径（/data/upload/blb/policy/）
	 * @param fileName 文件命名（123.pdf）
	 * @author ZXF
	 * @create 2018/06/08 0008 14:14
	 * @version
	 * @注意事项 </b>
	 */
	public static void byteFile(byte[] bytes, String path, String fileName){
		File fileP = new File(path);
		if (!fileP.exists()) {
			fileP.mkdirs();
		}
		File file = new File(path + fileName);
		try(BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file, true));) {
			for(int h=0;h<bytes.length;h++){
				bos.write(bytes[h]);
			}
			bos.write("\r\n".getBytes());
			bos.flush();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * <b> 填写报案的附件上传 </b>
	 * @param file
	 * @param pathHead 目录头（/data/upload/blb）
	 * @param folder 目录头后紧跟的文件夹（/report/）
	 * @param domainName 当前项目环境域名（http://www.bailianbao.cn）
	 * @author ZXF
	 * @create 2020/06/16 0016 10:48
	 * @version
	 * @注意事项 </b>
	 */
	public static String reportUpload(MultipartFile file,String pathHead,String folder,String domainName){
		if (file != null) {
			String fileType = file.getOriginalFilename().split(".")[1];
			String fileName = System.currentTimeMillis() + "_RNO." + fileType;
			try(InputStream inStream = file.getInputStream()) {
				String path = pathHead+folder;
				FileHelp.isFile(inStream, path, fileName);
				imageOp(path+fileName,100,80);
				return domainName + "/getResource?path="+folder + fileName;
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return "";
	}

	/**
	 * <b>
	 *     inStream流文件写入，专门帮助为输入流形式的文件读写操作
	 * </b>
	 * @param inStream 文件读到的流（可以是由HttpURLConnection访问某个第三方地址获取到流）
	 * @param path 保存文件的路径（/data/upload/blb/policy/）
	 * @param fileName 文件命名（123.pdf）
	 * @author ZXF
	 * @create 2018/06/08 0008 14:14
	 * @version
	 * @注意事项 </b>
	 */
	public static void isFile(InputStream inStream, String path, String fileName){
		File fileP = new File(path);
		if (!fileP.exists()) {
			fileP.mkdirs();
		}
		File file = new File(path + fileName);
		try(BufferedInputStream bis = new BufferedInputStream(inStream);
			BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file, true));) {
			byte[] buff = new byte[2048];
			int bytesRead;
			while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
				bos.write(buff, 0, bytesRead);
			}
			bos.write("\r\n".getBytes());
			bos.flush();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * <b> http下载第三方文件转存到服务器 </b>
	 * @author ZXF
	 * @create 2020/05/09 0009 11:06
	 * @version
	 * @注意事项 </b>
	 */
	public static String saveFile(String fileUrl){
		String filePath = "/data/upload/blb/policy/";
		String fileName = (new Date()).getTime() + RandomStringUtils.random(5, new char[]{'a','b','c','d','e','f'});
		return downloadFileAndSave(fileUrl, filePath, fileName,".jpg");
	}

	public static String downloadFileAndSave(String fileUrl,String filePath, String fileName, String fileFix) {
		String result = fileUrl;
		if (StringUtils.isNotEmpty(fileUrl)) {
			InputStream inStream = null;
			try {
				URL url = new URL(fileUrl);
				HttpURLConnection conn = (HttpURLConnection)url.openConnection();
				conn.setRequestMethod("GET");
				conn.setConnectTimeout(5 * 1000);
				inStream = conn.getInputStream();//通过输入流获取图片数据
				isFile(inStream, filePath, fileName +fileFix);
				result = "/getResource?path=/policy/"+fileName +fileFix;
			} catch (Exception e) {
				e.printStackTrace();
			} finally {
				if (inStream != null) {
					try {
						inStream.close();
					} catch (IOException e1) {
						e1.printStackTrace();
					}
				}
			}
		}
		return result;
	}

	public static Map<String,String> httpFileToBase64(String fileUrl){
		Map<String,String> map = Maps.newHashMap();
		String base64 = "";
		String size = "0";
		if (StringUtils.isNotEmpty(fileUrl)) {
			InputStream inStream = null;
			try {
				URL url = new URL(fileUrl);
				HttpURLConnection conn = (HttpURLConnection)url.openConnection();
				conn.setRequestMethod("GET");
				conn.setConnectTimeout(5 * 1000);
				inStream = conn.getInputStream();
				size = String.valueOf(inStream.available()/1000);
				base64 = BASE64Util.encryptBASE64Byte(IOUtils.toByteArray(inStream));
			} catch (Exception e) {
				e.printStackTrace();
			} finally {
				if (inStream != null) {
					try {
						inStream.close();
					} catch (IOException e1) {
						e1.printStackTrace();
					}
				}
			}
		}
		map.put("size",size);
		map.put("base64",base64);
		return map;
	}

	/**
	 * <b>  </b>
	 * @param inFilePath 图片原路径 /data/upload/blb/report/1575615964667.jpg
	 * @author ZXF
	 * @create 2020/06/15 0015 17:35
	 * @version
	 * @注意事项 </b>
	 */
	public static void imageOp(String inFilePath, int width, int height){
		File tempFile = new File(inFilePath);
		Image image = null;
		try {
			image = ImageIO.read(tempFile);
		} catch (IOException e) {
			System.out.println("file path error...");
		}

		int originalImageWidth = image.getWidth(null);
		int originalImageHeight = image.getHeight(null);

		BufferedImage originalImage = new BufferedImage(
				originalImageWidth,
				originalImageHeight,
				BufferedImage.TYPE_3BYTE_BGR);
		Graphics2D g2d = originalImage.createGraphics();
		g2d.drawImage(image, 0, 0, null);

		BufferedImage changedImage =
				new BufferedImage(
						width,
						height,
						BufferedImage.TYPE_3BYTE_BGR);

		double widthBo = (double)width/originalImageWidth;
		double heightBo = (double)width/originalImageHeight;

		AffineTransform transform = new AffineTransform();
		transform.setToScale(widthBo, heightBo);

		AffineTransformOp ato = new AffineTransformOp(transform, null);
		ato.filter(originalImage, changedImage);
		String outFilePath = inFilePath.replace(ConstProp.DOT,"_THUMB.");
		File fo = new File(outFilePath); //将要转换出的小图文件
		try {
			ImageIO.write(changedImage, "jpeg", fo);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
