package com.bcxin.ins.util;


import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.xiaoleilu.hutool.io.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.*;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import com.bcxin.ins.vo.ConstProp;


public class FileBatchUtil {

	private static Logger logger = LoggerFactory.getLogger(FileBatchUtil.class);

	private static String MAP_URL = "url";
	private static String MAP_NAME = "name";

	public static String writeFileToZip(String zipName, List<Map<String,String>> list){
		String resultPath = ConstProp.BLANK_CHAR;
		//文件的名称
		String downloadFilename = zipName+".zip";
		//转换中文否则可能会产生乱码
		try {
			downloadFilename = URLEncoder.encode(downloadFilename, "UTF-8");
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		String pathTop = GlobalResources.COM_IMG_RE/*"F://D_pan/ase"*/+"/zip/";
		resultPath = pathTop+downloadFilename;
		logger.info("writeFileToZip:(resultPath)-"+resultPath);
		File resultPathFile = new File(pathTop);
		if(!resultPathFile.exists()){
			resultPathFile.mkdirs();
		}
		try(ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(new File(resultPath)));) {
			for (Map<String,String> map : list) {
				String urls = map.get(MAP_URL);
				InputStream fis = null;
				String fTy;
				try {
					if(StringUtils.isNotEmpty(urls)){
						fTy = urls.substring(urls.indexOf('.'),urls.length());
						if(urls.contains(".com/")){
							String keyH = urls.split(".com/")[1];
							fTy = keyH.substring(keyH.indexOf('.'),keyH.length());
							fis = OSSFileUtil.getInputStreamByKey(keyH);
						}else{
							URL url = new URL(urls);
							fis = url.openConnection().getInputStream();
						}
					}else{
						continue;
					}
					zos.putNextEntry(new ZipEntry(map.get(MAP_NAME)+fTy));
					logger.info("writeFileToZip:(zip.index)-name:"+urls+",url:"+map.get(MAP_NAME)+fTy);
					byte[] buffer = new byte[1024];
					int r = 0;
					while ((r = fis.read(buffer)) != -1) {
						zos.write(buffer, 0, r);
					}
				}catch (Exception e){
					e.printStackTrace();
				}finally {
					if(fis != null){
						fis.close();
					}
				}
			}
			zos.flush();
		} catch (UnsupportedEncodingException e) {
			logger.error(e.getMessage()+e);
			e.printStackTrace();
		} catch (IOException e) {
			logger.error(e.getMessage()+e);
			e.printStackTrace();
		}
		logger.info("writeFileToZip:(return)-resultPath:"+resultPath);
		return resultPath;
	}

	/**
	 * 删除单个文件
	 * @param sPath 被删除文件的路径+文件名
	 * @return 单个文件删除成功返回true，否则返回false
	 */
	public static boolean deleteFile(String sPath) {
		Boolean flag = false;
		File file = new File(sPath);
		// 路径为文件且不为空则进行删除
		if (file.isFile() && file.exists()) {
			try {
				Files.delete(file.toPath());
			} catch (IOException e) {
				e.printStackTrace();
			}
			flag = true;
		}
		return flag;
	}

	public static String dealErJinZhiFile(String zipName, List<Map<String,String>> list) throws Exception {
		String zipPath = writeFileToZip(zipName, list);
		String fileString = ConstProp.BLANK_CHAR;
		if(StringUtils.isNotEmpty(zipPath)){
			byte[] buff = FileUtil.readBytes(new File(zipPath));
			fileString = CxfBase64Utility.encode(buff);

		}
		/*String zipPath = writeFileToZip(zipName, list);
//		String filePath="F://D_pan/ase"+"/zip/";
		//数据文件
		byte[] fileData = null;
		String fileString = "";
		BufferedInputStream bis = new BufferedInputStream(new FileInputStream(
				zipPath));
		ByteArrayOutputStream bos = new ByteArrayOutputStream();
		int count = 0;
		byte[] data = new byte[8192];
		int num = 1;
		while ((count = bis.read(data, 0, data.length)) != -1) {
			bos.write(data, 0, count);
			num++;
		}
		System.out.println(num);
		bis.close();
		String content = new String(bos.toByteArray(),"UTF-8");
		fileData = bos.toByteArray();
		fileString = CxfBase64Utility.encode(fileData);
		System.out.println("输出内容："+fileString);
		bos.close();*/

		/*byte[] zipInfoByte = null;
		zipInfoByte = CxfBase64Utility.decode(fileString);
		FileOutputStream fileout = null;
		String zipNamePath = filePath + "new_aa.zip";
		File file = new File(zipNamePath);
		if (file.exists()) {
			file.delete();
		}
		fileout = new FileOutputStream(file);
		fileout.write(zipInfoByte, 0, zipInfoByte.length);
		fileout.close();*/
		return fileString;
	}

	public static void main(String[] args) throws Exception {
		String zipFil = "F://D_pan/ase/zip/1524039872820.zip";

		byte[] buff = FileUtil.readBytes(new File(zipFil));
		String fileString = CxfBase64Utility.encode(buff);
		com.xiaoleilu.hutool.lang.Console.log(fileString);
		byte[] zipInfoByte = CxfBase64Utility.decode(fileString);
		String zipNamePath = "F:\\D_pan\\ase\\zip\\new_aa.zip";
		File file = new File(zipNamePath);
		if (file.exists()) {
			try {
				Files.delete(file.toPath());
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		try(FileOutputStream fileout = new FileOutputStream(file);){
			fileout.write(zipInfoByte, 0, zipInfoByte.length);
		}catch (Exception e){
			e.printStackTrace();
		}
	}

}
