package com.bcxin.ins.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.*;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Hashtable;
import com.bcxin.ins.vo.ConstProp;
import org.apache.commons.codec.binary.Base64;

public class ErweimaUtil {

	private static final int BLACK = 0xFF000000; 
	private static final int WHITE = 0xFFFFFFFF;
	
	public static void main(String[] args)throws Exception { 
//		String url = "http://www.abc.com.cn";
//		String path = "D:\\ase\\1232.png";
		//createErWeiMa(url, path);
		//compound("123","D:\\ase\\电子保函22.pdf", path, "D:\\ase\\a111.pdf");
		
		String oidStr =DesUtil.desEncodeCBC(ConstProp.REPORT_KEY, "AXIM999Z2016E100101H");
		oidStr = URLEncoder.encode(oidStr,ConstProp.ENCODE_UTF8);
		System.out.println(oidStr);
		String vv = URLDecoder.decode(oidStr,ConstProp.ENCODE_UTF8);
		vv = DesUtil.desDecodeCBC(ConstProp.REPORT_KEY, vv);
		System.out.println(vv);
	} 
	
	public static void compound(String pno, String pdfPath, String codePath, String resultPath)throws Exception{
		GlobalResources res = new GlobalResources();
		createErWeiMa( res.DIMENSIONCODE+pno, codePath );
		
		PdfReader pdfReader = new PdfReader(pdfPath); 
		PdfStamper pdfStamper = new PdfStamper(pdfReader, new FileOutputStream(resultPath)); 
		PdfContentByte over = pdfStamper.getOverContent(1); 
		//增加图形 
		Image img = Image.getInstance(codePath);//选择图片
		img.setAlignment(1);
		img.scaleAbsolute(100,100);//控制图片大小
		img.setAbsolutePosition(52,390);//控制图片位置
		over.addImage(img);
		pdfStamper.close();
	}
	
	public static BufferedImage toBufferedImage(BitMatrix matrix) { 
		int[] rec = matrix.getEnclosingRectangle();  
		int resWidth = rec[2] + 1;  
		int resHeight = rec[3] + 1;  
		BitMatrix resMatrix = new BitMatrix(resWidth, resHeight);  
		resMatrix.clear();  
		for (int i = 0; i < resWidth; i++) {  
		    for (int j = 0; j < resHeight; j++) {  
		        if (matrix.get(i + rec[0], j + rec[1])) { 
		             resMatrix.set(i, j); 
		        } 
		    }  
		}  
		int width = resMatrix.getWidth(); 
	     int height = resMatrix.getHeight(); 
	     BufferedImage image = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB); 
	     for (int x = 0; x < width; x++) { 
	       for (int y = 0; y < height; y++) { 
	         image.setRGB(x, y, resMatrix.get(x, y) ? BLACK : WHITE); 
	       } 
	     } 
	     return image; 
	   } 
	    
	      
	   public static void writeToFile(BitMatrix matrix, String format, File file) 
	       throws IOException { 
	     BufferedImage image = toBufferedImage(matrix); 
	     if (!ImageIO.write(image, format, file)) { 
	       throw new IOException("Could not write an image of format " + format + " to " + file); 
	     } 
	   } 
	    
	      
	   public static void writeToStream(BitMatrix matrix, String format, OutputStream stream) 
	       throws IOException { 
	     BufferedImage image = toBufferedImage(matrix); 
	     if (!ImageIO.write(image, format, stream)) { 
	       throw new IOException("Could not write an image of format " + format); 
	     } 
	   } 
	   
	 /**
	 * 生成要访问的链接 和 图片生成的地址
	 * @param url
	 * @param path
	 * @throws Exception 
	 */ 
	public static void createErWeiMa(String url,String  path) throws Exception{
		//url="http://test.pss360.cn/getOrederDetatil/50757632";
		String oid=url.substring(url.lastIndexOf('/')+1,url.length());
		String oidStr = DesUtil.desEncodeCBC(ConstProp.REPORT_KEY, oid);
		oidStr = URLEncoder.encode(oidStr,ConstProp.ENCODE_UTF8);
		url=url.substring(0, url.lastIndexOf('/'));
		url+="?pno="+oidStr;
		System.out.println(url);
		int width = 300;
		int height = 300;
		//二维码的图片格式
		String format = "jpg";
		Hashtable hints = new Hashtable();
		//内容所使用编码
		hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
		BitMatrix bitMatrix = new MultiFormatWriter().encode(url,
				BarcodeFormat.QR_CODE, width, height, hints);
		//生成二维码
		File outputFile = new File(path);
		ErweimaUtil.writeToFile(bitMatrix, format, outputFile);
   }

	/**
	 * 将内容生成二维码
	 * @param url
	 * @param path
	 * @throws Exception
	 */
	public static String createErWeiMaToBase64(String data) throws Exception{
		int width = 300;
		int height = 300;
		//二维码的图片格式
		String format = "jpg";
		Hashtable hints = new Hashtable();
		//内容所使用编码
		hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
		BitMatrix bitMatrix = new MultiFormatWriter().encode(data,
				BarcodeFormat.QR_CODE, width, height, hints);
		BufferedImage image = toBufferedImage(bitMatrix);
		return bufferedImageToBase64(image);
	}

	/**
	 * BufferedImage转base64
	 * @param bufferedImage
	 * @return
	 */
	private static String bufferedImageToBase64(BufferedImage bufferedImage) {
		try(ByteArrayOutputStream stream = new ByteArrayOutputStream()) {
			// 设置图片格式
			ImageIO.write(bufferedImage, "jpg", stream);
			byte[] bytes = Base64.encodeBase64(stream.toByteArray());
			String base64 = new String(bytes);
			return "data:image/jpeg;base64," + base64;
		} catch (IOException e) {
			e.printStackTrace();
		}
		return "";
	}
}
