package com.bcxin.ins.util;

import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.apache.commons.codec.binary.Base64;

import java.net.URLDecoder;


/**   
 * BASE64加密解密   
 */    
public class BASE64Util     
{     
    
    /**    
     * BASE64解密   
     * @param key          
     * @return          
     * @throws Exception          
     */
	public static String decryptBASE64(String key) throws Exception {               
        return new String(decryptBASE64Byte(key), "utf-8");            
    }
	
    public static byte[] decryptBASE64Byte(String key) throws Exception {   
    	return Base64.decodeBase64(key);
    } 
    
    /**    
     * BASE64解密   
     * @param key          
     * @return          
     * @throws Exception          
     */
	public static String decryptBASE64UrlDecode(String key) throws Exception {
		key = URLDecoder.decode(key, "utf-8");
        return new String(decryptBASE64Byte(key), "utf-8");            
    }
	
    /**         
     * BASE64加密   
     * @param key          
     * @return          
     * @throws Exception          
     */
    public static String encryptBASE64(String key) throws Exception { 
    	byte[] byteKey = key.getBytes("utf-8");
        return encryptBASE64Byte(byteKey).replaceAll("\r\n", "").replaceAll("\n", "");               
    }
    
    public static String encryptBASE64Byte(byte[] key) throws Exception {     
    	return Base64.encodeBase64String(key);
    }

    public static String getShareUrl(String pdid,String bsid) {
        String pUrl = GlobalResources.WEB_PRO_URL+"/insurance/product/productInfo/"+pdid;
        return shareProduct(bsid,pUrl);
    }

    private static String shareProduct(String resID,String path){
        String oidStr = "";
        if(StringUtils.isNotEmpty(resID)){
            try {
                oidStr = encryptBASE64(resID);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return path + "?recommendCode="+oidStr;
    }

    public static void main(String[] args) throws Exception     
    {     
     /*   String data = BASE64Util.encryptBASE64("867567017994493952");
        System.out.println("加密前："+data);*/
        String data = BASE64Util.encryptBASE64("867567017994493952");
        System.out.println("加密前："+data);
        String byteArray = BASE64Util.decryptBASE64(data);
        System.out.println("解密后："+byteArray);
    	/*String str = "PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI/Pgo8cG9saWN5U2FsZVJlcXVlc3Q+CiAgICA8YWRkcmVzc0xpbmVzPuWOpumXqOaAneaYjuWQjuWfrea6qui3rzI45Y+3MTHmpbwxMTEx5Y+3PC9hZGRyZXNzTGluZXM+CiAgICA8YmlydGhEYXRlPjE5ODQtMDgtMDM8L2JpcnRoRGF0ZT4KICAgIDxjb3JlQ29kZT5NWV9HQVNfMDAxPC9jb3JlQ29kZT4KICAgIDxjb3JlTmFtZT7mtYvor5Xnh4PmsJTpmak8L2NvcmVOYW1lPgogICAgPGVtYWlsPjg2OTk2OTBAcXEuY29tPC9lbWFpbD4KICAgIDxleHRlcm5hbFJlZmVyZW5jZT5NWV9HQVNfMDAxPC9leHRlcm5hbFJlZmVyZW5jZT4KICAgIDxmdWxsTmFtZT7otbXpo548L2Z1bGxOYW1lPgogICAgPGdlbmRlcj5NPC9nZW5kZXI+CiAgICA8aWROdW1iZXI+MjEwMTEzMTk4NDA4MDMxNjU2PC9pZE51bWJlcj4KICAgIDxpZFR5cGU+SURDQVJEPC9pZFR5cGU+CiAgICA8aW5zdXJhbmNlQ29tcGFueUNvZGU+QUlHPC9pbnN1cmFuY2VDb21wYW55Q29kZT4KICAgIDxpbnN1cmVkcz4KICAgICAgICA8YWRkcmVzc0xpbmVzPuWOpumXqOaAneaYjuWQjuWfrea6qui3rzI45Y+3MTHmpbwxMTEx5Y+3PC9hZGRyZXNzTGluZXM+CiAgICAgICAgPGJpcnRoRGF0ZT4xOTg0LTA4LTAzPC9iaXJ0aERhdGU+CiAgICAgICAgPGVtYWlsPjg2OTk2OTBAcXEuY29tPC9lbWFpbD4KICAgICAgICA8ZnVsbE5hbWU+6LW16aOePC9mdWxsTmFtZT4KICAgICAgICA8Z2VuZGVyPk08L2dlbmRlcj4KICAgICAgICA8aWROdW1iZXI+MjEwMTEzMTk4NDA4MDMxNjU2PC9pZE51bWJlcj4KICAgICAgICA8aWRUeXBlPklEQ0FSRDwvaWRUeXBlPgogICAgICAgIDxtb2JpbGVOdW1iZXI+MTg2MTE5OTk1MDU8L21vYmlsZU51bWJlcj4KICAgIDwvaW5zdXJlZHM+CiAgICA8bG9naW5OYW1lPmFkbWluPC9sb2dpbk5hbWU+CiAgICA8bW9iaWxlTnVtYmVyPjE4NjExOTk5NTA1PC9tb2JpbGVOdW1iZXI+CiAgICA8cHJvZHVjdFR5cGU+TElGRTwvcHJvZHVjdFR5cGU+CjwvcG9saWN5U2FsZVJlcXVlc3Q+Cg==";
    	String out = str.replace("+", "%2B");
    	System.out.println(out);*/
    }     
}
