package com.bcxin.ins.enums;

/**
 * 批改状态枚举
 * @author hzp
 * @date 2018/06/12
 */
public enum ReviseStatusEnum {

    //废弃
    DISCARD("0","废弃"),
    //待提交
    UN_SUBMIT("1","待提交"),
    //待审核
    CHECKING("2","待审核"),
    //审核退回
    BACK("3","审核退回"),
    //已审核
    CHECKED("4","已审核"),
    //已生效
    EFFECTED("5","已生效");

    private String key;
    private String alias;

    private ReviseStatusEnum(String key,String alias){
        this.key=key;
        this.alias=alias;
    }

    public String getKey() {
        return this.key;
    }

    public String getAlias(){
        return this.alias;
    }

    public static String getAlias(String key){
        for(ReviseStatusEnum e : ReviseStatusEnum.values()){
            if(e.getKey().equals(key)){
                return e.getAlias();
            }
        }
        return "";
    }
}
