package com.bcxin.ins.entity.policy_core;

import com.bcxin.ins.core.entity.SysCompany;
import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.mybatisplus.annotations.TableField;
import com.bcxin.mybatisplus.annotations.TableId;
import com.bcxin.mybatisplus.annotations.TableName;
import com.bcxin.mybatisplus.enums.IdType;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <b> 订单对账记录（保单/批改单） </b>
 * @author ZXF
 * @create 2024/05/10 0010 17:41
 * @version
 * @注意事项 </b>
 */
@Data
@TableName("ins_order_reconciliation")
public class InsOrderReconciliation implements Serializable {

    @TableField(value = "ins_order_reconciliation_id")
    private String ins_order_reconciliation_id;//ID规则：保单号+批单号

    @TableField(value = "supplier")
    private String supplier;//供应商标识

    @TableField(value = "external_reference")
    private String external_reference;//保单号

    @TableField(value = "revise_serial_num_ins")
    private String revise_serial_num_ins;//批单号

    @TableField(value = "residue_day")
    private int residue_day;//保险期限

    @TableField(value = "insure_date")
    private int insure_date;//投保日期

    @TableField(value = "insure_name")
    private String insure_name;//投保人

    @TableField(value = "assured_name")
    private String assured_name;//被保险人

    @TableField(value = "insure_num")
    private int insure_num;//投保人数

    @TableField(value = "premium")
    private BigDecimal premium;//保费

    public InsOrderReconciliation(String supplier, String external_reference, String revise_serial_num_ins, int residue_day, int insure_date, String insure_name, String assured_name, int insure_num, BigDecimal premium) {
        this.supplier = supplier;
        this.external_reference = external_reference;
        this.revise_serial_num_ins = revise_serial_num_ins;
        this.residue_day = residue_day;
        this.insure_date = insure_date;
        this.insure_name = insure_name;
        this.assured_name = assured_name;
        this.insure_num = insure_num;
        this.premium = premium;
        this.ins_order_reconciliation_id = external_reference + revise_serial_num_ins;
    }
}