package com.bcxin.ins.entity.policy_core;

import com.bcxin.ins.core.entity.SysCompany;
import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.mybatisplus.annotations.TableField;
import com.bcxin.mybatisplus.annotations.TableId;
import com.bcxin.mybatisplus.annotations.TableName;
import com.bcxin.mybatisplus.enums.IdType;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
/**
 * <b>保单主表 </b>
 *
 * @author zxf
 * @date 2017年1月5日 上午10:12:23
 * @注意事项 </b>
 * <b>
 */
@TableName("ins_agreement")
public class InsAgreement implements Serializable {

    @TableId(type = IdType.ID_WORKER)
    private Long ins_agreement_id;

    @TableField(value = "remarks")
    private String remarks;	// 备注

    @TableField(value = "create_by",el="create_by.id")
    private SysUser create_by;	// 创建者

    @TableField(value = "create_time")
    private Date create_time;	// 创建日期

    @TableField(value = "update_by",el="update_by.id")
    private SysUser update_by;	// 更新者

    @TableField(value = "update_time")
    private Date update_time;	// 更新日期

    @TableField(value = "status")
    protected Integer status; 	//

    @TableField(value = "company_id",el="sysCompany.company_id")
    protected SysCompany sysCompany;

    @TableField(value = "external_reference")
    private String external_reference;

    /**
     * 产品
     */
    @TableField(value = "pro_primary_id",el="pro_primary.pro_primary_id")
    private ProPrimary pro_primary;

    @TableField(value = "premium")
    private BigDecimal premium;

    @TableField(value = "rate")
    private BigDecimal rate;

    @TableField(value = "unit_count")
    private Integer unit_count;

    @TableField(value = "inception_date")
    private Date inception_date;

    @TableField(value = "planned_end_date")
    private Date planned_end_date;

    @TableField(value = "signed_date")
    private Date signed_date;

    @TableField(value = "mail_policy_id")
    private Long mail_policy_id;

    @TableField(value = "register_user_id")
    private Long register_user_id;

    @TableField(value = "classify")
    private String classify;

    @TableField(value = "special_id")
    private Long special_id;

    @TableField(value = "user_insure_path")
    private String user_insure_path;

    @TableField(value = "insure_path")
    private String insure_path;

    @TableField(value = "lg_path")
    private String lg_path;

    @TableField(value = "province")
    private String province;

    @TableField(value = "city")
    private String city;

    @TableField(value = "area_code")
    private String area_code;

    /**
     * 固化当前承保保障责任
     */
    @TableField(value = "responsibility_ids")
    private String responsibility_ids;

    /**
     * 投保单表
     */
    @TableField(value = "ins_insurance_slip_id",el="ins_insurance_slip.ins_insurance_slip_id")
    private InsInsuranceSlip ins_insurance_slip;

    public Long getIns_agreement_id() {
        return ins_agreement_id;
    }

    public void setIns_agreement_id(Long ins_agreement_id) {
        this.ins_agreement_id = ins_agreement_id;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public SysUser getCreate_by() {
        return create_by;
    }

    public void setCreate_by(SysUser create_by) {
        this.create_by = create_by;
    }
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getCreate_time() {
        return create_time;
    }

    public void setCreate_time(Date create_time) {
        this.create_time = create_time;
    }

    public SysUser getUpdate_by() {
        return update_by;
    }

    public void setUpdate_by(SysUser update_by) {
        this.update_by = update_by;
    }
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getUpdate_time() {
        return update_time;
    }

    public void setUpdate_time(Date update_time) {
        this.update_time = update_time;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public SysCompany getSysCompany() {
        return sysCompany;
    }

    public void setSysCompany(SysCompany sysCompany) {
        this.sysCompany = sysCompany;
    }

    public String getExternal_reference() {
        return external_reference;
    }

    public void setExternal_reference(String external_reference) {
        this.external_reference = external_reference;
    }

    public ProPrimary getPro_primary() {
        return pro_primary;
    }

    public void setPro_primary(ProPrimary pro_primary) {
        this.pro_primary = pro_primary;
    }

    public BigDecimal getPremium() {
        return premium;
    }

    public void setPremium(BigDecimal premium) {
        this.premium = premium;
    }

    public BigDecimal getRate() {
        return rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public Integer getUnit_count() {
        return unit_count;
    }

    public void setUnit_count(Integer unit_count) {
        this.unit_count = unit_count;
    }
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getInception_date() {
        return inception_date;
    }

    public void setInception_date(Date inception_date) {
        this.inception_date = inception_date;
    }
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getPlanned_end_date() {
        return planned_end_date;
    }

    public void setPlanned_end_date(Date planned_end_date) {
        this.planned_end_date = planned_end_date;
    }
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getSigned_date() {
        return signed_date;
    }

    public void setSigned_date(Date signed_date) {
        this.signed_date = signed_date;
    }

    public Long getMail_policy_id() {
        return mail_policy_id;
    }

    public void setMail_policy_id(Long mail_policy_id) {
        this.mail_policy_id = mail_policy_id;
    }

    public Long getRegister_user_id() {
        return register_user_id;
    }

    public void setRegister_user_id(Long register_user_id) {
        this.register_user_id = register_user_id;
    }

    public String getClassify() {
        return classify;
    }

    public void setClassify(String classify) {
        this.classify = classify;
    }

    public Long getSpecial_id() {
        return special_id;
    }

    public void setSpecial_id(Long special_id) {
        this.special_id = special_id;
    }

    public String getUser_insure_path() {
        return user_insure_path;
    }

    public void setUser_insure_path(String user_insure_path) {
        this.user_insure_path = user_insure_path;
    }

    public String getInsure_path() {
        return insure_path;
    }

    public void setInsure_path(String insure_path) {
        this.insure_path = insure_path;
    }

    public String getLg_path() {
        return lg_path;
    }

    public void setLg_path(String lg_path) {
        this.lg_path = lg_path;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getArea_code() {
        return area_code;
    }

    public void setArea_code(String area_code) {
        this.area_code = area_code;
    }

    public InsInsuranceSlip getIns_insurance_slip() {
        return ins_insurance_slip;
    }

    public void setIns_insurance_slip(InsInsuranceSlip ins_insurance_slip) {
        this.ins_insurance_slip = ins_insurance_slip;
    }

    public String getResponsibility_ids() {
        return responsibility_ids;
    }

    public void setResponsibility_ids(String responsibility_ids) {
        this.responsibility_ids = responsibility_ids;
    }
}