package com.bcxin.ins.vo.report_pac;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * <b> 平安财银行名称及编码 </b>
 * @author ZXF
 * @create 2019/11/11 0011 14:40
 * @version
 * @注意事项 </b>
 */
public class ReportCodeVo implements Serializable {

    /*
    * 平安财
    */
    private static String PAC = "PAC";
    /*
     * 长安
     */
    private static String CA = "CA";

    /*
    * 银行名称编码
    */
    private List<Map<String,String>> bankList;
    /*
    * 出险原因编码
    */
    private List<Map<String,String>> cxyyList;

    /**
     * <b> 根据类型调用不同的初始化，以后用于扩展 </b>
     * @author ZXF
     * @create 2019/11/11 0011 15:53
     * @version
     * @注意事项 </b>
     */
    public ReportCodeVo(String insType){
        insType = StringUtils.isEmpty(insType)?PAC:insType;
        if(PAC.equals(insType)){
            bankPAC();
            cxyyPAC();
        }else if(CA.equals(insType)){
            bankPAC();
            cxyyCA();
        }
    }

    public List<Map<String, String>> getBankList() {
        return bankList;
    }

    public void setBankList(List<Map<String, String>> bankList) {
        this.bankList = bankList;
    }

    public List<Map<String, String>> getCxyyList() {
        return cxyyList;
    }

    public void setCxyyList(List<Map<String, String>> cxyyList) {
        this.cxyyList = cxyyList;
    }

    /**
     * <b> 平安 出险原因初始列表数据 </b>
     * @author ZXF
     * @create 2019/11/11 0011 15:54
     * @version
     * @注意事项 </b>
     */
    public void cxyyPAC(){
        List<Map<String,String>> mapList = Lists.newArrayList();
        setCxyyPACMap("A01","意外伤害事故","",mapList);
        setCxyyPACMap("A06","疾病","",mapList);
        setCxyyPACMap("N0298","外来暴力侵害事故","A01",mapList);
        setCxyyPACMap("N0092","电、光、火、热、腐蚀、蒸气引起的事故","A01",mapList);
        setCxyyPACMap("N0101","动物咬伤、抓伤等伤害","A01",mapList);
        setCxyyPACMap("N0127","工作场所内摔倒","A01",mapList);
        setCxyyPACMap("N0211","溺水、触电、烧、烫伤","A01",mapList);
        setCxyyPACMap("N0227","器械事故","A01",mapList);
        setCxyyPACMap("N0250","上下班途中","A01",mapList);
        setCxyyPACMap("N0252","烧、烫伤","A01",mapList);
        setCxyyPACMap("N0263","食物中毒","A01",mapList);
        setCxyyPACMap("N0364","运动、社会、文娱活动","A01",mapList);
        setCxyyPACMap("N0397","坠落、摔倒、滑倒","A01",mapList);
        setCxyyPACMap("N0226","其他意外事故","A01",mapList);
        setCxyyPACMap("N0079","猝死","A06",mapList);
        setCxyyPACMap("N0379","职业病","A06",mapList);
        setCxyyPACMap("N0417","其他疾病","A06",mapList);
        this.setCxyyList(mapList);
    }

    /**
     * <b> 长安 出险原因初始列表数据 </b>
     * @author ZXF
     * @create 2019/11/11 0011 15:54
     * @version
     * @注意事项 </b>
     */
    public void cxyyCA(){
        List<Map<String,String>> mapList = Lists.newArrayList();
        setCxyyPACMap("101","雷电","",mapList);
        setCxyyPACMap("102","飓风","",mapList);
        setCxyyPACMap("103","台风","",mapList);
        setCxyyPACMap("104","龙卷风","",mapList);
        setCxyyPACMap("105","风暴","",mapList);
        setCxyyPACMap("106","暴雨","",mapList);
        setCxyyPACMap("107","洪水","",mapList);
        setCxyyPACMap("108","水灾","",mapList);
        setCxyyPACMap("109","冰雹、雹灾","",mapList);
        setCxyyPACMap("110","冻灾","",mapList);
        setCxyyPACMap("111","山崩、地崩、崖崩","",mapList);
        setCxyyPACMap("112","火山爆发","",mapList);
        setCxyyPACMap("113","温差变化、冻灾、旱灾","",mapList);
        setCxyyPACMap("114","泥石流","",mapList);
        setCxyyPACMap("115","突发性滑坡","",mapList);
        setCxyyPACMap("116","滑坡","",mapList);
        setCxyyPACMap("117","冰凌、凌汛","",mapList);
        setCxyyPACMap("118","地震","",mapList);
        setCxyyPACMap("119","海啸","",mapList);
        setCxyyPACMap("120","海侵","",mapList);
        setCxyyPACMap("121","海潮","",mapList);
        setCxyyPACMap("122","地面突然下陷","",mapList);
        setCxyyPACMap("123","其它自然灾害","",mapList);
        setCxyyPACMap("201","火灾","",mapList);
        setCxyyPACMap("202","爆炸","",mapList);
        setCxyyPACMap("203","空中运行物体坠落","",mapList);
        setCxyyPACMap("204","碰撞","",mapList);
        setCxyyPACMap("205","倾覆、倒塌","",mapList);
        setCxyyPACMap("206","水管、水箱爆裂、水灾（水浸）","",mapList);
        setCxyyPACMap("207","爆裂、断裂","",mapList);
        setCxyyPACMap("208","短路、“三停”、电器意外","",mapList);
        setCxyyPACMap("209","渗漏、沾污、污染","",mapList);
        setCxyyPACMap("210","自然磨损、氧化、腐蚀、锈蚀、孔蚀、锅垢","",mapList);
        setCxyyPACMap("211","负压变形、负压爆炸","",mapList);
        setCxyyPACMap("212","自燃、阴燃","",mapList);
        setCxyyPACMap("213","其它意外事故","",mapList);
        setCxyyPACMap("301","盗窃","",mapList);
        setCxyyPACMap("302","抢夺","",mapList);
        setCxyyPACMap("303","抢劫","",mapList);
        setCxyyPACMap("304","恶意行为","",mapList);
        setCxyyPACMap("305","贪污、挪用、携款潜逃","",mapList);
        setCxyyPACMap("306","信用卡透支","",mapList);
        setCxyyPACMap("307","信用卡盗用","",mapList);
        setCxyyPACMap("308","信用卡欺诈交易","",mapList);
        setCxyyPACMap("309","其它人为因素风险","",mapList);
        setCxyyPACMap("401","战争、军事冲突","",mapList);
        setCxyyPACMap("402","类似战争行为、政变","",mapList);
        setCxyyPACMap("403","罢工、暴动、民众骚乱","",mapList);
        setCxyyPACMap("404","恐怖行为","",mapList);
        setCxyyPACMap("405","政府罚没、接管","",mapList);
        setCxyyPACMap("406","外汇管制","",mapList);
        setCxyyPACMap("407","其他政治风险","",mapList);
        this.setCxyyList(mapList);
    }

    private void setCxyyPACMap(String code, String cause, String parentCode, List<Map<String,String>> mapList){
        Map<String,String> map = Maps.newHashMap();
        map.put("accidentCode",code);
        map.put("accidentCause",cause);
        map.put("parentCode",parentCode);
        mapList.add(map);
    }

    /**
     * <b> 根据出险原因编码获取原因内容 </b>
     * @author ZXF
     * @create 2019/12/05 0005 17:46
     * @version
     * @注意事项 </b>
     */
    public String getCxyyName(String code){
        for (Map<String,String> map:cxyyList) {
            if(map.get("accidentCode").equals(code)){
                return map.get("accidentCause");
            }
        }
        return "";
    }

    /**
     * <b> 银行名称和代码列表数据 </b>
     * @author ZXF
     * @create 2019/11/11 0011 15:54
     * @version
     * @注意事项 </b>
     */
    public void bankPAC(){
        String json = "{\n" +
                "    \"bankList\": [\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"102\",\n" +
                "            \"bankTypeName\": \"中国工商银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"104\",\n" +
                "            \"bankTypeName\": \"中国银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"308\",\n" +
                "            \"bankTypeName\": \"招商银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"301\",\n" +
                "            \"bankTypeName\": \"交通银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"A00\",\n" +
                "            \"bankTypeName\": \"平安银行(原平安)\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"303\",\n" +
                "            \"bankTypeName\": \"中国光大银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"310\",\n" +
                "            \"bankTypeName\": \"上海浦东发展银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"306\",\n" +
                "            \"bankTypeName\": \"广发银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"A01\",\n" +
                "            \"bankTypeName\": \"上海银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"305\",\n" +
                "            \"bankTypeName\": \"中国民生银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"309\",\n" +
                "            \"bankTypeName\": \"兴业银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"314\",\n" +
                "            \"bankTypeName\": \"农村商业银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"307\",\n" +
                "            \"bankTypeName\": \"平安银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"304\",\n" +
                "            \"bankTypeName\": \"华夏银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"319\",\n" +
                "            \"bankTypeName\": \"徽商银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"A05\",\n" +
                "            \"bankTypeName\": \"江苏银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"A63\",\n" +
                "            \"bankTypeName\": \"哈尔滨银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"C20\",\n" +
                "            \"bankTypeName\": \"德阳银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"A02\",\n" +
                "            \"bankTypeName\": \"北京银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"C04\",\n" +
                "            \"bankTypeName\": \"东莞银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"A03\",\n" +
                "            \"bankTypeName\": \"宁波银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"B89\",\n" +
                "            \"bankTypeName\": \"广州银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"C45\",\n" +
                "            \"bankTypeName\": \"富滇银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"A07\",\n" +
                "            \"bankTypeName\": \"天津银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"318\",\n" +
                "            \"bankTypeName\": \"渤海银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"C16\",\n" +
                "            \"bankTypeName\": \"重庆银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"A06\",\n" +
                "            \"bankTypeName\": \"杭州银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"A55\",\n" +
                "            \"bankTypeName\": \"吉林银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"C06\",\n" +
                "            \"bankTypeName\": \"广西北部湾银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"A42\",\n" +
                "            \"bankTypeName\": \"大连银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"B65\",\n" +
                "            \"bankTypeName\": \"长沙银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"402\",\n" +
                "            \"bankTypeName\": \"农村信用联社\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"D02\",\n" +
                "            \"bankTypeName\": \"乌鲁木齐市商业银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"C36\",\n" +
                "            \"bankTypeName\": \"贵阳银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"A76\",\n" +
                "            \"bankTypeName\": \"南京银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"B53\",\n" +
                "            \"bankTypeName\": \"汉口银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"A86\",\n" +
                "            \"bankTypeName\": \"台州银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"C21\",\n" +
                "            \"bankTypeName\": \"绵阳市商业银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"D29\",\n" +
                "            \"bankTypeName\": \"龙江银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"A08\",\n" +
                "            \"bankTypeName\": \"河北银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"B10\",\n" +
                "            \"bankTypeName\": \"南昌银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"D28\",\n" +
                "            \"bankTypeName\": \"宁夏银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"B26\",\n" +
                "            \"bankTypeName\": \"烟台银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"C78\",\n" +
                "            \"bankTypeName\": \"兰州银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"316\",\n" +
                "            \"bankTypeName\": \"浙商银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"B36\",\n" +
                "            \"bankTypeName\": \"郑州银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"A47\",\n" +
                "            \"bankTypeName\": \"锦州银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"315\",\n" +
                "            \"bankTypeName\": \"恒丰银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"A48\",\n" +
                "            \"bankTypeName\": \"营口银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"A19\",\n" +
                "            \"bankTypeName\": \"晋商银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"D26\",\n" +
                "            \"bankTypeName\": \"浙江泰隆商业银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"B22\",\n" +
                "            \"bankTypeName\": \"青岛银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"C92\",\n" +
                "            \"bankTypeName\": \"青海银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"B30\",\n" +
                "            \"bankTypeName\": \"威海银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"C18\",\n" +
                "            \"bankTypeName\": \"攀枝花市商业银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"B25\",\n" +
                "            \"bankTypeName\": \"东营银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"D21\",\n" +
                "            \"bankTypeName\": \"日照银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"D03\",\n" +
                "            \"bankTypeName\": \"昆仑银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"B23\",\n" +
                "            \"bankTypeName\": \"齐商银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"A14\",\n" +
                "            \"bankTypeName\": \"张家口市商业银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"B27\",\n" +
                "            \"bankTypeName\": \"潍坊银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"B01\",\n" +
                "            \"bankTypeName\": \"海峡银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"A31\",\n" +
                "            \"bankTypeName\": \"包包典当\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"B34\",\n" +
                "            \"bankTypeName\": \"临商银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"C07\",\n" +
                "            \"bankTypeName\": \"柳州银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"D22\",\n" +
                "            \"bankTypeName\": \"葫芦岛银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"B28\",\n" +
                "            \"bankTypeName\": \"济宁银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"B02\",\n" +
                "            \"bankTypeName\": \"厦门银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"A11\",\n" +
                "            \"bankTypeName\": \"邯郸银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"B16\",\n" +
                "            \"bankTypeName\": \"赣州银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"A23\",\n" +
                "            \"bankTypeName\": \"晋城银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"B18\",\n" +
                "            \"bankTypeName\": \"上饶银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"B29\",\n" +
                "            \"bankTypeName\": \"泰安市商业银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"A30\",\n" +
                "            \"bankTypeName\": \"内蒙古银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"105\",\n" +
                "            \"bankTypeName\": \"中国建设银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"103\",\n" +
                "            \"bankTypeName\": \"中国农业银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"D25\",\n" +
                "            \"bankTypeName\": \"浙江民泰商业银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"B38\",\n" +
                "            \"bankTypeName\": \"洛阳银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"A81\",\n" +
                "            \"bankTypeName\": \"绍兴银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"A16\",\n" +
                "            \"bankTypeName\": \"沧州银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"B32\",\n" +
                "            \"bankTypeName\": \"德州银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"A80\",\n" +
                "            \"bankTypeName\": \"湖州银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"A49\",\n" +
                "            \"bankTypeName\": \"阜新银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"D30\",\n" +
                "            \"bankTypeName\": \"苏州银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"A78\",\n" +
                "            \"bankTypeName\": \"温州银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"B51\",\n" +
                "            \"bankTypeName\": \"南阳市商业银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"B48\",\n" +
                "            \"bankTypeName\": \"商丘银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"A15\",\n" +
                "            \"bankTypeName\": \"承德银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"A12\",\n" +
                "            \"bankTypeName\": \"邢台银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"B37\",\n" +
                "            \"bankTypeName\": \"开封市商业银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"B46\",\n" +
                "            \"bankTypeName\": \"漯河银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"A39\",\n" +
                "            \"bankTypeName\": \"鄂尔多斯银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"595\",\n" +
                "            \"bankTypeName\": \"韩国新韩银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"596\",\n" +
                "            \"bankTypeName\": \"韩国中小企业银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"597\",\n" +
                "            \"bankTypeName\": \"韩亚银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"591\",\n" +
                "            \"bankTypeName\": \"韩国外换银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"D23\",\n" +
                "            \"bankTypeName\": \"莱商银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"D32\",\n" +
                "            \"bankTypeName\": \"浙江稠州商业银行\"\n" +
                "        },\n" +
                "        {\n" +
                "            \"bankTypeCode\": \"798\",\n" +
                "            \"bankTypeName\": \"鄞州银行\"\n" +
                "        }\n" +
                "    ]\n" +
                "}";
        JSONObject bankJson = JSONObject.parseObject(json);
        JSONArray bankList = JSONArray.parseArray(String.valueOf(bankJson.get("bankList")));
        Map<String,String> bank = null;
        List<Map<String,String>> mapList = Lists.newArrayList();
        for (Object j:bankList) {
            bank = JSONObject.parseObject(String.valueOf(j),Map.class);
            mapList.add(bank);
        }
        this.setBankList(mapList);
    }
}
