package com.bcxin.ins.vo.excel;

import com.bcxin.ins.util.excel.ExcelVOAttribute;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.math.BigDecimal;

public class RecordSuccessExcelVo implements Serializable {

	@ExcelVOAttribute(name = "保单号", column = "A", isExport = true, isRequest = true)
	private String external_reference;

	@ExcelVOAttribute(name = "姓名", column = "B", isExport = true, isRequest = true)
	private String name;

	@ExcelVOAttribute(name = "身份证", column = "C", isExport = true, isRequest = true)
	private String id_card;

	@ExcelVOAttribute(name = "类型", column = "D", isExport = true, isRequest = true)
	private String revise_type;

	@ExcelVOAttribute(name = "生效日期", column = "E", isExport = true, isRequest = true)
	private String inception_date;

	@ExcelVOAttribute(name = "失效日期", column = "F", isExport = true, isRequest = true)
	private String planned_end_date;

	@ExcelVOAttribute(name = "保全天数", column = "G", isExport = true, isRequest = true)
	private String validDay;

	@ExcelVOAttribute(name = "原始保费", column = "H", isExport = true, isRequest = true)
	private String premium;

	@ExcelVOAttribute(name = "投保人", column = "I", isExport = true, isRequest = true)
	private String comName;

	@ExcelVOAttribute(name = "单价", column = "J", isExport = true, isRequest = true)
	private String amount;

	@ExcelVOAttribute(name = "批单号", column = "K", isExport = true, isRequest = false)
	private String revise_serial_num;

	@ExcelVOAttribute(name = "批单总额", column = "L", isExport = true, isRequest = false)
	private String total_premium;

	@ExcelVOAttribute(name = "备注", column = "M", isExport = true, isRequest = false)
	private String remarks;


	/**
	 * 替减数据（替换时被替换的那个人）
	 */
	private String tjData;

	/**
	 * 导入的错误信息
	 */
	private String errorMsg;

	public RecordSuccessExcelVo(){}

	public RecordSuccessExcelVo(
			String external_reference
			, String comName
			, String name
			, String id_card
			, String inception_date
			, String planned_end_date
			, String validDay
			, String revise_type
			, String amount, String premium, String tjData, String revise_serial_num, String total_premium, String remarks){
		this.external_reference = external_reference;
		this.name = name;
		this.id_card = id_card;
		this.revise_type = revise_type;
		this.inception_date = inception_date;
		this.planned_end_date = planned_end_date;
		this.validDay = validDay;
		this.comName = comName;
		this.amount = amount;
		this.tjData = tjData;
		this.premium = premium;
		this.revise_serial_num = revise_serial_num;
		this.total_premium = total_premium;
		this.remarks = remarks;
	}

	public String getExternal_reference() {
		return external_reference;
	}

	public void setExternal_reference(String external_reference) {
		this.external_reference = external_reference;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getId_card() {
		return id_card;
	}

	public void setId_card(String id_card) {
		this.id_card = id_card;
	}

	public String getRevise_type() {
		return revise_type;
	}

	public void setRevise_type(String revise_type) {
		this.revise_type = revise_type;
	}

	public String getInception_date() {
		return inception_date;
	}

	public void setInception_date(String inception_date) {
		this.inception_date = inception_date;
	}

	public String getPlanned_end_date() {
		return planned_end_date;
	}

	public void setPlanned_end_date(String planned_end_date) {
		this.planned_end_date = planned_end_date;
	}

	public String getValidDay() {
		return validDay;
	}

	public void setValidDay(String validDay) {
		this.validDay = validDay;
	}

	public String getPremium() {
		return premium;
	}

	public void setPremium(String premium) {
		this.premium = premium;
	}

	public String getComName() {
		return comName;
	}

	public void setComName(String comName) {
		this.comName = comName;
	}

	public String getAmount() {
		return amount;
	}

	public void setAmount(String amount) {
		this.amount = amount;
	}

	public String getTjData() {
		return tjData;
	}

	public void setTjData(String tjData) {
		this.tjData = tjData;
	}

	public String getRevise_serial_num() {
		return revise_serial_num;
	}

	public void setRevise_serial_num(String revise_serial_num) {
		this.revise_serial_num = revise_serial_num;
	}

	public String getTotal_premium() {
		return total_premium;
	}

	public void setTotal_premium(String total_premium) {
		this.total_premium = total_premium;
	}

	public String getRemarks() {
		return remarks;
	}

	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}

	public String getErrorMsg() {
		if (StringUtils.isNotEmpty(errorMsg)) {
			return errorMsg;
		} else {
			return "";
		}
	}

	public void setErrorMsg(String errorMsg) {
		this.errorMsg = errorMsg;
	}
}
