package com.bcxin.ins.vo.excel;

import com.bcxin.ins.util.excel.ExcelVOAttribute;
import lombok.Data;

import java.io.Serializable;

/**
 * 保全缴费表
 */
@Data
public class InsPreservationSettlementExcelVo implements Serializable {


    /**
     * 结算单号
     */
    @ExcelVOAttribute(name = "结算单号", column = "A", isExport = true, isRequest = true)
    private String external_reference;

    /**
     * 保险公司名称
     */
    @ExcelVOAttribute(name = "保险公司", column = "B", isExport = true, isRequest = true)
    private String company_name;
    /**
     * 结算单数
     */
    @ExcelVOAttribute(name = "结算单数", column = "C", isExport = true, isRequest = true)
    private String record_count;
    /**
     * 结算金额
     */
    @ExcelVOAttribute(name = "结算金额", column = "D", isExport = true, isRequest = true)
    private String fact_total_amount;

    /**
     * 结算生成时间
     */
    @ExcelVOAttribute(name = "结算生成时间", column = "E", isExport = true, isRequest = true)
    private String build_data;

    /**
     * 结算状态:已结算
     */
    @ExcelVOAttribute(name = "结算状态", column = "F", isExport = true, isRequest = true)
    private String pay_status;

    public InsPreservationSettlementExcelVo(){

    }

    public InsPreservationSettlementExcelVo(String external_reference, String company_name, String record_count, String fact_total_amount, String build_data, String pay_status){
        this.external_reference = external_reference;
        this.company_name = company_name;
        this.record_count = record_count;
        this.fact_total_amount = fact_total_amount;
        this.build_data = build_data;
        this.pay_status = pay_status;
    }
}