package com.bcxin.ins.vo.excel;

import com.bcxin.ins.util.excel.ExcelVOAttribute;
import com.bcxin.ins.vo.BaseVo;
import com.bcxin.ins.vo.InsPreservationRecordVo;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 保全缴费表
 */
@Data
public class InsPreservationPayExcelVo implements Serializable {


    /**
     * 账单编号
     */
    @ExcelVOAttribute(name = "账单编号", column = "A", isExport = true, isRequest = true)
    private String external_reference;

    /**
     * 保险公司名称
     */
    @ExcelVOAttribute(name = "保险公司", column = "B", isExport = true, isRequest = true)
    private String company_name;
    /**
     * 投保人名称
     */
    @ExcelVOAttribute(name = "投保人", column = "C", isExport = true, isRequest = false)
    private String app_role_name;
    /**
     * 保全单数
     */
    @ExcelVOAttribute(name = "保全单数", column = "D", isExport = true, isRequest = true)
    private String record_count;
    /**
     * 预期总保费
     */
    @ExcelVOAttribute(name = "保全金额", column = "E", isExport = true, isRequest = true)
    private String predict_total_amount;

    /**
     * 开始日期
     */
    @ExcelVOAttribute(name = "开始日期", column = "F", isExport = true, isRequest = true)
    private String star_pay_time;
    /**
     * 结束日期
     */
    @ExcelVOAttribute(name = "结束日期", column = "G", isExport = true, isRequest = true)
    private String end_pay_time;

    /**
     * 生成日期
     */
    @ExcelVOAttribute(name = "生成日期", column = "H", isExport = true, isRequest = true)
    private String build_data;

    /**
     * 付款状态0.待处理；1.待支付；2.待审核；3.已支付；4.暂存
     */
    @ExcelVOAttribute(name = "缴费状态", column = "I", isExport = true, isRequest = true)
    private String pay_status;

    /**
     * 是否归属部分账单
     */
    @ExcelVOAttribute(name = "账单类型", column = "J", isExport = true, isRequest = true)
    private String bill_type;
    /**
     * 是否申请发票
     */
    @ExcelVOAttribute(name = "发票申请", column = "K", isExport = true, isRequest = true)
    private String is_fp;

    public InsPreservationPayExcelVo(){

    }

    public InsPreservationPayExcelVo (String external_reference, String company_name, String app_role_name, String record_count, String predict_total_amount, String star_pay_time, String end_pay_time, String build_data, String pay_status, String bill_type, String is_fp){
        this.external_reference = external_reference;
        this.company_name = company_name;
        this.app_role_name = app_role_name;
        this.record_count = record_count;
        this.predict_total_amount = predict_total_amount;
        this.star_pay_time = star_pay_time;
        this.end_pay_time = end_pay_time;
        this.build_data = build_data;
        this.pay_status = pay_status;
        this.bill_type = bill_type;
        this.is_fp = is_fp;
    }
}