package com.bcxin.ins.vo;

import com.bcxin.ins.util.GlobalResources;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * <b>订单基础字段信息辅助表 </b>
 * 
 * @author zxf
 * @date 2017年1月19日 下午2:49:13
 * @注意事项 </b>
 * <b>
 */
public class OrderFormVo extends BaseVo{

	private String oid;//订单id
	private String trade_serial_number;//订单编号
	private String pay_order_number;//支付凭证号
	private String pay_order_url;//支付凭证地址
	private String policy_serial_number;//投保单号
	private String notice_no;//通知单号
	private String external_reference;//保单号
	private String show_url;//支付地址
	private String product_name;//产品名称  来自：InsProduct
	private String insurance_name;//保险公司名称
	private String insurance_oid;//保险公司id
	private String insurance_logo;//保险公司logo
	private String start_time;//订单开始时间
	private String inception_date;//生效日期
	private String planned_end_date;//失效日期
	private String premium;//每人保费
	private String gross_premium;//保费
	private String amount;//每人保额
	private String insured_amount;//保额
	private String policy_status;//订单状态
	private String product_oid;//产品id  来自：InsProductgg
	private String product_code;//产品类型代码  来自：InsProduct
	private String classify_name;//产品分类名称
	private String product_type;//产品类型
	private String applicant_name;//投保人名称
	private String insured_role;//被保险人
	private String fees_for;//收费要求(1.承保前收费2.承保后收费)来自：InsProductgg
	private String pay_methods;//缴费方式(1.一次性2.分期) 来自：InsProductgg
	private String inception_type;//保障类型(1.按年2.按月)
	private String inception_long;//保障长度
	private String policy_currency;//保单币种
	private String business_scope;//承保经营范围
	private String remarks;//拒保备注
	private String customRemarks;//自定义备注
	private String user_oid;//下单用户id
	private String web_type;//下单用户平台标识(先查订单上的标识是否有值，有的话直接取，没有的话再找用户记录上的标识)
	private String web_id;//下单用户对应平台企业Id
	private String login_name;//下单账号
	private String user_insure_path;//用户盖章上传的投保单下载地址
	private String insure_path;//电子保单下载地址
	private String lg_path;//电子保函下载地址
	private String reseller_name;//所属分销商名称
	private String is_send_yx;//是否已成功发送影像信息(默认0否，1是，目前小微产品用到)
	private String is_policy_before_pay_fee;//是否见费，0非见费，1见费
	private String is_contain_repo;//是否包含可选保障责任
	private String source;//供应来源标识（DEF 默认,YT 亚太,ZY 中元）
	private String headurl;//根据供应来源标识组装的访问地址
	private List<ResponsibilityVo> responsibilityVoList;//保障责任
	/**
	 * 分销商标识
	 */
	private String recommend_code;

	public String getOid() {
		return oid;
	}

	public void setOid(String oid) {
		this.oid = oid;
	}

	public String getTrade_serial_number() {
		return trade_serial_number;
	}

	public void setTrade_serial_number(String trade_serial_number) {
		this.trade_serial_number = trade_serial_number;
	}

	public String getPay_order_number() {
		return pay_order_number;
	}

	public void setPay_order_number(String pay_order_number) {
		this.pay_order_number = pay_order_number;
	}

	public String getPolicy_serial_number() {
		return policy_serial_number;
	}

	public void setPolicy_serial_number(String policy_serial_number) {
		this.policy_serial_number = policy_serial_number;
	}

	public String getExternal_reference() {
		return external_reference;
	}

	public void setExternal_reference(String external_reference) {
		this.external_reference = external_reference;
	}

	public String getShow_url() {
		return show_url;
	}

	public void setShow_url(String show_url) {
		this.show_url = show_url;
	}

	public String getProduct_name() {
		return product_name;
	}

	public void setProduct_name(String product_name) {
		this.product_name = product_name;
	}

	public String getInsurance_name() {
		return insurance_name;
	}

	public void setInsurance_name(String insurance_name) {
		this.insurance_name = insurance_name;
	}

	public String getStart_time() {
		return start_time;
	}

	public void setStart_time(String start_time) {
		this.start_time = start_time;
	}

	public String getInception_date() {
		return inception_date;
	}

	public void setInception_date(String inception_date) {
		this.inception_date = inception_date;
	}

	public String getPlanned_end_date() {
		return planned_end_date;
	}

	public void setPlanned_end_date(String planned_end_date) {
		this.planned_end_date = planned_end_date;
	}

	public String getGross_premium() {
		return gross_premium;
	}

	public void setGross_premium(String gross_premium) {
		this.gross_premium = gross_premium;
	}

	public String getInsured_amount() {
		return insured_amount;
	}

	public void setInsured_amount(String insured_amount) {
		this.insured_amount = insured_amount;
	}

	public String getPolicy_status() {
		return policy_status;
	}

	public void setPolicy_status(String policy_status) {
		this.policy_status = policy_status;
	}

	public String getProduct_oid() {
		return product_oid;
	}

	public void setProduct_oid(String product_oid) {
		this.product_oid = product_oid;
	}

	public String getProduct_code() {
		return product_code;
	}

	public void setProduct_code(String product_code) {
		this.product_code = product_code;
	}

	public String getApplicant_name() {
		return applicant_name;
	}

	public void setApplicant_name(String applicant_name) {
		this.applicant_name = applicant_name;
	}

	public String getInsured_role() {
		return insured_role;
	}

	public void setInsured_role(String insured_role) {
		this.insured_role = insured_role;
	}

	public String getFees_for() {
		return fees_for;
	}

	public void setFees_for(String fees_for) {
		this.fees_for = fees_for;
	}

	public String getPay_methods() {
		return pay_methods;
	}

	public void setPay_methods(String pay_methods) {
		this.pay_methods = pay_methods;
	}

	public String getPolicy_currency() {
		return policy_currency;
	}

	public void setPolicy_currency(String policy_currency) {
		this.policy_currency = policy_currency;
	}

	public String getBusiness_scope() {
		return business_scope;
	}

	public void setBusiness_scope(String business_scope) {
		this.business_scope = business_scope;
	}

	public String getRemarks() {
		return remarks;
	}

	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}

	public String getLogin_name() {
		return login_name;
	}

	public void setLogin_name(String login_name) {
		this.login_name = login_name;
	}

	public String getInsure_path() {
		return insure_path;
	}

	public void setInsure_path(String insure_path) {
		this.insure_path = insure_path;
	}

	public String getReseller_name() {
		return reseller_name;
	}

	public void setReseller_name(String reseller_name) {
		this.reseller_name = reseller_name;
	}

	public String getRecommend_code() {
		return recommend_code;
	}

	public void setRecommend_code(String recommend_code) {
		this.recommend_code = recommend_code;
	}

	public String getUser_oid() {
		return user_oid;
	}

	public void setUser_oid(String user_oid) {
		this.user_oid = user_oid;
	}

	public String getUser_insure_path() {
		return user_insure_path;
	}

	public void setUser_insure_path(String user_insure_path) {
		this.user_insure_path = user_insure_path;
	}

	public String getLg_path() {
		return lg_path;
	}

	public void setLg_path(String lg_path) {
		this.lg_path = lg_path;
	}

	public String getProduct_type() {
		return product_type;
	}

	public void setProduct_type(String product_type) {
		this.product_type = product_type;
	}

	public List<ResponsibilityVo> getResponsibilityVoList() {
		return responsibilityVoList;
	}

	public void setResponsibilityVoList(List<ResponsibilityVo> responsibilityVoList) {
		this.responsibilityVoList = responsibilityVoList;
	}

	public String getPay_order_url() {
		return pay_order_url;
	}

	public void setPay_order_url(String pay_order_url) {
		this.pay_order_url = pay_order_url;
	}

	public String getClassify_name() {
		return classify_name;
	}

	public void setClassify_name(String classify_name) {
		this.classify_name = classify_name;
	}

	public String getInsurance_oid() {
		return insurance_oid;
	}

	public void setInsurance_oid(String insurance_oid) {
		this.insurance_oid = insurance_oid;
	}

	public String getInsurance_logo() {
		return insurance_logo;
	}

	public void setInsurance_logo(String insurance_logo) {
		this.insurance_logo = insurance_logo;
	}

	public String getNotice_no() {
		return notice_no;
	}

	public void setNotice_no(String notice_no) {
		this.notice_no = notice_no;
	}

	public String getIs_send_yx() {
		return is_send_yx;
	}

	public void setIs_send_yx(String is_send_yx) {
		this.is_send_yx = is_send_yx;
	}

	public String getWeb_type() {
		return web_type;
	}

	public void setWeb_type(String web_type) {
		this.web_type = web_type;
	}

	public String getWeb_id() {
		return web_id;
	}

	public void setWeb_id(String web_id) {
		this.web_id = web_id;
	}

	public String getPremium() {
		return premium;
	}

	public void setPremium(String premium) {
		this.premium = premium;
	}

	public String getIs_policy_before_pay_fee() {
		return is_policy_before_pay_fee;
	}

	public void setIs_policy_before_pay_fee(String is_policy_before_pay_fee) {
		this.is_policy_before_pay_fee = is_policy_before_pay_fee;
	}

	public String getCustomRemarks() {
		return customRemarks;
	}

	public void setCustomRemarks(String customRemarks) {
		this.customRemarks = customRemarks;
	}

	public String getSource() {
		return source;
	}

	public void setSource(String source) {
		this.source = source;
		if(StringUtils.isNotEmpty(source)){
			this.headurl = GlobalResources.getResource("BUSINESS_"+source+"_URL");
		}
	}

	public String getHeadurl() {
		return headurl;
	}

	public String getInception_type() {
		return inception_type;
	}

	public void setInception_type(String inception_type) {
		this.inception_type = inception_type;
	}

	public String getInception_long() {
		return inception_long;
	}

	public void setInception_long(String inception_long) {
		this.inception_long = inception_long;
	}

	public String getIs_contain_repo() {
		return is_contain_repo;
	}

	public void setIs_contain_repo(String is_contain_repo) {
		this.is_contain_repo = is_contain_repo;
	}

	public String getAmount() {
		return amount;
	}

	public void setAmount(String amount) {
		this.amount = amount;
	}
}
