package com.bcxin.ins.vo;

import java.text.SimpleDateFormat;

/**
 * 常量字段库
 * @author luopeng
 *
 */
public interface ConstProp  {

	/** 通信类型字符 http相关 */
	public final static String ENCODE_UTF8 = "UTF-8"; //字符集编码UTF-8
	public final static String ENCODE_UTF8_TEXT = "text/html; charset=UTF-8"; //字符集编码UTF-8
	public final static String ENCODE_GBK = "gbk";
	public final static String ENCODE_ISO8859_1 = "iso8859-1";
	public final static String ENCODE_ISO_8859_1 = "iso-8859-1";
	public final static String CT_JSON = "application/json"; //ContentType1
	public final static String CT_OCTET_STREAM = "application/octet-stream; charset=utf-8"; //ContentType2
	public final static String CT_OS = "octets/stream";
	public final static String CONTENT_DISPOSITION = "Content-Disposition";
	public final static String CONTENT_LENGTH = "Content-Length";
	public final static String CONTENT_TYPE = "Content-Type";
	public final static String ATTACHMENT_FILENAME = "attachment;filename=";

	/** 文档类型字符 */
	public final static String XLS = "xls"; //excel 1997-2003格式
	public final static String XLSX = "xlsx"; //excel 2003-2011格式
	public final static String IMAGE_FORM = "jpg|jpeg|gif|png|bmp|JPG|JPEG|GIF|PNG|BMP"; //图片格式

	public final static String COMMON_EXPORT = "1";//企业短期出口
	public final static String MICRO_EXPORT = "2";//小微企业短期

	public final static String SIGN_COM = "1";//法人
	public final static String SIGN_PER = "2";//个人

	public final static String ROLE_APPLICANT = "1"; //投保人
	public final static String ROLE_INSURED = "2"; //被保人
	public final static String APPANDINS = "3"; //投保人或被保人

	/** String类型数字 */
	public final static String DIGIT_ZERO = "0"; //阿拉伯数字0
	public final static String DIGIT_ONE = "1"; //阿拉伯数字1
	public final static String DIGIT_TWO = "2"; //阿拉伯数字2
	public final static String DIGIT_THREE = "3"; //阿拉伯数字3
	public final static String DIGIT_FOUR = "4"; //阿拉伯数字4
	public final static String DIGIT_FIVE = "5"; //阿拉伯数字5
	public final static String DIGIT_SIX = "6"; //阿拉伯数字6
	public final static String DIGIT_EIGHT = "8"; //阿拉伯数字8
	public final static String DIGIT_NINE = "9"; //阿拉伯数字9
	public final static String DIGIT_TWELVE = "12"; //阿拉伯数字15
	public final static String DIGIT_THIRTEEN = "13"; //阿拉伯数字15
	public final static String DIGIT_FIFTEEN = "15"; //阿拉伯数字15
	public final static String DIGIT_SIXTEEN = "16"; //阿拉伯数字15

	/** int类型数字 */
	public final static Integer INT_NUMBER_ZERO = 0;
	public final static Integer INT_NUMBER_ONE = 1;
	public final static Integer INT_NUMBER_TWO = 2;
	public final static Integer INT_NUMBER_THREE = 3;
	public final static Integer INT_NUMBER_FOUR = 4;
	public final static Integer INT_NUMBER_FIVE = 5;
	public final static Integer INT_NUMBER_SIX = 6;
	public final static Integer INT_NUMBER_MINUS_ONE = -1;
	public final static Integer INT_NUMBER_WORKERID = 31;

	/** 标点符号*/
	public final static String BLANK_CHAR = ""; //空字符串
	public final static String SEPARATOR = "\\."; //分隔符 分割文件名
	public final static String SLASH = "/"; //斜杠
	public final static String COLON = ":"; //冒号
	public final static String SEMICOLON = ";"; //分号
	public final static String MINUS = "-"; //减号
	public final static String DOT = "."; //点
	public final static String COMMA = ","; //逗号
	public final static String UNDERLINE = "_"; //下划线
	public final static String COLON_SLASH = "://"; //斜杠冒号
	public final static String DOLLAR = "$"; //美元符号
	public final static String POUND_SIGN = "#"; //井符号
	public final static String NULLSTRING = "<br/>"; //空行

	public final static String BOOLEAN_Y = "Y"; //布尔值y
	public final static String BOOLEAN_N = "N"; //布尔值n
	public final static String CODE_SUCCESS = "200"; //code值成功
	public final static String CODE_SUCCESS_EMP = "201"; //code值成功
	public final static String CODE_FAILURE = "300"; //code值失败
	public final static String CODE_TOKEN_EXPIRED = "401"; //code值失败token

	/** 数据传输常用字符串，接口输出数据名 */
	public final static String YHM_EN = "email:"; //发送用户名标识
	public final static String PRO_QR_CODE = "qr_code:"; //微信扫码标识
	public final static String PRO_R_CODE = "r_code:"; //
	public final static String TB_IPD_LIST = "ipdVoList:"; //
	public final static String TB_RS_LIST = "rsVoList:"; //
	public final static String TB_IPRS_LIST = "iprsVoList:"; //
	public final static String YH_RESETPWDEMAIL = "resetPwdEmail:"; //
	public final static String YH_RESETTYPE = "resetType:"; //
	public final static String YZM_AUAC = "authenticationAgainCode:"; //发送验证码头标识
	public final static String YZM_AC = "authenticationCode:"; //发送验证码头标识
	public final static String YZM_CCKEY = "checkCodekeyword:"; //发送验证码头标识
	public final static String YZM_EN = "yzkeyword:"; //验证码头标识
	public final static String CONTEXT = "context"; //上下文，一般保存保单对象
	public final static String REPORT_KEY="SFJJSKFJMW%^@234J41A5DSFAHI";
	public final static String RECOMMENDCODE="recommendCode";
	public final static String RECOMMEND_CODE="recommend_code";
	public final static String ORDER_ID = "order_id";
	public final static String ANVO = "anVo";
	public final static String PATH_SIGN = "path_sign";
	public final static String NOWTIME = "nowTime";
	public final static String USERDETAIL = "userdetail";
	public final static String SHAREPATH = "sharePath";
	public final static String PRODUCTDTO = "productDto";
	public final static String ORDERLIST = "orderList";
	public final static String LISTVO = "listVo";
	public final static String ROLE = "ROLE";
	public final static String PRESERVE = "PRESERVE";
	public final static String PROVINCELIST = "provinceList";
	public final static String CITYLIST = "cityList";
	public final static String AREALIST = "areaList";
	public final static String BANKCITYLIST = "bankCityList";
	public final static String REG_CITYLIST = "reg_cityList";
	public final static String REG_AREALIST = "reg_areaList";
	public final static String REG_CITY_1_LIST = "reg_city_1_List";
	public final static String REG_AREA_1_LIST = "reg_area_1_List";
	public final static String REG_ROLE = "reg_role";
	public final static String REG_ROLE_1 = "reg_role_1";
	public final static String REG_RULE = "reg_rule";
	public final static String REG_POLICY = "reg_policy";
	public final static String VO = "vo";
	public final static String VO1 = "vo1";
	public final static String VO2 = "vo2";
	public final static String VO3 = "vo3";
	public final static String DTO = "dto";
	public final static String PD = "pd";

	public final static String RET = "ret";
	public final static String MSG = "msg";
	public final static String RESULT = "result";
	public final static String MESSAGE = "message";
	public final static String STATUS = "status";

	/** 产品保障名称 */
	public final static String PRODUCT_GUARANTEE_YW = "意外伤害保险金";
	public final static String PRODUCT_GUARANTEE_ZR = "保安员雇主责任";

	/** saveOrderInfo接口参数字段 */
	public final static String SAVEORDERINFO_DATA_COUNT = "count";
	public final static String SAVEORDERINFO_DATA_IEA = "insuranceEscortAmount";
	public final static String SAVEORDERINFO_DATA_IA = "insuranceamount";
	public final static String SAVEORDERINFO_DATA_USERID = "user_id";
	public final static String SAVEORDERINFO_DATA_ORDERNO = "orderNo";
	public final static String SAVEORDERINFO_DATA_CARDLIST = "cardList";


	/** 公用默认标识 */
	public final static String DEFAULT_X = "DEFAULT";
	public final static String DEFAULT_N = "default";

	/** 产品标识代码相关 */
	public final static String XYX_DQCK = "XYX-DQCK";//企业出口
	public final static String XYX_XWCK = "XYX-XWCK";//小微出口
	public final static String GCTB = "GCTB";//工程投标
	public final static String GCLY = "GCLY";//工程履约
	public final static String BZX_TB_GCTB = "BZX-TB-GCTB";//太保工程投标
	public final static String BZX_YG_GCTB = "BZX-YG-GCTB";//阳光投标
	public final static String BZX_DB_GCTB = "BZX-DB-GCTB";//都邦投标
	public final static String BZX_GCLY = "BZX-GCLY";//太保工程履约
	public final static String BZX_SSBQ = "BZX-SSBQ";//诉讼
	public final static String GZX_HT = "GZX-HT";//华泰公责险
	public final static String GZX_PAC = "GZX-PAC";//平安财公责险
	public final static String GZX_CA = "GZX-CA";//长安公责险
	public final static String ZZX = "ZZX";//展责险
	public final static String GZZRX = "GZZRX";//雇主责任险
	public final static String GZZRX_RB = "GZZRX-RB";//人保雇主责任险
	public final static String GZZRX_QH = "GZZRX-QH";//前海雇主责任险
	public final static String GZZRX_ZH = "GZZRX-ZH";//中华雇主责任险
	public final static String GZZRX_TB = "GZZRX-TB";//太保雇主责任险
	public final static String GZZRX_XZH = "GZZRX-XZH";//新保险方案的中华雇主责任险
	public final static String GZZRX_PAC = "GZZRX-PAC";//平安财雇主责任险
	public final static String GZZRX_CA = "GZZRX-CA";//长安雇主责任险
	public final static String GZZRX_CA_DQ = "GZZRX-CA-DQ";//长安短期雇主责任险
	public final static String GYX_TB = "GYX-TB";//太保个意险
	public final static String GYX_CA = "GYX-CA";//长安个意险
	public final static String GYX = "GYX";//个意险
	public final static String GZX = "GZX";//公责险
	public final static String TYX = "TYX";//团意险
	public final static String TYX_PAS = "TYX-PAS";//平安团意险
	public final static String TYX_PAC = "TYX-PAC";//平安财团意险
	public final static String TYX_TK = "TYX-TK";//泰康团意险
	public final static String TYX_RB = "TYX-RB";//人保团意险
	public final static String TYX_CA = "TYX-CA";//长安团意险
	public final static String TYX_QH = "TYX-QH";//前海团意险
	public final static String TYX_QH_DQ = "TYX-QH-DQ";//前海短期团意险
	public final static String TYX_HT_DQ = "TYX-HT-DQ";//华泰短期团意险

	public final static String TYX_HT = "TYX-HT";//华泰团意险
	public final static String ZZX_ZA = "ZZX-ZA";//众安展责险
	public final static String ZZX_ZA_1 = "ZZX-ZA-1";//众安展责险1
	public final static String ZZX_ZA_2 = "ZZX-ZA-2";//众安展责险2
	public final static String ZZX_ZA_3 = "ZZX-ZA-3";//众安展责险3
	public final static String ZZX_PAC = "ZZX-PAC";//平安财展责险
	public final static String ZZX_HT = "ZZX-HT";//华泰展责险
	public final static String ZZX_YA = "ZZX-YA";//永安展责险
	public final static String ZZX_CA = "ZZX-CA";//长安展责险

	/** 平台标识 */
	public final static String ARS = "ARS";//百保盾
	public final static String BLB = "BLB";//百联保
	public final static String BLB_S = "blb";//百联保
	public final static String SAAS = "SAAS";//SAAS
	public final static String LINBAO = "LINBAO";//LINBAO
	public final static String PASP = "PASP";//PASP 基础支撑
	public final static String PSS = "PSS";//PSS
	public final static String ESTAND_PSS = "ESTAND-PSS";//ESTAND_PSS
	public final static String BACY = "BACY";//保安从业

	/** 日期相关 */
	public final static String DAY_00 = " 00:00:00";//用于补齐日期具体时间
	public final static String DAY_23 = " 23:59:59";//用于补齐日期具体时间

	/** 保障类型 */
	public final static String INCEPTION_TYPE_YEAR = "1";//按年
	public final static String INCEPTION_TYPE_MONTH = "2";//按月

	/** 省标志 */
	public final static String SXI = "610000";//陕西
	public final static String GXI = "450000";//广西
	public final static String NX = "640000";//宁夏
	public final static String BJ = "110000";//北京

	/** 华为短信发送相关常量 */
	public final static String SMSPLATFORM_BCXIN = "BCXIN";//平台标识（当前公共）
	public final static String SMSPLATFORM_BLB = "BLB";//平台标识（当前百联保）
	public final static String SMSCODE_P01 = "P01";//尊敬的客户，你的校验码为{}，工作人员不会索取此验证码，请勿泄露，如有疑问，请致电4006629696咨询
	public final static String SMSCODE_B1 = "B1";//尊敬的客户，您好！您投保的{}已经承保成功，保单号：{}，保单生效日期：{}。如有疑问，请致电4006629696咨询。
	public final static String SMSCODE_B2 = "B2";//尊敬的客户，您好！您投保的${}承保失败，请及时致电4006629696进行咨询。
	public final static String SMSCODE_B3 = "B3";//您好！有新订单生成！请及时登录保险保函网（http://www.bailianbao.cn）进行查看。
	public final static String SMSCODE_B4 = "B4";//您好！保险公司已核保通过，请及时登录保险保函网（http://www.bailianbao.cn）进行查看。
	public final static String SMSCODE_B5 = "B5";//您好！用户已缴费，请及时登录保险保函网（http://www.bailianbao.cn）进行查看。
	public final static String SMSCODE_B6 = "B6";//您好！保险公司已上传保单、保函，请及时登录保险保函网（http://www.bailianbao.cn）进行查看。
	public final static String SMSCODE_B7 = "B7";//尊敬的用户，您于{}在保险平台提交的保全申请单（{}[{}]，暂批单号：{}）已被退回。请及时处理，以免影响您的后续操作。
	public final static String SMSCODE_B8 = "B8";//尊敬的用户，您在保险平台提交的保全申请单（{}[{}]，暂批单号：{}）已通过审核。生效日期为：${}。
	public final static String SMSCODE_B9 = "B9";//尊敬的用户，您于{}至{}在保险平台的保全缴费单已生成。保全费用共：{}元。请及时处理，以免影响您的后续保障。

	public final String REDIS_HEAD_CPOY = "BLB:CACHE:COPY-";//复制订单缓存头标识
	public final String REDIS_HEAD_UID = "BLB:CACHE:UIP-";//缓存token缓存头标识
	public final String REDIS_HEAD_UIP = "BLB:CACHE:UIP-";//ip+url地址缓存头标识
	public final String REDIS_HEAD_CIP = "BLB:CACHE:CIP-";//ip核对编码缓存头标识
	public final String REDIS_HEAD_SAAS_TOKEN = "BLB:CACHE:SAAS-REQ-TOKEN-";//来源为saas时blb生成的token
	public final String REDIS_HEAD_BLB_TOKEN = "BLB:CACHE:BLB-REQ-TOKEN-";//blb自身生成的token
	public final String REDIS_HEAD_THR_TOKEN = "BLB:CACHE:THR-REQ-TOKEN-";//源为第三方时blb生成的token
	public final String REDIS_HEAD_POLICY_ID = "BLB:CACHE:POLICY-ID-";//订单缓存头标识
	public final String REDIS_HEAD_POLICY_PD_SIGN = "BLB:CACHE:POLICY-PD-SIGN-";//批单操作标记缓存头标识
	public final String REDIS_HEAD_POLICY_NO = "BLB:CACHE:POLICY-NO-";//保单号缓存头标识
	public final String REDIS_HEAD_PRODUCT_PCO = "BLB:CACHE:PRODUCT-PCO-";//产品编码缓存头标识
	public final String REDIS_HEAD_PRODUCT_RESPONSIBILITY = "BLB:CACHE:PRODUCT-RESPONSIBILITY-";//产品保障信息缓存头标识
	public final String REDIS_HEAD_PRODUCT_ID = "BLB:CACHE:PRODUCT-ID-";//产品ID缓存头标识
	public final String REDIS_HEAD_PROCACHE = "BLB:CACHE:PROCACHE";//产品缓存头标识
	public final String REDIS_HEAD_POLICYS = "BLB:CACHE:POLICYS-";//保单缓存头标识
	public final String REDIS_HEAD_INS = "BLB:CACHE:INS-";//保单投保人员缓存头标识
	public final String ADDRESS_HEAD = "ADDRESS-";//缓存key的前部分

	public final static Integer ONE_MONTH_TIMEOUT_SECONDS = 30 * 24 * 60 * 60; // 一月过期时间(秒)
	public final static Integer ONE_DAY_TIMEOUT_SECONDS = 24 * 60 * 60; // 一天过期时间(秒)
	public final static Integer THREE_HOURS_TIMEOUT_SECONDS = 3 * 60 * 60; // 3小时过期时间(秒)
	public final static Integer ONE_HOURS_TIMEOUT_SECONDS = 1 * 60 * 60; // 1小时过期时间(秒)
	public final static Integer FIVE_MINUTES_TIMEOUT_SECONDS = 5 * 60; // 5分钟过期时间(秒)
	public final static Integer THREE_MINUTES_TIMEOUT_SECONDS = 3 * 60; // 3分钟过期时间(秒)
}
