package com.bcxin.ins.vo;

import lombok.Data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * <b>企业短期业务页1交互辅助类 </b>
 *
 * @author zxf
 * @date 2017年1月5日 上午10:13:58
 * @注意事项 </b>
 * <b>
 */
@Data
public class CommonExportVo_1 extends BaseVo{


    /**
     * 订单id
     */
    private String oid;

    /**
     * 产品id
     */
    private String product_id;

    /**
     * 投保人信息
     */
    private List<RoleSubjectVo> roleSubjectList;
    /**
     * 投保之产品或服务
     */
    private String product_service;
    /**
     * 业务的特殊性
     */
    private String particularity;
    /**
     * 合同中是否有物权保留条款
     */
    private Integer is_retention_contract;
    /**
     * 销售常用的付款方式
     */
    private String payment_terms;
    /**
     * 否为买家提供较长赊账期
     */
    private String period_extended;
    /**
     * 现金交易占比
     */
    private BigDecimal breakdowns_cash;
    /**
     * 信用证交易占比
     */
    private BigDecimal breakdowns_lc;
    /**
     * 关联交易占比
     */
    private BigDecimal breakdowns_associated;
    /**
     * 赊账交易占比
     */
    private BigDecimal breakdowns_oa;
    /**
     * 托收交易占比
     */
    private BigDecimal breakdowns_dpda;
    /**
     * 交易占比合计
     */
    private BigDecimal breakdowns_sum;
    /**
     * 分销商标识
     */
    private String recommend_code;

    /**
     * 标识id
     */
    private String sigId;
    /**
     * 预计未来一年内所须投保的信用销售总额（按国别分类）
     */
    private List<ForecastedDetailVo> forecastedDetailList;
    /**
     * 最近三年销售记录表
     */
    private List<RecentYearsSellVo> recentYearsSellList;

    /**
     * 产品保障责任
     */
    private List<ResponsibilityVo> responsibilityVoList = new ArrayList<ResponsibilityVo>();
}