package com.bcxin.ins.util.http;

import com.alibaba.fastjson.JSON;
import com.bcxin.ins.core.entity.SysLogSms;
import com.bcxin.ins.core.util.HttpUtil;
import com.bcxin.ins.dto.Result;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.MD5Util;
import com.google.common.collect.Lists;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

import java.util.Date;
import java.util.List;

/**
 * <b> 发送短信的工具类 </b>
 * @author ZXF
 * @create 2019/06/14 0014 9:48
 * @version
 * @注意事项 </b>
 */
public class SMSUtil {

	/**
	 * 发送华为短信
	 * @param huaWeiSmsContent
	 * @return
	 */
	public static Result sendHuaWeiSMS(HuaWeiSmsContent huaWeiSmsContent) {
		String url = "http://msg.bcxin.com.cn:9165/sms/huawei/sendSMS";
		List<NameValuePair> params = Lists.newArrayList();
		params.add(new BasicNameValuePair("data", JSON.toJSONString(huaWeiSmsContent)));
		params.add(new BasicNameValuePair("token", MD5Util.string2MD5("BCXIN" + huaWeiSmsContent.getMobile() + DateUtil.getCurrentDate())));
		HttpUtil.doPost(url,params);
		return Result.success("短信发送成功");
	}

}
